(("en" (("fluxa" ("Fluxa is the fluxus audio synth for livecoding, it contains quite basic atomic components which can be used together to create more complicated sounds. It uses an experimental and fairly brutal method of graph node garbage collection which gives it certain non-deterministic qualities. It's also been battle tested in many a live performance. The fluxa server needs to be run and connected to jack in order for you to hear anything. Also, fluxa is not in the default namespace, so use eg (require fluxus-017/fluxa)." "" (("reload" ("" "void" "Causes samples to be reloaded if you need to restart the fluxa server" " (reload)\n")) ("sine" ("frequency-number-or-node" "node-id-number" "Creates a sine wave generator node" " (play-now (mul (sine 440) (adsr 0.1 0.1 0 0)))\n")) ("saw" ("frequency-number-or-node" "node-id-number" "Creates a saw wave generator node" " (play-now (mul (saw 440) (adsr 0.1 0.1 0 0)))\n")) ("tri" ("frequency-number-or-node" "node-id-number" "Creates a triangle wave generator node" " (play-now (mul (tri 440) (adsr 0.1 0.1 0 0)))\n")) ("squ" ("frequency-number-or-node" "node-id-number" "Creates a square wave generator node" " (play-now (mul (squ 440) (adsr 0.1 0.1 0 0)))\n")) ("white" ("frequency-number-or-node" "node-id-number" "Creates a white noise generator node" " (play-now (mul (white 5) (adsr 0.1 0.1 0 0)))\n")) ("pink" ("frequency-number-or-node" "node-id-number" "Creates a pink noise generator node" " (play-now (mul (pink 5) (adsr 0.1 0.1 0 0)))\n")) ("add" ("number-or-node number-or-node" "node-id-number" "Maths node - adds two signals together" " (play-now (mul (add (sine 440) (sine 220)) (adsr 0.1 0.1 0 0)))\n")) ("sub" ("number-or-node number-or-node" "node-id-number" "Maths node - subtracts two signals" " (play-now (mul (sub (sine 440) (sine 220)) (adsr 0.1 0.1 0 0)))\n")) ("mul" ("number-or-node number-or-node" "node-id-number" "Maths node - multiplies two signals" " (play-now (mul (mul (sine 440) (sine 220)) (adsr 0.1 0.1 0 0)))\n")) ("div" ("number-or-node number-or-node" "node-id-number" "Maths node - divides two signals" " (play-now (mul (div (sine 440) 2) (adsr 0.1 0.1 0 0)))\n")) ("pow" ("number-or-node number-or-node" "node-id-number" "Maths node - produces a signal raised to the power of another" " (play-now (mul (pow (adsr 0 0.1 0 0) 10) (sine 440)))\n")) ("adsr" ("attack-number-or-node decay-number-or-node sustain-number-or-node release-number-or-node" "node-id-number" "Creates an envelope generator node" " (play-now (mul (sine 440) (adsr 0.1 0.1 0 0)))\n")) ("mooglp" ("signal-node cutoff-number-or-node resonance-number-or-node" "node-id-number" "Creates an low pass moog filter node" " (play-now (mul (mooglp (squ 440) 0.1 0.4) (adsr 0.1 0.1 0 0)))\n")) ("moogbp" ("signal-node cutoff-number-or-node resonance-number-or-node" "node-id-number" "Creates an band pass moog filter node" " (play-now (mul (moogbp (squ 440) 0.1 0.4) (adsr 0.1 0.1 0 0)))\n")) ("mooghp" ("signal-node cutoff-number-or-node resonance-number-or-node" "node-id-number" "Creates an high pass moog filter node" " (play-now (mul (mooghp (squ 440) 0.1 0.4) (adsr 0.1 0.1 0 0)))\n")) ("formant" ("signal-node cutoff-number-or-node resonance-number-or-node" "node-id-number" "Creates a formant filter node" " (play-now (mul (formant (squ 440) 0.1 0.4) (adsr 0.1 0.1 0 0)))\n")) ("sample" ("sample-filename-string frequency-number-or-node" "node-id-number" "Creates a sample playback node" " (play-now (sample \"helicopter.wav\" 440))\n")) ("crush" ("signal-node frequency-number-or-node bit-depth-number-or-node" "node-id-number" "Creates a crush effect node" " (play-now (crush (sine 440) 0.4 8))\n")) ("distort" ("signal-node amount-number-or-node" "node-id-number" "Creates a distortion effect node" " (play-now (distort (sine 440) 0.9))\n")) ("klip" ("signal-node amount-number-or-node" "node-id-number" "Creates a hard clipping distortion effect node" " (play-now (klip (sine 440) 0.9))\n")) ("echo" ("signal-node delay-time-number-or-node feedback-number-or-node" "node-id-number" "Creates a echo effect node" " (play-now (echo 3 (sine 440)))\n")) ("play" ("time node" "void" "Plays a supplied node at the specified time." " (play (+ (time-now) 10) (mul (adsr 0 0.1 0 0) (sine 440)))\n")) ("play-now" ("node" "void" "Plays a supplied node as soon as possible" " (play-now (mul (adsr 0 0.1 0 0) (sine 440)))\n")) ("fluxa-debug" ("true-or-false" "void" "Turns on or off fluxa debugging, the server will print information out to stdout" " (fluxa-debug #t)\n")) ("volume" ("amount-number" "void" "Sets the global volume" " (volume 2.5)\n")) ("pan" ("pan-number" "void" "Sets the global pan where -1 is left and 1 is right (probably)" " (pan 0)\n")) ("max-synths" ("number" "void" "Sets the maximum amount of synth graphs fluxa will run at the same time. This is a processor usage safeguard, when the count is exceeded the oldest synth graph will be stopped so it's nodes can be recycled. The default count is 10." " (max-synths 10)\n")) ("searchpath" ("path-string" "void" "Add a searchpath to use when looking for samples" " (searchpath \"/path/to/my/samples/)\n")) ("eq" ("bass-number middle-number high-number" "void" "Sets a simple global equaliser. This is more as a last resort when performing without a mixer." " (eq 2 1 0.5) ; bass boost\n")) ("comp" ("attack-number release-number threshold-number slope-number" "void" "A global compressor. Not sure if this works yet." " (comp 0.1 0.1 0.5 3)\n")) ("note" ("note-number" "frequency-number" "Returns the frequency for the supplied note. Fluxa uses just intonation by default." " (note 35)\n")) ("reset" ("" "void" "Resets the fluxa server." " (reset)\n")) ("clock-map" ("" "void" "A way of using lists as sequences. The lists can be of differing length, leading to polyrhythms." " (seq (lambda (time clock)\n    (clock-map\n      (lambda (nt cutoff)\n        (play time (mul (adsr 0 0.1 0 0)\n          (mooglp (saw (note nt)) cutoff 0.4))))\n      clock\n      (list 39 28 3)\n      (list 0.1 0.1 0.4 0.9))))\n")) ("zmod" ("clock-number count-number" "true-or-false" "Just shorthand for (zero? (modulo clock-number count-number)), as it can be used a lot." " (seq (lambda (time clock)\n     (when (zmod clock 4) ; play the note every 4th beat\n         (play time (mul (adsr 0 0.1 0 0) (sine (note nt)))))))\n")) ("seq" ("proc" "void" "Sets the global fluxa sequence procedure, which will be called automatically in order to create new events. seq can be repeatedly called to update the procedure as in livecoding." " (seq (lambda (time clock)\n     (when (zmod clock 4) ; play the note every 4th beat\n         (play time (mul (adsr 0 0.1 0 0) (sine (note nt)))))))\n"))))) ("high-level-scratchpad-docs" ("Some useful high level documentation lives here, this won't make much sense if you are reading this in a different place from the help system in the fluxus scratchpad app, but it might be useful anyway..." "" (("tophelp" ("" "" "" " Fluxus documentation\n --------------------\n \"act of a flowing; a continuous moving on or passing by, as of a\n flowing stream; a continuous succession of changes\"\n\n Fluxus is a realtime rendering engine for livecoding in Scheme.\n For more detailed docs, see: fluxus/docs/fluxus-documentation.txt\n\n The fluxus scratchpad has two modes of operation, the console\n (you are using this now) which allows you to enter commands and\n see the results immediately. The other mode is the editor which\n is more like a normal text editor - there are 9 workspaces,\n (which allow you to edit more than one script at once) switch to\n them using ctrl-1 to ctrl-9 and switch back to the console with\n ctrl-0.\n\n To copy/paste examples, hit the right cursor until you move behind\n the prompt, navigate to the example, use shift to select it,\n press ctrl-c to copy, then ctrl-0 and ctrl-v to paste into a\n text buffer.\n\n More help topics:\n (help \"keys\") for keyboard commands for controlling fluxus\n (help \"console\") for more help on the console\n (help \"editor\") for more help on the livecoding editor\n (help \"camera\") for help on the camera controls\n (help \"language\") for more info on the fluxus commands\n (help \"misc\") for miscellaneous fluxus info\n (help \"toplap\") for the toplap manefesto\n (help \"authors\") who made this?\n")) ("keys" ("" "" "" " Fluxus keys\n -----------\n\n ctrl-f : Fullscreen mode.\n ctrl-w : Windowed mode.\n ctrl-h : Hide/show the text.\n ctrl-l : Load a new script (navigate with cursors and return).\n ctrl-s : Save current script.\n ctrl-d : Save as - current script (opens a filename dialog).\n ctrl-p : Auto format the whitespace in your scheme script to be more pretty\n ctrl-b : Show where cursor is.\n ctrl-1 to 9 : Switch to selected workspace.\n ctrl-0 : Switch to the REPL. F3 : Resets the camera if you get lost.\n F5 : (or ctrl-e) Executethe selected text, or all if none is selected.\n F6 : Completely resets the interpreter, then executes the selected text,\n      or all if none is selected.\n F9 : Toggles scratchpad effects.\n F10 : Decreases the text opacity\n F11 : Increases the text opacity\n F12 : Pauses keypress file playback.\n")) ("console" ("" "" "" " Fluxus console (or REPL) ------------------------\n\n If you press ctrl and 0, instead of getting another script\n workspace, you will be presented with a Read EvaluatePrint\n Loop interpreter, or repl for short. This is really just an\n interactive interpreter similar to the commandline, where\n you can enter scheme code for immediate evaluation. This code\n is evaluated in the same interpreter as the other scripts, so\n you can use the repl to debug or inspect global variables and\n functions they define. This window is also where error\n reporting is printed, along with the terminal window you\n started fluxus from.\n")) ("editor" ("" "" "" " Fluxus editor\n -------------\n\n When using the fluxus scratchpad, the idea is that you only\n need the one window to build scripts, or play live. f5 is the\n key that runs the script when you are ready.  Selecting some\n text (using shift) and pressing f5 will execute the selected\n text only. This is handy for reevaluating functions without\n running the whole script each time.\n\n Workspaces\n ----------\n\n The script editor allows you to edit 9 scripts simultaneously\n by using workspaces. To switch workspaces, use ctrl+number\n key. Only one can be run at once though, hitting f5 will\n execute the currently active workspace script.\n\n Auto focus\n ----------\n\n The editor includes an auto scaling/centering feature which is\n enabled by default. To disable it - add the line:\n (set! fluxus-scratchpad-do-autofocus 0)\n to your .fluxus.scm file - or create a new file called that in\n your home directory, containing that line.\n")) ("camera" ("" "" "" " Fluxus camera control\n ---------------------\n\n The camera is controlled by moving the mouse and pressing\n mouse buttons.\n\n Left mouse button: Rotate\n Middle mouse button: Move\n Right mouse button: Zoom\n")) ("misc" ("" "" "" " Fluxus init script\n ------------------\n Fluxus looks for a script in your home directory called\n .fluxus.scm which it will run if it is found. This is useful\n for putting init commands (like connecting to jack or setting\n the help text language etc)\n\n Frame rate throttling\n ---------------------\n By default fluxus throttles the framerate to around 40fps.\n to disable this (and run at 100% cpu), use desiredfps with\n some arbitrary large number:\n (desiredfps 100000000)\n To display the fps use (show-fps 1)\n\n Command line options\n ---------------------\n The easiest way to load a script into fluxus is to specify it on\n the command line, eg:\n $ fluxus myscript.scm\n Will launch fluxus and load the script into the editor.\n $ fluxus -x myscript.scm\n Will launch fluxus, load, hide and execute the script.\n Use -h to print all commandline options.\n\n Fluxus also contains a keypress and mouse event recorder for\n recording livecoding sessions:\n $ fluxus -r filename : record to keypresses file\n $ fluxus -p filename : playback from file\n $ fluxus -p filename -d time : seconds per frame time override for\n                                playback (for use with frame-dump)\n\n")) ("authors" ("" "" "" "\n Authors\n -------\n Glauber Alex Dias Prado\n Artem Baguinski\n Dan Bethell\n Nik Gaffney\n Dave Griffiths\n Claude Heiland-Allen\n Alex Norman\n Gabor Papp\n Fabien Pelisson\n Jeff Rose\n James Tittle\n Scott Watson\n EvanRaskob\n\n \"Computers are useless. They can only give you answers\".\n     Pablo Picasso (1881 - 1973).\n\n")) ("language" ("" "" "" " Language Docs\n -------------\n\n Fluxus is comprised of a set of functions which\n extend Scheme for use in realtime computer graphics.\n\n Scheme itself is out of the scope of this documentation,\n but fluxus is a good way of learning it. I reccommend\n \"The Little Schemer\" by by Daniel P. Friedman and Matthias\n Felleisen.\n\n The functions are grouped into sections to make things\n a bit easier to find.\n\n (help \"sections\") for a list of all sections\n (help \"sectionname\") to find out more about a section\n (help \"functionname\") to find out more about a function\n\n The idea is that you can find a function you are interested\n in by doing something like this:\n\n (help \"sections\")\n    ... list of sections ...\n (help \"maths\")\n    ... description and list of maths functions ...\n (help \"vmul\")\n    ... details about the function with example ...\n\n\n")) ("toplap" ("" "" "" " TOPLAP MANEFESTO We demand:\n  * Give us access to the performer's mind, to the whole human\n    instrument.\n  * Obscurantism is dangerous. Show us your screens.\n  * Programs are instruments that can change themselves\n  * The program is to be transcended - Artificial language is the way.\n  * Code should be seen as well as heard, underlying algorithms viewed\n    as well as their visual outcome.\n  * Live coding is not about tools. Algorithms are thoughts.\n    Chainsaws are tools. That's why algorithms are sometimes\n    harder to notice than chainsaws.\n\n We recognise continuums of interaction and profundity, but prefer:\n  * Insight into algorithms\n  * The skillful extemporisation of algorithm as an\n    expressive/impressive display of mental dexterity\n  * No backup (minidisc, DVD, safety net computer)\n\n We acknowledge that:\n  * It is not necessary for a lay audience to understand the\n    code to appreciate it, much as it is not necessary to know\n    how to play guitar in order to appreciate watching a guitar\n    performance.\n  * Live coding may be accompanied by an impressive display of\n    manual dexterity and the glorification of the typing interface.\n  * Performance involves continuums of interaction, covering\n    perhaps the scope of controls with respect to the parameter\n    space of the artwork, or gestural content, particularly\n    directness of expressive detail. Whilst the traditional\n    haptic rate timing deviations of expressivity in\n    instrumental music are not approximated in code, why repeat\n    the past? No doubt the writing of code and expression of\n    thought will develop its own nuances and customs.\n\n Performances and events closely meeting these manifesto\n conditions may apply for TOPLAP approval and seal.\n"))))) ("scratchpad" ("Functions available as part of the fluxus scratchpad." "" (("reset-camera" ("" "void" "Resets the camera transform, useful if it becomes trashed, or you get lost somewhere in space. Also turns off camera locking to objects with (lock-camera)" " ; ruin the camera transform\n (set-camera-transform (vector 123 41832 28 0.2 128 0.001 123 41832 28 0.2 128 0.001 0.2 100 13 1931))\n ; set it back to the starting position/orientation\n (reset-camera)\n")) ("set-camera-transform" ("transform-matrix" "void" "Overrides and locks the camera transform with your own. To unlock again call reset-camera" " (set-camera-transform (mtranslate (vector 0 0 -10)))\n")) ("get-camera-transform" ("" "transform-matrix" "Returns the current camera transform. To unlock again call reset-camera" " (define tx (get-camera-transform))\n")) ("set-help-locale!" ("locale-string" "void" "Sets the language for the documentation" " (set-help-locale! \"pt\") ; switch to portuguese\n (set-help-locale! \"en\") ; and back to english\n")) ("help" ("function-string" "void" "Displays help information on a fluxus function, or a list with available functions matching regexp. For running in the repl mainly." " (help \"pop\") \n")) ("key-pressed" ("key-string" "boolean" "Returns true if the specified key is currently pressed down." " (when (key-pressed \"q\") (display \"q pressed!\"))\n")) ("keys-down" ("" "keys-list" "Returns a list of keys pressed down" " (display (keys-down))(newline)\n")) ("key-special-pressed" ("key-number" "boolean" "Returns true if the specified special key is currently pressed down. Special keys are ones which do not map to ascii values. The easiest way of finding what they are is to print out the result of key-special-pressed while holding down the key you are after." "\n (when (key-special-pressed 100) (display \"left cursor pressed\"))\n (when (key-special-pressed 102) (display \"right cursor pressed\"))\n (when (key-special-pressed 101) (display \"up cursor pressed\"))\n (when (key-special-pressed 103) (display \"down cursor pressed\"))\n")) ("keys-special-down" ("" "keys-list" "Returns a list of special keys pressed down" " (display (keys-special-down))\n")) ("key-pressed-this-frame" ("key-string" "boolean" "Returns true if the specified key was first pressed down this frame." " (when (key-pressed-this-frame \"q\") (display \"q pressed!\"))\n")) ("key-special-pressed-this-frame" ("key-string" "boolean" "Returns true if the specified special key was first pressed down this frame." " (when (key-special-pressed-this-frame \"q\") (display \"q pressed!\"))\n")) ("mouse-x" ("" "coord-number" "Returns the x position of the mouse" " (display (mouse-x))\n")) ("mouse-y" ("" "coord-number" "Returns the y position of the mouse" " (display (mouse-y))\n")) ("mouse-button" ("button-number" "boolean" "Returns true if the specifed mouse button is pressed" " (display (mouse-button 1))\n")) ("mouse-wheel" ("" "boolean" "Returns 1 if the mouse wheel was moved in one direction in the last frame or -1 if it was turned the other way, otherwise returns 0." " (display (mouse-wheel))\n")) ("mouse-over" ("" "primitiveid-number" "Returns the object the mouse is currently over." " (grab (mouse-over))\n (colour (vector 1 0 0)) ; paints objects the mouse is over red\n (ungrab)\n")) ("every-frame" ("callback-function" "void" "Sets a function to be called every time the render is about to draw a new frame." " (define (myfunc)\n     (colour (rndvec))\n     (draw-torus))\n\n (every-frame (myfunc)) \n")) ("clear" ("" "void" "Clears out the renderer of all objects and lights. Clears the physics system and resets the every-frame callback. Generally a Good Thing to put this at the beginning of scripts to make sure everything is cleared out each time you execute." " (clear) ; without this we would accumulate a new cube every time F5 was pressed\n (build-cube) \n")) ("start-framedump" ("name-string type-string" "void" "Starts saving frames to disk. Type can be one of \"tif\", \"jpg\" or \"ppm\". Filenames are built with the frame number added, padded to 5 zeros." " (start-framedump \"frame\" \"jpg\") \n")) ("end-framedump" ("" "void" "Stops saving frames to disk." " (end-framedump) \n")) ("set-physics-debug" ("boolean" "void" "Call with #t to turn on debug rendering for the physics." " (set-physics-debug #t) \n")) ("override-frame-callback" ("callback-function" "void" "Allows you to override the frame callback, to control the rendering loop of fluxus in a more detailed way." " (override-frame-callback myfunc) \n (override-frame-callback default-fluxus-frame-callback) ; set it back again...\n")) ("set-auto-indent-tab" ("size-number" "void" "Sets the tabs size for the prettification auto indent on ctrl-p. Defaults to 2." " (set-auto-indent-tab 2)\n")) ("set-camera-update" ("#t/#f" "void" "Turns off camera update - allowing you to use (set-camera) - otherwise it gets written over by the mouse camera update. The reason for needing this is that (set-camera-transform) doesn't work with multiple cameras - need to fix." " (set-camera-update #f)\n (set-camera-update #t)\n")) ("spawn-task" ("" "void" "Launches a new per-frame task, a tasks: * execute once per graphic frame * are called in lexigraphical order by name * have unique names and if the same name is used the old task is removed prior to the new task being added * a task that returns #f will remove itself after executing (every-frame (build-cube)) is equivalent to (spawn-task (lambda () (build-cube)) 'every-frame-task)" " (spawn-task (lambda () (draw-torus)) 'torus-task)\n (rm-task 'torus-task)\n")) ("rm-task" ("" "void" "Removes a task from the tasklist" " (spawn-task (lambda () (draw-torus)) 'torus-task) ; add a task\n (rm-task 'torus-task) ; remove it again\n")) ("rm-all-tasks" ("" "void" "Removes all task from the tasklist, including the every-frame task." " (rm-all-tasks) \n")) ("ls-tasks" ("" "void" "Prints a list of current a tasks" " (spawn-task (lambda () (draw-torus)) 'torus-task) ; add a task\n (ls-tasks)\n (rm-task 'torus-task)\n")) ("spawn-timed-task" ("time thunk" "void" "Launches a new timed task, which will happen in the future, on the frame that the time specifies. Use (time-now) rather than (time) to obtain the time. I need to sort that out." " (spawn-timed-task (+ (time-now) 10) ; schedule a task 10 seconds from now\n     (lambda () (display \"hello future!\") (newline)))\n"))))) ("osc" ("OSC stands for Open Sound Control, and is a widely used protocol for passing data between multimedia applications. Fluxus can send or receive messages." " An example of using osc to communicate between pd and fluxus.\n A fluxus script to move a cube based on incoming osc messages.\n -- osc.scm\n\n (define value 0)\n\n (define (test)\n     (push)\n     (if (osc-msg \"/zzz\")\n         (set! value (osc 0)))\n     (translate (vector 1 0 value))\n     (draw-cube)\n     (pop))\n \n (osc-source \"6543\")\n (every-frame (test))\n \n --- EOF\n A PD patch to send control messages to fluxus:\n --- zzz.pd\n #N canvas 618 417 286 266 10;\n #X obj 58 161 sendOSC;\n #X msg 73 135 connect localhost 6543;\n #X msg 58 82 send /zzz \\$1;\n #X floatatom 58 29 5 0 0 0 - - -;\n #X obj 58 54 / 100;\n #X obj 73 110 loadbang;\n #X connect 1 0 0 0;\n #X connect 2 0 0 0;\n #X connect 3 0 4 0;\n #X connect 4 0 2 0;\n #X connect 5 0 1 0;\n" (("osc-source" ("port-string" "void" "Starts up the osc server, or changes port. Known bug: seems to fail if you set it back to a port used previously." " (osc-source \"4444\")\t ; listen to port 4444 for osc messages\n")) ("osc-msg" ("name-string" "msgreceived-boolean" "Returns true if the message has been received since the last frame, and sets it as the current message for subsequent calls to (osc) for reading the arguments." " (cond \n     ((osc-msg \"/hello\")              ; if a the /hello message is recieved\n         (display (osc 1))(newline)))\t; print out the first argument\n")) ("osc" ("argument-number" "oscargument" "Returns the argument from the current osc message." " (cond \n     ((osc-msg \"/hello\")              ; if a the /hello message is recieved\n         (display (osc 1))(newline)))\t; print out the first argument\n")) ("osc-destination" ("port-string" "void" "Specifies the destination for outgoing osc messages. The port name needs to specify the whole url and should look something like this \"osc.udp://localhost:4444\"" " (osc-destination \"osc.udp:localhost:4444\")\n (osc-send \"/hello\" \"s\" (list \"boo!\"))  ; send a message to this destination\n")) ("osc-peek" ("" "msg-string" "This util function returns the name, and format string and number/string arguments of the last sent message as a string - for debugging your osc network." " (display (osc-peek))(newline) \n")) ("osc-send" ("name-string format-string argument-list" "void" "Sends an osc message with the argument list as the osc data. Only supports floats, ints and strings as data. The format-string should be composed of \"i\", \"f\" and \"s\", and must match the types given in the list. This could probably be removed by using the types directly, but doing it this way allows you to explicitly set the typing for the osc message." " (osc-destination \"osc.udp:localhost:4444\")\n (osc-send \"/hello\" \"sif\" (list \"boo!\" 3 42.3))  ; send a message to this destination\n"))))) ("midi" ("MIDI stands for Musical Instrument Digital Interface, and it enables electronic musical instruments, computers, and other equipment to communicate, control, and synchronize with each other. Fluxus can receive MIDI control change and note messages." " (display (midi-info))(newline)\n\n (midi-init 1)\n\n (define (midi-test)\n     (with-state\n         (scale (vector (+ 1 (midi-ccn 0 1))\n                        (+ 1 (midi-ccn 0 2))\n                        (+ 1 (midi-ccn 0 3))))\n         (draw-cube)))\n\n (every-frame (midi-test))\n" (("midi-info" ("" "a list of (midi-port-number . midi-port-name-string) pairs" "Returns information about the available MIDI input ports." " (midi-info)\n")) ("midi-init" ("port-number" "void" "Opens the specified MIDI input port." " (midi-init 1)\n")) ("midi-cc" ("channel-number controller-number" "controller-value-number" "Returns the controller value." " (midi-cc 0 1)\n")) ("midi-ccn" ("channel-number controller-number" "controller-value-number" "Returns the controller value normalised to the (0, 1) interval." " (midi-ccn 0 1)\n")) ("midi-note" ("" "#(on-off-symbol channel note velocity) or #f" "Returns the next event from the MIDI note event queue or #f if the queue is empty." " (midi-note)\n")) ("midi-peek" ("" "msg-string" "Returns the name, and event type, and parameter bytes of the last MIDI event as a string for debugging purposes." " (display (midi-peek))(newline)\n"))))) ("turtle" ("The turtle polybuilder is an experimental way of building polygonal objects using a logo style turtle in 3D space. As you drive the turtle around you can place vertices and build shapes procedurally. The turtle can also be used to deform existing polygonal primitives, by attaching it to objects you have already created." " (define (build n)\n     (turtle-reset)\n     (turtle-prim 4)\n     (build-loop n n)\n     (turtle-build))\n \n (define (build-loop n t)\n     (turtle-turn (vector 0 (/ 360 t) 0))\n     (turtle-move 1)\n     (turtle-vert)\n     (if (< n 1)\n         0\n         (build-loop (- n 1) t)))\n" (("turtle-prim" ("type-number" "void" "Starts building a new polygon primitive with the turtle. The type specifies the polygon face type and is one of the following: 0: triangle strip, 1: quad list, 2: triangle list, 3: triangle fan, 4: general polygon" " (turtle-prim 0)\n")) ("turtle-vert" ("" "void" "Creates a new vertex in the current position, or sets the current vertex if the turtle builder is attached." " (turtle-vert)\n")) ("turtle-build" ("" "primitiveid-number" "Builds the object with the vertex list defined and gives it to the renderer. Has no effect if the turtle builder is attached to a primitive." " (define mynewshape (turtle-build))\n")) ("turtle-move" ("distance-number" "void" "Moves the turtle forward in it's current orientation." " (turtle-move 1)\n")) ("turtle-push" ("" "void" "The turtle build has it's own transform stack. Push remembers the current position and orientation." " (turtle-push)\n")) ("turtle-pop" ("" "void" "The turtle build has it's own transform stack. Pop forgets the current position and orientation, and goes back to the state at the last push." " (turtle-pop)\n")) ("turtle-turn" ("rotation-vector" "void" "Rotates the turtle's orientation with the supplied euler angles (rotations in x, y and z)." " (turtle-turn (vector 45 0 0))\n")) ("turtle-reset" ("" "void" "Resets the current position and rotation of the turtle to the origin." " (turtle-reset)\n")) ("turtle-attach" ("primitiveid-number" "void" "Attaches the turtle to an existing poly primitive. This means you are able to deform an existing objects points using the turtle builder." " (define myshape (build-sphere 10 10))\n (turtle-attach myshape)\n")) ("turtle-skip" ("count-number" "void" "When attached, causes the turtle to skip vertices. This value may be negative, which will set the turtle to write to previous vertices." " (turtle-skip -1)\n")) ("turtle-position" ("" "count-number" "When attached, returns the current pdata index the turtle is writing to." " (display (turtle-position))(newline)\n")) ("turtle-seek" ("position-number" "void" "When attached, sets the absolute pdata index the turtle is writing to." " (turtle-seek 0)\n"))))) ("physics" ("The physics system used in fluxus is based on the ode library, which allows you to add physical properties to objects and set them in motion. Since ODE is designed for rigid-body simulations, structures are described in terms of objects, joints and forces. A much more comprehensive explanation of these concepts can be found in the ODE documentation, which you have probably downloaded if you have compiled fluxus, or can be found at @url{http://ode.org/ode-docs.html} To help with debugging joints, try calling (render-physics) every frame, which will render locators showing you positions and axes of joints that have positional information." "" (("collisions" ("on/off-number" "void" "Enables or disables collision detection. Defaults to off." " (collisions 1)\n")) ("ground-plane" ("plane-vector offset-number" "void" "Create an infinite passive plane for use as the 'ground'" " (ground-plane (vector 0 1 0) 0)\n")) ("active-box" ("primitiveid-number" "void" "Enable the object to be acted upon by the physics system, using a box as the bounding volume. As an active object, it will be transformed by ode. Note: rotations only work correctly if you specify your transforms scale first, then rotate (translate doesn't matter) basically, ode can't deal with shearing transforms." " (define mycube (build-cube))\n (active-box mycube)\n")) ("active-cylinder" ("primitiveid-number" "void" "Enable the object to be acted upon by the physics system, using a cylinder as the bounding volume. As an active object, it will be transformed by ode. Note: rotations only work correctly if you specify your transforms scale first, then rotate (translate doesn't matter) basically, ode can't deal with shearing transforms." " (define mycube (build-cube))\n (active-cylinder mycube)\n")) ("active-sphere" ("primitiveid-number" "void" "Enable the object to be acted upon by the physics system, using a sphere as the bounding volume. As an active object, it will be transformed by ode. Note: rotations only work correctly if you specify your transforms scale first, then rotate (translate doesn't matter) basically, ode can't deal with shearing transforms." " (define mycube (build-cube))\n (active-sphere mycube)\n")) ("active-mesh" ("primitiveid-number" "void" "Enable the object to be acted upon by the physics system, using the mesh as the collision volume. This function only works on indexed, triangle-list poly primitives. As an active object, it will be transformed by ode. Note: rotations only work correctly if you specify your transforms scale first, then rotate (translate doesn't matter) basically, ode can't deal with shearing transforms." " (define myshape (load-primitive \"bot.obj\"))\n (active-mesh myshape)\n")) ("passive-box" ("primitiveid-number" "void" "Enable the object to be acted upon by the physics system, using a box as the bounding volume. As a passive object, active objects will collide with it, but it will not be transformed. Note: rotations only work correctly if you specify your transforms scale first, then rotate (translate doesn't matter) basically, ode can't deal with shearing transforms." " (define mycube (build-cube))\n (passive-box mycube)\n")) ("passive-cylinder" ("primitiveid-number" "void" "Enable the object to be acted upon by the physics system, using a cylinder as the bounding volume. As a passive object, active objects will collide with it, but it will not be transformed. Note: rotations only work correctly if you specify your transforms scale first, then rotate (translate doesn't matter) basically, ode can't deal with shearing transforms." " (define mycube (build-cube))\n (passive-cylinder mycube)\n")) ("passive-sphere" ("primitiveid-number" "void" "Enable the object to be acted upon by the physics system, using a sphere as the bounding volume. As a passive object, active objects will collide with it, but it will not be transformed. Note: rotations only work correctly if you specify your transforms scale first, then rotate (translate doesn't matter) basically, ode can't deal with shearing transforms." " (define mycube (build-cube))\n (passive-sphere mycube)\n")) ("passive-mesh" ("primitiveid-number" "void" "Enable the object to be acted upon by the physics system, using the mesh as the collision volume. This function only works on indexed, triangle-list poly primitives. As a passive object, active objects will collide with it, but it will not be transformed. Note: rotations only work correctly if you specify your transforms scale first, then rotate (translate doesn't matter) basically, ode can't deal with shearing transforms." " (define myshape (load-primitive \"bot.obj\"))\n (passive-mesh myshape)\n")) ("physics-remove" ("primitiveid-number" "void" "Remove the object from the physics system." " (define mycube (build-cube))\n (active-box mycube)\n (physics-remove mycube)\n")) ("surface-params" ("slip1-number slip2-number softerp-number softcfm-number" "void" "Sets some global surface attributes that affect friction and bouncyness. see section 7.3.7 of the ODE docs for an explanation of these parameters" " (surface-params 0.1 0.1 0.1 0.1)\n")) ("build-balljoint" ("primitiveid-number primitiveid-number axis-vector" "void" "Creates a balljoint to connect two objects (see the ode docs for a detailed description of the differences between the joint types). ODE considers joints to be a constraint that is enforced between two objects. When creating a joint, it is important to have the two primitives being joined in the desired positions before creating the joint. Joints can be created, modified and indexed in a similar way to other primitives." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (build-balljoint shape1 shape2 (vector 0 0 0)) \n (kick shape1 (vector 0 2 0))\n \n (set-physics-debug #t)\n")) ("build-fixedjoint" ("primitiveid-number" "void" "Creates a joint to connect an object to the global environment. This locks the object in place." " (clear)\n (define shape1 (with-state \n         (translate (vector 0 1 0))\n         (build-cube)))\n (active-box shape1)\n \n (build-fixedjoint shape1) ; not very exciting... \n")) ("build-hingejoint" ("primitiveid1-number primitiveid2-number anchor-vector axis-vector" "hingeid-number" "Creates a ball joint to connect two objects (see the ode docs for a detailed description of the differences between the joint types). ODE considers joints to be a constraint that is enforced between two objects. When creating a joint, it is important to have the two primitives being joined in the desired positions before creating the joint. Joints can be created, modified and indexed in a similar way to other primitives." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (build-hingejoint shape1 shape2 (vector 0 0 0) (vector 0 0 1)) \n (kick shape1 (vector 0 2 0))\n \n (set-physics-debug #t)\n")) ("build-sliderjoint" ("primitiveid1-number primitiveid2-number axis-vector" "hingeid-number" "Creates a slider joint to connect two objects (see the ode docs for a detailed description of the differences between the joint types). ODE considers joints to be a constraint that is enforced between two objects. When creating a joint, it is important to have the two primitives being joined in the desired positions before creating the joint. Joints can be created, modified and indexed in a similar way to other primitives." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (build-sliderjoint shape1 shape2 (vector 1 0 0)) \n (kick shape1 (vector 0 2 0))\n \n (set-physics-debug #t)\n")) ("build-hinge2joint" ("primitiveid1-number primitiveid2-number anchor-vector axis1-vector axis2-vector" "hingeid-number" "Creates a hinge2 joint to connect two objects (see the ode docs for a detailed description of the differences between the joint types). ODE considers joints to be a constraint that is enforced between two objects. When creating a joint, it is important to have the two primitives being joined in the desired positions before creating the joint. Joints can be created, modified and indexed in a similar way to other primitives." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (build-hinge2joint shape1 shape2 (vector 0 0 0) (vector 1 0 0) (vector 0 1 0)) \n (kick shape1 (vector 0 2 0))\n \n (set-physics-debug #t)\n")) ("build-amotorjoint" ("primitiveid1-number primitiveid2-number axis-vector" "hingeid-number" "Creates a angular motor joint to connect two objects (see the ode docs for a detailed description of the differences between the joint types). ODE considers joints to be a constraint that is enforced between two objects. When creating a joint, it is important to have the two primitives being joined in the desired positions before creating the joint. Joints can be created, modified and indexed in a similar way to other primitives." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (build-amotorjoint shape1 shape2 (vector 1 0 0)) \n (kick shape1 (vector 0 2 0))\n \n (set-physics-debug #t)\n")) ("joint-param" ("jointid-number param-string value-number" "hingeid-number" "Sets the joint parameter for a joint where param is one of the following: \"HiStop\", \"Vel\", \"FMax\", \"FudgeFactor\", \"Bounce\", \"CFM\", \"StopERP\", \"StopCFM\",\"SuspensionERP\", \"SuspensionCFM\", \"Vel2\", \"FMax2\". see section 7.5.1 of the ODE docs for an explanation of each of these parameters, and which joint types they apply to." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (define j (build-hinge2joint shape1 shape2 (vector 0 0 0) (vector 1 0 0) (vector 0 1 0)))\n (joint-param j \"Vel2\" 0.1)\n (joint-param j \"FMax2\" 0.2)\n (joint-param j \"LoStop\" -0.75)\n (joint-param j \"HiStop\" 0.75)\n \n (set-physics-debug #t)\n")) ("joint-angle" ("jointid-number angle-number vel-number" "void" "Set a new angle for this joint, with a given velocity taken to get there" " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (define j (build-hingejoint shape1 shape2 (vector 0 0 0) (vector 0 1 0)))\n (joint-param j \"FMax\" 20)\n (joint-param j \"LoStop\" -1)\n (joint-param j \"HiStop\" 1)\n \n (set-physics-debug #t)\n \n (define (animate)\n     (joint-angle j 0.1 (* 5 (sin (time)))))\n")) ("joint-slide" ("jointid-number force" "void" "Applies the given force in the slider's direction. That is, it applies a force with magnitude force, in the direction slider's axis, to body1, and with the same magnitude but opposite direction to body2." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (define j (build-sliderjoint shape1 shape2 (vector 1 0 0)))\n (joint-param j \"FMax\" 20)\n (joint-param j \"LoStop\" -1)\n (joint-param j \"HiStop\" 1)\n \n (set-physics-debug #t)\n \n (define (animate)\n     (joint-slide j (* 5 (sin (time)))))\n")) ("set-max-physical" ("max-number" "void" "Sets the maximum number of objects the physics system can deal with. When the max level has been reached the oldest objects are automatically destroyed." " (clear)\n (set-max-physical 200)\n \n (every-frame\n     (with-state\n     (translate (vector 0 5 0))\n         (scale (srndvec))\n         (colour (rndvec))\n         (let ((ob (build-cube)))    \n             (active-box ob)\n             (kick ob (vmul (srndvec) 3))\n             (twist ob (vmul (srndvec) 2)))))\n")) ("set-mass" ("primitiveid-number mass-number" "void" "Sets the mass of an active object" " (clear)\n (ground-plane (vector 0 1 0) 0)\n (collisions 1)\n (set-max-physical 20)\n \n ; not a great example, but these boxes will have \n ; different mass, so behave a bit differently.\n \n (every-frame\n     (when (> (rndf) 0.92)\n         (with-state\n             (translate (vector 0 5 0))\n             (scale (vmul (rndvec) 5))\n             (colour (rndvec))\n             (let ((ob (build-cube)))    \n                 (active-box ob)\n                 (set-mass ob (* (rndf) 10))\n                 (kick ob (vmul (srndvec) 3))\n                 (twist ob (vmul (srndvec) 2))))))    \n")) ("gravity" ("gravity-vector" "void" "Sets the strength and direction of gravity." " (clear)\n (ground-plane (vector 0 1 0) 0)\n (collisions 1)\n (set-max-physical 20)\n \n (every-frame\n     (begin\n         (gravity (vector 0 (sin (time)) 0)) ; change gravity! :)\n         (when (> (rndf) 0.92)\n             (with-state\n                 (translate (vector 0 5 0))\n                 (scale (rndvec))\n                 (colour (rndvec))\n                 (let ((ob (build-cube)))    \n                     (active-box ob)\n                     (kick ob (vmul (srndvec) 3))\n                     (twist ob (vmul (srndvec) 2)))))))\n")) ("kick" ("primitiveid-number kick-vector" "void" "Applies translation force to the object" " (clear)\n (collisions 1)\n (set-max-physical 20)\n (gravity (vector 0 0 0))\n\n (every-frame\n     (when (> (rndf) 0.92)\n         (with-state\n             (scale (rndvec))\n             (colour (rndvec))\n             (let ((ob (build-cube)))\n                 (active-box ob)\n                 (kick ob (vmul (srndvec) 3))\n                 (twist ob (vmul (srndvec) 2))))))\n")) ("twist" ("primitiveid-number spin-vector" "void" "Applies rotational force to the object" " (clear)\n (collisions 1)\n (set-max-physical 20)\n (gravity (vector 0 0 0))\n\n (every-frame\n     (when (> (rndf) 0.92)\n         (with-state\n             (scale (rndvec))\n             (colour (rndvec))\n             (let ((ob (build-cube)))\n                 (active-box ob)\n                 (kick ob (vmul (srndvec) 3))\n                 (twist ob (vmul (srndvec) 2))))))\n")) ("add-force" ("primitiveid-number force-vector" "void" "Add force to body." " (clear)\n (collisions 1)\n (for ([i (in-range 15)])\n    (let* ([p (vmul (srndvec) 15)]\n           [c (with-state\n                    (translate p)\n                    (build-cube))])\n        (active-box c)\n        (set-gravity-mode c #f)\n        (add-force c (vmul p -10))))\n")) ("add-torque" ("primitiveid-number torque-vector" "void" "Add torque to body." " (clear)\n (define c (build-cube))\n (active-box c)\n (add-torque c #(10 0 0))\n")) ("set-gravity-mode" ("primitiveid-number mode-boolean" "void" "Set whether the body is influenced by the world's gravity or not." " (clear)\n (collisions 1)\n (define a (with-state\n               (translate (vector -.95 5 0))\n               (build-cube)))\n (define b (build-cube))\n (active-box a)\n (active-box b)\n (set-gravity-mode b #f)\n")) ("has-collided" ("primitiveid-number" "void" "Returns true if the grabbed object collided in the last frame" " (clear)\n (ground-plane (vector 0 1 0) 0)\n (collisions 1)\n (set-max-physical 20)\n \n (define ob (with-state\n     (translate (vector 0 5 0))\n     (build-cube)))\n \n (active-box ob)\n \n (every-frame\n     (when (has-collided ob)\n         (with-primitive ob\n             (colour (rndvec)))))\n"))))) ("maths" ("These functions are optimised for 3D graphics, and the collision of computer science and maths is apparent here, so scheme vectors representing maths vectors are in this context taken to be 3 elements long, quaternions are vectors of length 4, and matrices are vectors of 16 elements long." "" (("vmul" ("vector number" "result-vector" "Multiplies a vector by a number" " (vmul (vector 1 2 3) 2)\n")) ("vadd" ("vector vector" "result-vector" "Adds two vectors together" " (vadd (vector 1 2 3) (vector 1 2 3))\n")) ("vsub" ("vector vector" "result-vector" "Subtracts a vector from another" " (vsub (vector 1 2 3) (vector 1 2 3))\n")) ("vdiv" ("vector number" "result-vector" "Divides a vector by a number" " (vdiv (vector 1 2 3) 2)\n")) ("vtransform" ("vector matrix" "result-vector" "Multiplies (transforms) a vector by a matrix" " (vtransform (vector 0 1 0) (mrotate (vector 90 0 0)))\n")) ("vtransform-rot" ("vector matrix" "result-vector" "Multiplies (transforms) a vector by a matrix, but leaves out the translation part. For operations involving normals." " (vtransform-rot (vector 0 1 0) (mrotate (vector 90 0 0)))\n")) ("vnormalise" ("vector" "result-vector" "Returns the normalised form of the vector (length=1)" "")) ("vdot" ("vector vector" "result-number" "Returns the dot product of two vectors" " (vdot (vector 0 1 0) (vector 1 0 0))\n")) ("vmag" ("vector" "result-number" "Returns the magnitude, or length of the vector" " (vmag (vector 0 1 1))\n")) ("vreflect" ("vector vector" "result-vector" "Returns the reflection of one vector against another." " (vreflect (vector 0 1 1) (vector 1 0 1))\n")) ("vdist" ("vector vector" "result-number" "Treating the vectors as points, returns the distance between them." " (vdist (vector 100 100 0) (vector 0 0 100))\n")) ("vdist-sq" ("vector vector" "result-number" "Treating the vectors as points, returns the squared distance between them. Faster than vdist." " (vdist-sq (vector 100 100 0) (vector 0 0 100))\n")) ("vcross" ("vector vector" "result-vector" "Returns the cross product of two vectors, resulting in a vector that is perpendicular to the crossed ones." " (vcross (vector 100 100 0) (vector 0 0 100))\n")) ("mmul" ("matrix-vector matrix-vector" "matrix-vector" "Multiplies two matrices together" " (mmul (mtranslate (vector 1 0 0)) (mrotate (vector 0 90 0)))\n")) ("madd" ("matrix-vector matrix-vector" "matrix-vector" "Adds two matrices together" " (madd (mtranslate (vector 1 0 0)) (mrotate (vector 0 90 0)))\n")) ("msub" ("matrix-vector matrix-vector" "matrix-vector" "Subtracts a matrix from another." " (msub (mtranslate (vector 1 0 0)) (mrotate (vector 0 90 0)))\n")) ("mdiv" ("matrix-vector matrix-vector" "matrix-vector" "Divides a matrix by another" " (mdiv (mtranslate (vector 1 0 0)) (mrotate (vector 0 90 0)))\n")) ("mident" ("" "matrix-vector" "Returns the identity matrix" " (mident)\n")) ("mtranslate" ("vector" "matrix-vector" "Returns a matrix representing the specified transform" " (mtranslate (vector 100 0 0))\n")) ("mrotate" ("vector" "matrix-vector" "Returns a matrix representing the specified rotation. Accepts a vector of euler angles, or a quaternion." " (mrotate (vector 0 45 0))\n")) ("mscale" ("vector" "matrix-vector" "Returns a matrix representing the specified scaling." " (mscale (vector 0.5 2 0.5))\n")) ("mtranspose" ("matrix-vector" "matrix-vector" "Returns the transpose of the input vector" " (mtranspose (mident))\n")) ("minverse" ("matrix-vector" "matrix-vector" "Returns the inverse of the input vector." " (minverse (mscale (vector 0.5 2 0.5)))\n")) ("maim" ("aim-vector up-vector" "matrix-vector" "Returns a matrix representing an aiming rotation so that the x axis points down the aim direction, and the y axis points up the up vector. Probably suffers from gimbal lock." " (maim (vector 0 0 1) (vector 0 1 0))\n")) ("matrix->euler" ("vector-matriz" "vector" "Returns the euler angles extracted from the matrix." " (matrix->euler (mrotate (vector 15 0 0)))\n")) ("qaxisangle" ("axis-vector angle-number" "quaternion-vector" "Returns the quaternion representing rotation of angle degrees about the specified axis." " (qaxisangle (vector 0 1 0) 45)\n")) ("qmul" ("quaternion-vector quaternion-vector" "quaternion-vector" "Multiplies two quaternions together." " (qmul (qaxisangle (vector 0 1 0) 45) (qaxisangle (vector 0 0 1) 180))\n")) ("qnormalise" ("quaternion-vector" "quaternion-vector" "Normalises a quaternion." " (qnormalise (qaxisangle (vector 0 19 0) 45))\n")) ("qtomatrix" ("quaternion-vector" "matrix-vector" "Converts a quaternion into a rotation matrix." " (qtomatrix (qaxisangle (vector 0 1 0) 45))\n")) ("qconjugate" ("quaternion-vector" "quaternion-vector" "Conjugatea a quaternion." " (qconjugate (qaxisangle (vector 0 1 0) 45))\n")) ("fmod" ("numerator-number denominator-number" "real-number" "Returns the floating-point remainder of numerator/denominator." " (fmod 14.4 10)\n")) ("snoise" ("real-number ..." "real-number" "Returns 1D/2D/3D/4D Simplex Noise in the range -1->1 depending on the number of parameters." " (snoise 1.0 2.0) ; 2D noise\n (snoise 6.1 2.4 .5 1.3) ; 4D noise\n \n ; example on a pixel prim\n (clear)\n (with-primitive (build-pixels 100 100)\n     (pdata-index-map!\n         (lambda (i c)\n             (snoise (* 0.1 (modulo i (pixels-width)))\n                     (* 0.1 (quotient i (pixels-height)))))\n         \"c\")\n     (pixels-upload))\n")) ("noise" ("real-number ..." "real-number" "Returns the Perlin Noise value at specified coordinates." " (noise 1.0 2.0) ; 2D noise\n (noise 6.1 2.4 .5) ; 3D noise\n\n ; example on a pixel prim\n (clear)\n (with-primitive (build-pixels 100 100)\n     (pdata-index-map!\n         (lambda (i c)\n             (noise (* 0.1 (modulo i (pixels-width)))\n                    (* 0.1 (quotient i (pixels-height)))))\n         \"c\")\n     (pixels-upload))\n")) ("noise-seed" ("unsigned-number" "void" "Sets the seed value for noise." " (noise-seed 1)\n")) ("noise-detail" ("octaves-number falloff-number" "void" "Adjusts the character and level of detail produced by the Perlin noise function." " (noise-detail 4) ; noise with 4 octaves\n (noise-detail 4 .5) ; noise with 4 octaves and .5 falloff\n"))))) ("lights" ("Without lights you wouldn't be able to see anything. Luckily fluxus gives you one for free by default, a white diffuse point light attached to the camera. For more interesting lighting, you'll need these functions. Using the standard fixed function graphics pipeline, simplistically speaking, OpenGL multiplies these values with the surface material (set with local state commands like ambient and diffuse) and the texture colour value to give the final colour." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n" (("make-light" ("type-symbol cameralocked-symbol" "lightid-number" "Makes a new light. The type can be one of: point, directional or spot. If the cameralocked string is not free then it will be attached to the camera, and move around when you move the camera." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n")) ("light-ambient" ("lightid-number colour" "void" "Sets the ambient contribution for the specified light." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n")) ("light-diffuse" ("lightid-number colour" "void" "Sets the diffuse contribution for the specified light." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n")) ("light-specular" ("lightid-number colour" "void" "Sets the specular contribution for the specified light." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n")) ("light-position" ("lightid-number position-vector" "void" "Sets the position of the specified light. In worldspace if free, in camera space is attached." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n")) ("light-spot-angle" ("lightid-number angle-number" "void" "Sets the spotlight cone angle of the specified light. If it's not a spot light, this command has no effect." " ; turn down the main light\n (light-diffuse 0 (vector 0.1 0.1 0.1))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'spot 'free))\n (light-position mylight (vector (+ 4 (crndf)) (crndf) 2))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n (light-spot-angle mylight (+ 5 (random 40)))\n (light-spot-exponent mylight 500)\n (light-attenuation mylight 'constant 1) \n (light-direction mylight (vector -1 0 -1))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)\n     (scale (vector 10 10 10))\n     (translate (vector -0.5 -0.5 0))\n     (build-seg-plane 20 20)) \n")) ("light-spot-exponent" ("lightid-number exponent-number" "void" "Sets the spotlight exponent (fuzzyness of the cone) of the specified light. If it's not a spot light, this command has no effect." " ; turn down the main light\n (light-diffuse 0 (vector 0.1 0.1 0.1))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'spot 'free))\n (light-position mylight (vector (+ 4 (crndf)) (crndf) 2))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n (light-spot-angle mylight (+ 5 (random 40)))\n (light-spot-exponent mylight 500)\n (light-attenuation mylight 'constant 1) \n (light-direction mylight (vector -1 0 -1))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)\n     (scale (vector 10 10 10))\n     (translate (vector -0.5 -0.5 0))\n     (build-seg-plane 20 20)) \n")) ("light-attenuation" ("lightid-number type-symbol attenuation-number" "void" "Sets the light attenuation (fade off with distance) of the specified light. The type symbol can be one of: constant, linear or quadratic." " ; turn down the main light\n (light-diffuse 0 (vector 0.1 0.1 0.1))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'spot 'free))\n (light-position mylight (vector (+ 4 (crndf)) (crndf) 2))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n (light-spot-angle mylight (+ 5 (random 40)))\n (light-spot-exponent mylight 500)\n (light-attenuation mylight 'constant 1) \n (light-direction mylight (vector -1 0 -1))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)\n     (scale (vector 10 10 10))\n     (translate (vector -0.5 -0.5 0))\n     (build-seg-plane 20 20)) \n")) ("light-direction" ("lightid-number direction-vector" "void" "Sets the direction of a directional light. If it's not a directional light, this command has no effect." " ; turn down the main light\n (light-diffuse 0 (vector 0.1 0.1 0.1))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'spot 'free))\n (light-position mylight (vector (+ 4 (crndf)) (crndf) 2))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n (light-spot-angle mylight (+ 5 (random 40)))\n (light-spot-exponent mylight 500)\n (light-attenuation mylight 'constant 1) \n (light-direction mylight (vector -1 0 -1))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)\n     (scale (vector 10 10 10))\n     (translate (vector -0.5 -0.5 0))\n     (build-seg-plane 20 20)) \n"))))) ("renderer" ("These commands are the low level renderer controls. You shouldn't need to deal with these unless you are being wily, or implementing a fluxus renderer outside of the scratchpad interface." "" (("make-renderer" ("" "rendererid-number" "Makes a new scenegraph renderer." " (make-renderer)\n")) ("renderer-grab" ("rendererid-number" "void" "Make this renderer the current context for commands." " (renderer-grab renderer)\n")) ("renderer-ungrab" ("" "void" "Pop the renderer context stack." " (renderer-grab renderer)\n")) ("fluxus-render" ("" "void" "Clears the backbuffer, and renders everything" " (fluxus-render)\n")) ("tick-physics" ("" "void" "Update the physics system." " (tick-physics)\n")) ("render-physics" ("" "void" "Render the physics system (for helper graphics). This is the low level command - use set-physics-debug instead." " (render-physics)\n")) ("reset-renderers" ("" "void" "Deletes all the renderers and makes a new default one." " (reset-renderers)\n")) ("reshape" ("width-number height-number" "void" "Calls reshape on the current renderer" " (reshape 100 100)\n")) ("fluxus-init" ("" "void" "Inits the whole rendering system, only needs calling once." " (fluxus-init)\n")) ("fluxus-error-log" ("" "void" "Returns a string containing error information for the last frame." " (display (fluxus-error-log))\n"))))) ("audio" ("This part of fluxus is responsible for capturing the incoming sound, and processing it into harmonic data, using fft (Fast Fourier Transform). The harmonics are bands of frequency which the sound is split into, giving some indication of the quality of the sound. It's the same as you see on a graphic equaliser - in fact, one of the example scripts (bars.scm) acts as a graphic equaliser display, and should be used to test the audio is working." " (start-audio \"alsa_pcm:capture_1\" 1024 44100)\n (define (animate)\n\t\t(colour (vector (gh 1) (gh 2) (gh 3))) ; make a colour from the harmonics, and set it to be the current colour \n\t\t(draw-cube)) ; draw a cube with this colour\n (every-frame (animate))\n" (("start-audio" ("jackport-string buffersize-number samplerate-number" "void" "Starts up the audio with the specified settings, you'll need to call this first, or put it into $HOME/.fluxus.scm to call it automatically at startup. Make the jack port name an empty string and it won't try to connect to anything for you. You can use qjackctrl or equivelent to do the connection manually. Fluxus reads a single mono source." " (start-audio \"alsa_pcm:capture_1\" 1024 44100)\n")) ("gh" ("harmonic-number" "harmonic-real" "Fluxus converts incoming audio into harmonic frequencies, which can then be plugged into your animations using this command. There are 16 harmonic bands availible, the harmonic-value argument will be wrapped around if greater or less than 16, so you can use this command without worrying about out of range errors." " (define (animate)\n\t\t(colour (vector (gh 1) (gh 2) (gh 3))) ; make a colour from the harmonics, and set it to be the current colour \n\t\t(draw-cube)) ; draw a cube with this colour\n (every-frame (animate))\n")) ("ga" ("" "audio-buffer-vector" "Returns the current contents of the audio buffer." " (clear)\n (define p (build-ribbon 128))\n (with-primitive p\n    (hint-unlit)\n    (pdata-map! (lambda (w) .1) \"w\"))\n\n (every-frame\n    (let ([a (ga)])\n        (with-primitive p\n            (pdata-index-map!\n                (lambda (i p)\n                    (vector (* .25 (- i (/ (pdata-size) 2))) (* 10 (vector-ref a i)) 0))\n                \"p\"))))\n")) ("gain" ("gain-number" "void" "Sets the gain level for the fft sound, it's 1 by default." " (gain 100) ; too quiet?!\n")) ("process" ("wavfile-string" "void" "This command temporarally disables the realtime reading of the input audio stream and reads a wav file instead. For use with the framedump command to process audio offline to make music videos. The advantage of this is that it locks the framerate so the right amount of audio gets read for each frame - making syncing of the frames and audio files possible." " (process \"somemusic.wav\") ; read a precorded audio file\n")) ("smoothing-bias" ("value-number" "void" "A kind of weighted average for the harmonic bands which smooth them out over time. This setting defaults to 1.5. The best value really depends on the quality of the music, and the buffer sizes, and ranges from 0 -> 2. It's more obvious if you give it a try with the bars.scm script" " (smoothing-bias 0) ; no smoothing\n")) ("update-audio" ("" "void" "Updates the audio subsytem. This function is called for you (per frame) in fluxus-canvas.ss." " (update-audio)\n"))))) ("artkp" ("TODO Fluxus ARToolKitPlus module." "" (("ar-init" ("width-number height-number filename-string [marker-mode-symbol]" "void" "Initializes the AR single marker tracker with the camera resolution and camera parameter file. The forth optional paremeter sets the type of markers to be detected. The marker mode can be 'template, 'id or 'bch. Template markers are the classic marker type used in ARToolKit. Id-based markers directly encode the marker id in the image. Simple markers use 3-times redundancy to increase robustness, while BCH markers use an advanced CRC algorithm to detect and repair marker damages. The default mode is 'id." " (define cam (camera-init 0 320 240))\n (ar-init (camera-width cam) (camera-height cam) \"data/camera-para.dat\")\n")) ("ar-set-threshold" ("threshold-number" "void" "Sets the threshold value that is used for black/white conversion." " (ar-set-threshold 150)\n")) ("ar-get-threshold" ("" "threshold-number" "Returns the current threshold value." " (ar-get-threshold)\n")) ("ar-auto-threshold" ("activate-bool" "void" "Enables or disables automatic threshold calculation." " (ar-auto-threshold #t)\n")) ("ar-set-pattern-width" ("width-number" "void" "" " (ar-set-pattern-width 40)\n")) ("ar-activate-vignetting-compensation" ("activate-bool" "void" "Activates the compensation of brightness falloff in the corners of the camera image." " (ar-activate-vignetting-compensation #t)\n")) ("ar-detect" ("buffer-imgptr" "number" "Detects the markers in the image. Returns the number of detected markers." " TODO\n")) ("ar-get-projection-matrix" ("" "projection-matrix-vector" "Returns the projection matrix acquired from the camera parameter file." " (set-projection-transform (ar-get-projection-matrix))\n (set-camera-transform (mident))\n")) ("ar-get-modelview-matrix" ("index-number" "modelview-matrix-vector" "Returns the modelview matrix of the marker with the given index or #f if no marker is detected. The number of detected markers are returned by (ar-detect). The index can go from 0 to the number of detected markers - 1." " (let ([marker-count (ar-detect (camera-imgptr cam))])\n   (for ([i (in-range marker-count)])\n\t\t(let ([m (ar-get-modelview-matrix i)]\n\t\t\t  [id (ar-get-marker-id)])\n\t\t   (printf \"marker index:~a id:~a matrix:~a~n\" i id m))))\n")) ("ar-get-id" ("index-number" "marker-id-number" "Returns the ID of the marker with the given index or #f if the id could not be determined. The number of detected markers are returned by (ar-detect). The index can go from 0 to the number of detected markers - 1." " (let ([marker-count (ar-detect (camera-imgptr cam))])\n   (for ([i (in-range marker-count)])\n\t\t(let ([m (ar-get-modelview-matrix i)]\n\t\t\t  [id (ar-get-id i)])\n\t\t   (printf \"marker index:~a id:~a matrix:~a~n\" i id m))))\n")) ("ar-get-confidence" ("index-number" "confidence-number" "Returns the confidence value of the marker with the given index. The number of detected markers are returned by (ar-detect). The index can go from 0 to the number of detected markers - 1." " (let ([marker-count (ar-detect (camera-imgptr cam))])\n   (for ([i (in-range marker-count)])\n\t\t(let ([conf (ar-get-confidence i)])\n\t\t   (printf \"marker index:~a confidence:~a matrix:~a~n\" i id m))))\n")) ("ar-load-pattern" ("filename-string" "id-number" "Adds a pattern to the tracker, returns the pattern id." " (define hiro (ar-load-pattern \"hiro.patt\"))\n"))))) ("video" ("The video module provides functions to load in a movie file via Quicktime in OSX or GStreamer in Linux, and offers various controls to play or control the properties of the movie. The module also provides access to live cameras." " (clear)\n (video-clear-cache)\n (define vt (video-load \"/path/to/movie\"))\n (video-play vt)\n (let ([p (build-plane)]\n      [tcoords (video-tcoords vt)])\n    (with-primitive p\n        (texture vt)\n        (pdata-index-map!\n            (lambda (i t)\n                (list-ref tcoords (remainder i 4)))\n            \"t\")))\n (every-frame (video-update vt))\n" (("video-clear-cache" ("" "void" "The video loading is memory cached, so repeatedly calling (video-load) will not cause the file to be loaded again. (video-clear-cache) clears the video cache, meaning the videos will be reloaded from disk." " (video-clear-cache)\n")) ("video-load" ("filename-string" "videoid-number" "Loads a movie file. The video loading is memory cached, so repeatedly calling this will not cause the file to be loaded again. The cache can be cleared with (video-clear-cache). Returns a video-id that can be used directly in (texture) calls, and in other video functions." " (define movie (video-load \"/path/to/movie\"))\n")) ("video-tcoords" ("videoid-number" "list-of-texture-coordinates" "Returns the texture coordinates of the video texture. This is necessary, because video images are usually rectangular non-power-of-two textures, while fluxus uses GL_TEXTURE_2D power-of-two textures." " (define vt (video-load \"/path/to/movie\"))\n (video-play vt)\n (let ([p (build-plane)]\n      [tcoords (video-tcoords vt)])\n    (with-primitive p\n        (texture vt)\n        (pdata-index-map!\n            (lambda (i t)\n                (list-ref tcoords (remainder i 4)))\n            \"t\")))\n (every-frame (video-update vt))\n")) ("video-update" ("videoid-number" "void" "Updates the movie player, so that the movie can play." " (define vt (video-load \"/path/to/movie\"))\n (video-play vt)\n (let ([p (build-plane)]\n      [tcoords (video-tcoords vt)])\n    (with-primitive p\n        (texture vt)\n        (pdata-index-map!\n            (lambda (i t)\n                (list-ref tcoords (remainder i 4)))\n            \"t\")))\n (every-frame (video-update vt))\n")) ("video-play" ("videoid-number" "void" "Plays the movie." " (define vt (video-load \"/path/to/movie\"))\n (video-play vt)\n")) ("video-stop" ("videoid-number" "void" "Stops the movie." " (define vt (video-load \"/path/to/movie\"))\n (video-play vt)\n")) ("video-seek" ("videoid-number position-number" "void" "Sets the position of the playhead to a given percentage through the movie. Position is between 0 and 1." " (define vt (video-load \"/path/to/movie\"))\n (video-play vt)\n (video-seek vt 0.5)\n")) ("video-width" ("videoid-number" "width-number" "Returns the width of the video zero if the video id is invalid." " (define vt (video-load \"/path/to/movie\"))\n (video-width vt)\n")) ("video-height" ("videoid-number" "height-number" "Returns the height of the video or zero if the video id is invalid." " (define vt (video-load \"/path/to/movie\"))\n (video-height vt)\n")) ("video-imgptr" ("videoid-number" "cpointer:imgptr" "Returns a tagged cpointer to the video pixel buffer to be passed to other modules. The data is stored as RGB in an array of width*height*3 size." " (define vt (video-load \"/path/to/movie\"))\n (video-imgptr vt)\n")) ("camera-list-devices" ("" "void" "Prints the available camera devices to the console." " (camera-list-devices)\n")) ("camera-clear-cache" ("" "void" "The initialized cameras are stored in cache, so they are not getting reinited every time the script is recompiled. The function clears the camera cache." " (camera-clear-cache)\n")) ("camera-init" ("device-id width height" "cameraid-number" "Initializes the camera with the given device-id and resolution. Returns a camera-id that can be used directly in (texture) calls, and in other camera functions to reference the device. The camera-id is different from the device-id." " (define cam (camera-init 0 320 240))\n (printf \"camera resolution: ~ax~a~n\" (camera-width cam) (camera-height cam))\n (texture cam)\n (build-cube)\n")) ("camera-update" ("cameraid-number" "void" "This function should be called regularly to get new data from the camera." " (define cam (camera-init 0 320 240))\n (texture cam)\n (build-cube)\n (every-frame (camera-update cam))\n")) ("camera-tcoords" ("cameraid-number" "list-of-texture-coordinates" "Returns the texture coordinates of the camera image. This is necessary, because camera images are rectangular non-power-of-two textures, while fluxus uses GL_TEXTURE_2D power-of-two textures." " (define cam (camera-init 0 320 240))\n (let ([p (build-camera)]\n       [tcoords (camera-tcoords cam)])\n    (with-primitive p\n        (texture cam)\n        (pdata-index-map!\n            (lambda (i t)\n                (list-ref tcoords (remainder i 4)))\n            \"t\")))\n (every-frame (camera-update cam))\n")) ("camera-width" ("cameraid-number" "width-number" "Returns the width of the camera image or zero if the camera id is invalid." " (define cam (camera-init 0 320 240))\n (camera-width cam)\n")) ("camera-height" ("cameraid-number" "height-number" "Returns the height of the camera image or zero if the camera id is invalid." " (define cam (camera-init 0 320 240))\n (camera-height cam)\n")) ("camera-imgptr" ("cameraid-number" "cpointer:imgptr" "Returns a tagged cpointer to the camera image pixel buffer to be passed to other modules. The data is stored as RGB in an array of width*height*3 size." " (define cam (camera-init 0 320 240))\n (camera-imgptr cam)\n"))))) ("ffgl" ("FreeFrame is a cross platform real-time video effects plugin system. Fluxus supports FreeFrame 1.5 also known as FreeFrameGL or FFGL. FF CPU software rendering plugins are not supported at the moment. For more information visit http:;;www.freeframe.org" " (clear)\n\n (define p (build-pixels 256 256 #t)) ; input pixelprimitive\n\n (translate (vector 1.1 0 0))\n ; output pixelprimitive - rendering is not active\n ; otherwise it would overwrite the plugin output\n (define op (build-pixels 256 256))\n\n ; load the FFGLTile plugin from the FreeFrame SDK\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (for ([i (ffgl-get-info)]) ; print plugin information\n        (printf \"~a~n\" i))\n   (printf \"~a~n\" (ffgl-get-parameters)) ; parameter names as strings\n   (ffgl-process op p)) ; set destination and source pixelprimitives\n\n (define (anim)\n    ; set plugin parameters as keywords arguments\n    (with-ffgl plugin\n        (ffgl-set-parameter! #:tilex (/ (mouse-x) (vx (get-screen-size)))\n                             #:tiley (/ (mouse-y) (vy (get-screen-size)))))\n    ; render to the input pixelprimitive\n    (with-pixels-renderer p\n        (with-state\n            (clear-colour #(0 1 0))\n            (scale 5)\n            (rotate (vector (* 50 (time)) -17 (* -35 (time))))\n            (draw-cube))))\n\n (every-frame (anim))\n" (("ffgl-load" ("filename-string width-number height-number" "plugininstance-number" "Loads an FFGL plugin and returns a plugin instance. Plugin width and height have to be the same as the resolution of the pixel primitive you are about to process with the plugin." " (clear)\n ; load the FFGLTile plugin from the FreeFrame SDK\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n")) ("ffgl-get-info" ("" "(list of plugin-version-number plugin-id-string plugin-name-string plugin-type-symbol plugint-description-string plugin-about-string)" "Returns plugin information." " (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (for ([i (ffgl-get-info)]) ; print plugin information\n        (printf \"~a~n\" i)))\n")) ("ffgl-get-parameters" ("" "parameter-string-list" "Returns the list of parameters." " (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"~a~n\" (ffgl-get-parameters)))\n")) ("ffgl-get-parameter-default" ("parameter-name-symbol" "default-parameter-value" "Returns the default parameter value for the given parameter." " (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"tilex default: ~a~n\" (ffgl-get-parameter-default 'tilex)))\n")) ("ffgl-get-parameter" ("parameter-name-symbol" "parameter-value" "Returns the current value of the given parameter." " (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"tilex default: ~a~n\" (ffgl-get-parameter 'tilex)))\n")) ("ffgl-activate" ("boolean" "void" "Activates, deactivates the plugin." " (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (ffgl-activate #t))\n")) ("ffgl-active?" ("" "boolean" "Returns #t if the plugin is active, or #f otherwise." " (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (when (ffgl-active?)\n     (display \"plugin is active\")))\n")) ("ffgl-get-min-inputs" ("" "number" "Returns the minimum number of input pixel primitives the plugin requires." " (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"~a~n\" (ffgl-get-min-inputs)))\n")) ("ffgl-get-max-inputs" ("" "number" "Returns the maximum number of input pixel primitives the plugin accepts." " (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"~a~n\" (ffgl-get-max-inputs)))\n")) ("ffgl-set-time!" ("time-number" "void" "Sets the time in seconds." " (clear)\n (define plugin (ffgl-load \"FFGLTime\" 256 256))\n\n (with-ffgl plugin\n   (ffgl-set-time! (time)))\n")) ("ffgl-process" ("output-pixelprimitiveid-number input-pixelprimitiveid-number ..." "void" "Sets output and input pixel primitives for the grabbed plugin. The resolution of the pixel primitives has to be same as the resolution the plugin is initialised." " (clear)\n\n (define p (build-pixels 256 256 #t))\n (define op (build-pixels 256 256))\n\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (ffgl-process op p))\n\n (define (anim)\n    (with-pixels-renderer p\n        (with-state\n            (clear-colour #(0 1 0))\n            (scale 5)\n            (rotate (vector (* 50 (time)) -17 (* -35 (time))))\n            (draw-cube))))\n\n (every-frame (anim))\n")) ("ffgl-clear-instances" ("" "void" "Clears FFGL plugin instances." " (ffgl-clear-instances)\n")) ("ffgl-clear-cache" ("" "void" "Clears FFGL plugin cache and instances." " (ffgl-clear-cache)\n")) ("with-ffgl" ("ffgl-pluginid expression ..." "result of last expression" "Allows you to work with the specified FFGL plugin." " (clear)\n (define plugin (ffgl-load \"FFGLTile.dylib\" 256 256))\n\n (with-ffgl plugin\n   (for ([i (ffgl-get-info)])\n        (printf \"~a~n\" i)))\n")) ("ffgl-set-parameter!" ("parameter-name-keyword parameter-value ..." "void" "Sets ffgl plugin parameters." " (clear)\n (define plugin (ffgl-load \"FFGLTile.dylib\" 256 256))\n\n (with-ffgl plugin\n        (ffgl-set-parameter! #:tilex .5 #:tiley .2))\n\n"))))) ("global-state" ("Global state is really anything that controls the renderer globally, so it affects all primitives or controls the renderer directly - ie camera control or full screen effects like blurring." "" (("clear-engine" ("" "void" "Clears the renderer, and physics system. This command should not be called directly, use clear instead, as this clears a few other things, and calls clear-engine itself." " (clear-engine) ; woo hoo!\n")) ("blur" ("amount-number" "void" "Sets the full screen blur setting. Less is more, but if you set it too low it will make the on screen editing impossible to read, so save your script first :)" " (blur 0.1) ; for nice trails\n")) ("fog" ("fogcolour-vector amount-number begin-number end-number" "void" "Sets the fogging parameters to give a visual depth cue (aerial perspective in painter's jargon). This can obscure the on screen editing, so keep the amount small." " (clear-colour (vector 0 0 1))   ; looks nice if the background matches\n (fog (vector 0 0 1) 0.01 1 100) ; blue fog\n")) ("show-axis" ("show-number" "void" "Shows the worldspace origin axis used." " (show-axis 1)\n")) ("show-fps" ("show-number" "void" "Shows an fps count in the lower left of the screen. used." " (show-fps 1)\n")) ("lock-camera" ("primitiveid-number" "void" "Locks the camera transform onto the specified primitive's transform. It's like parenting the camera to the object. This is the easiest way to procedurally drive the camera. Use an id number of 0 to unlock the camera." " (clear)\n (define obj (build-cube)) ; make a cube for the camera to lock to\n\n (with-state ; make a background cube so we can tell what's happening\n     (hint-wire)\n     (hint-unlit)\n     (texture (load-texture \"test.png\"))\n     (colour (vector 0.5 0.5 0.5))\n     (scale (vector -20 -10 -10))\n     (build-cube))\n\n (lock-camera obj) ; lock the camera to our first cube\n (camera-lag 0.1)  ; set the lag amount, this will smooth out the cube jittery movement\n\n (define (animate)\n     (with-primitive obj\n         (identity)\n         (translate (vector (fmod (time) 5) 0 0)))) ; make a jittery movement\n\n (every-frame (animate))\n")) ("camera-lag" ("amount-number" "void" "The camera locking has an inbuilt lagging which means it will smoothly blend the movement relative to the primitive it's locked to." " (clear)\n (define obj (build-cube)) ; make a cube for the camera to lock to\n\n (with-state ; make a background cube so we can tell what's happening\n     (hint-wire)\n     (hint-unlit)\n     (texture (load-texture \"test.png\"))\n     (colour (vector 0.5 0.5 0.5))\n     (scale (vector -20 -10 -10))\n     (build-cube))\n\n (lock-camera obj) ; lock the camera to our first cube\n (camera-lag 0.1)  ; set the lag amount, this will smooth out the cube jittery movement\n\n (define (animate)\n     (with-primitive obj\n         (identity)\n         (translate (vector (fmod (time) 5) 0 0)))) ; make a jittery movement\n\n (every-frame (animate))\n")) ("load-texture" ("pngfilename-string optional-create-params-list" "textureid-number" "Loads a texture from disk, converts it to a texture, and returns the id number. The texture loading is memory cached, so repeatedly calling this will not cause it to load again. The cache can be cleared with clear-texture-cache. The png may be RGB or RGBA to use alpha transparency. To get more control how your texture is created you can use a list of parameters. See the example for more explanation. Use id for adding more texture data to existing textures as mipmap levels, or cube map faces. Note: if turning mipmapping off and only specifing one texture it should be set to mip level 0, and you'll need to turn the min and mag filter settings to linear or nearest (see texture-params)." " ; simple usage:\n (texture (load-texture \"mytexture.png\"))\n (build-cube) ; the cube will be texture mapped with the image\n\n ; complex usages:\n\n ; the options list can contain the following keys and values:\n ; id: texture-id-number (for adding images to existing textures - for mipmapping and cubemapping)\n ; type: [texture-2d cube-map-positive-x cube-map-negative-x cube-map-positive-y\n ;         cube-map-negative-y cube-map-positive-z cube-map-negative-z]\n ; generate-mipmaps : exact integer, 0 or 1\n ; mip-level : exact integer\n ; border : exact integer\n\n ; setup an environment cube map\n (define t (load-texture \"cube-left.png\" (list 'type 'cube-map-positive-x)))\n (load-texture \"cube-right.png\" (list 'id t 'type 'cube-map-negative-x))\n (load-texture \"cube-top.png\" (list 'id t 'type 'cube-map-positive-y))\n (load-texture \"cube-bottom.png\" (list 'id t 'type 'cube-map-negative-y))\n (load-texture \"cube-front.png\" (list 'id t 'type 'cube-map-positive-z))\n (load-texture \"cube-back.png\" (list 'id t 'type 'cube-map-negative-z))\n (texture t)\n\n ; setup a mipmapped texture with our own images\n ; you need as many levels as it takes you to get to 1X1 pixels from your\n ; level 0 texture size\n (define t2 (load-texture \"m0.png\" (list 'generate-mipmaps 0 'mip-level 0)))\n (load-texture \"m1.png\" (list 'id t2 'generate-mipmaps 0 'mip-level 1))\n (load-texture \"m2.png\" (list 'id t2 'generate-mipmaps 0 'mip-level 2))\n (load-texture \"m3.png\" (list 'id t2 'generate-mipmaps 0 'mip-level 3))\n (texture (load-texture \"mytexture.png\"\n        (list\n          'generate-mipmaps 0  ; turn mipmapping off\n              'border 2)))          ; add a border to the texture\n\n (build-cube) ; the cube will be texture mapped with the image\n")) ("clear-texture-cache" ("" "void" "Clears the texture cache, meaning changed textures on disk are reloaded." " (clear-texture-cache)\n")) ("frustum" ("left-number right-number bottom-number top-number" "void" "Sets the camera frustum, and thus the aspect ratio of the frame." " (frustum -1 1 -0.75 0.75) ; default settings\n")) ("clip" ("front-number back-number" "void" "Sets the front & back clipping planes for the camera frustum, and thus the viewing angle. Change the front clipping distance to alter the perspective from telephoto to fisheye." " (clip 1 10000) ; default settings\n")) ("ortho" ("" "void" "Sets orthographic projection - i.e. no perspective." " (ortho)\n")) ("persp" ("" "void" "Sets perspective projection (the default) after ortho has been set." " (persp)\n")) ("set-ortho-zoom" ("amount-number" "void" "Sets the zoom level for the orthographic projection." " (set-ortho-zoom 2)\n")) ("clear-colour" ("colour-vector" "void" "Sets the colour we clear the renderer with, this forms the background colour for the scene." " (clear-colour (vector 1 0 0)) ; RED!!!")) ("clear-frame" ("setting-number" "void" "Sets the frame clearing on or off." " (clear-frame 0)\n (clear-frame 1)\n")) ("clear-zbuffer" ("setting-number" "void" "Sets the zbuffer clearing on or off." " (clear-zbuffer 0)\n (clear-zbuffer 1)\n")) ("clear-accum" ("setting-number" "void" "Sets the accumulation buffer clearing on or off." " (clear-accum 1)\n")) ("build-camera" ("" "cameraid-number" "Adds a new camera/view and returns it's id" " (clear)\n (viewport 0 0.5 0.5 0.5)\n\n (define cam2 (build-camera))\n (current-camera cam2)\n (viewport 0.5 0 0.5 1)\n\n (define cam3 (build-camera))\n (current-camera cam3)\n (set-camera (mmul (mtranslate (vector 0 0 -5))\n         (mrotate (vector 0 45 0))))\n (viewport 0 0 0.5 0.5)\n\n ; render a primitive in one view only\n (define t (with-state\n     (translate (vector 3 0 0))\n     (scale 0.3)\n     (colour (vector 1 0 0))\n     (build-torus 1 2 10 10)))\n\n (with-primitive t\n     (hide 1) ; hide in all\n     (camera-hide 0)) ; unhide in current camera\n\n\n (current-camera 0)\n\n (define c (with-state\n         (hint-cull-ccw)\n         (hint-unlit)\n         (hint-wire)\n         (line-width 2)\n         (colour (vector 0.4 0.3 0.2))\n         (wire-colour (vector 0 0 0))\n         (scale 10)\n         (build-cube)))\n\n (define p (with-state\n         (scale 3)\n         (load-primitive \"widget.obj\")))\n\n (every-frame\n     (with-primitive p\n         (rotate (vector 0 1 0))))\n")) ("current-camera" ("cameraid-number" "void" "Sets the current camera to use" " (clear)\n (viewport 0 0.5 0.5 0.5)\n\n (define cam2 (build-camera))\n (current-camera cam2)\n (viewport 0.5 0 0.5 1)\n\n (define cam3 (build-camera))\n (current-camera cam3)\n (set-camera (mmul (mtranslate (vector 0 0 -5))\n         (mrotate (vector 0 45 0))))\n (viewport 0 0 0.5 0.5)\n\n ; render a primitive in one view only\n (define t (with-state\n     (translate (vector 3 0 0))\n     (scale 0.3)\n     (colour (vector 1 0 0))\n     (build-torus 1 2 10 10)))\n\n (with-primitive t\n     (hide 1) ; hide in all\n     (camera-hide 0)) ; unhide in current camera\n\n\n (current-camera 0)\n\n (define c (with-state\n         (hint-cull-ccw)\n         (hint-unlit)\n         (hint-wire)\n         (line-width 2)\n         (colour (vector 0.4 0.3 0.2))\n         (wire-colour (vector 0 0 0))\n         (scale 10)\n         (build-cube)))\n\n (define p (with-state\n         (scale 3)\n         (load-primitive \"widget.obj\")))\n\n (every-frame\n     (with-primitive p\n         (rotate (vector 0 1 0))))\n")) ("viewport" ("x-number y-number width-number height-number" "void" "Sets the viewport on the current camera. This is the area of the window the camera renders to, where 0,0 is the bottom left and 1,1 is the top right." " (clear)\n (viewport 0 0.5 0.5 0.5)\n\n (define cam2 (build-camera))\n (current-camera cam2)\n (viewport 0.5 0 0.5 1)\n\n (define cam3 (build-camera))\n (current-camera cam3)\n (set-camera (mmul (mtranslate (vector 0 0 -5))\n         (mrotate (vector 0 45 0))))\n (viewport 0 0 0.5 0.5)\n\n ; render a primitive in one view only\n (define t (with-state\n     (translate (vector 3 0 0))\n     (scale 0.3)\n     (colour (vector 1 0 0))\n     (build-torus 1 2 10 10)))\n\n (with-primitive t\n     (hide 1) ; hide in all\n     (camera-hide 0)) ; unhide in current camera\n\n\n (current-camera 0)\n\n (define c (with-state\n         (hint-cull-ccw)\n         (hint-unlit)\n         (hint-wire)\n         (line-width 2)\n         (colour (vector 0.4 0.3 0.2))\n         (wire-colour (vector 0 0 0))\n         (scale 10)\n         (build-cube)))\n\n (define p (with-state\n         (scale 3)\n         (load-primitive \"widget.obj\")))\n\n (every-frame\n     (with-primitive p\n         (rotate (vector 0 1 0))))\n")) ("get-camera" ("" "matrix-vector" "Gets the current camera transform matrix. This is the low level function, use get-camera-transform instead." " (get-camera)\n")) ("get-locked-matrix" ("" "matrix-vector" "Gets the current camera lock transform matrix. Takes the lag into account" " (get-locked-matrix)\n")) ("set-camera" ("" "void" "Sets the camera transform matrix. This is the low level interface used by set-camera-transform, which you should generally use instead." " (set-camera (mtranslate (vector 0 0 -10)))\n")) ("get-projection-transform" ("" "projection-matrix" "Gets the current projection matrix." " (get-projection-transform)\n")) ("set-projection-transform" ("matrix-vector" "void" "Sets the projection matrix directly." " (set-projection-transform (vector 1 0 0 0 0 4/3 0 0 0 0 -1 -1 0 0 -2 -0))\n")) ("get-screen-size" ("" "size-vector" "Returns a vector containing the current width and height of the window." " (get-screen-size)\n")) ("set-screen-size" ("size-vector" "void" "Sets the window width and height." " (set-screen-size (vector 10 10)) ; small window time :)\n (set-screen-size (vector 720 576)) ; and back again!\n")) ("select" ("screenxpos-number screenypos-number pixelssize-number" "primitiveid-number" "Looks in the region specified and returns the id of the closest primitive to the camera rendered there, or 0 if none exist." " (display (select 10 10 2))(newline)\n")) ("select-all" ("screenxpos-number screenypos-number pixelssize-number" "list of primitiveid-numbers" "Looks in the region specified and returns all ids rendered there in a list, or '() if none exist." " (display (select-all 10 10 2))(newline)\n")) ("desiredfps" ("fps-number" "void" "Throttles the renderer so as to not take 100% cpu. This gives an upper limit on the fps rate, which doesn't quite match the given number, but I'm working on it..." " (desiredfps 100000) ; makes fluxus render as fast as it can, and take 100% cpu.\n")) ("draw-buffer" ("buffer_name" "void" "Select which buffer to draw in for stereo mode you'd do 'back-right and 'back-left" " (draw-buffer 'back)\n")) ("read-buffer" ("buffer_name" "void" "Select which buffer to read from" " (read-buffer 'back)\n")) ("set-stereo-mode" ("mode" "bool" "select which stereo mode to use currently only 'crystal-eyes and 'no-stereo are supported the return indicates if the operation was successful or not 'crystal-eyes will return false if you don't have a stereo window" " (set-stereo-mode 'crystal-eyes)\n")) ("set-colour-mask" ("vector" "void" "sets the colour mask give it a quat of booleans which correspond to the red, green, blue and alpha channels respectively after this operation you'll only see those colour which you set to true (this is useful for stereo with red-blue glasses)" " (set-colour-mask #(#t #f #f #t))\n")) ("shadow-light" ("number-setting" "void" "Sets the light to use for generating shadows, set to 0 to disable shadow rendering." " (shadow-light 1)\n")) ("shadow-length" ("number-setting" "void" "Sets the length of the shadow volume rendering." " (shadow-length 10)\n")) ("shadow-debug" ("number-setting" "void" "Turns on debug rendering of the shadow volume rendering." " (shadow-debug 1)\n")) ("accum" ("mode-symbol value-number" "void" "Controls the accumulation buffer (just calls glAccum under the hood). Possible symbols are: accum load return add mult" " (accum 'add 1)\n")) ("print-info" ("" "void" "Prints out a load of renderer information" " (print-info)\n")) ("set-cursor" ("image-name-symbol" "void" "Changes the mouse cursor. Cursor image name symbols can consist of: 'right-arrow, 'left-arrow, 'info, 'destroy, 'help, 'cycle, 'spray, 'wait, 'text, 'crosshair, 'up-down, 'left-right, 'top-side, 'bottom-side, 'left-side, 'right-side, 'top-left-corner, 'top-right-corner, 'bottom-right-corner, 'bottom-left-corner, 'full-crosshair, 'none, 'inherit The default cursor image symbol when the window is created is 'inherit." " (set-cursor 'crosshair)\n")) ("set-full-screen" ("" "void" "Requests that the current fluxus window be made full screen." " (set-full-screen)\n"))))) ("local-state" ("The local state functions control rendering either for the current state - or the state of the current primitive. In fluxus state means the way that things are displayed, either turning on and off rendering features, changing the style of different features, or altering the current transform." "" (("push" ("" "void" "Pushes a copy of the current drawing state to the top of the stack. The drawing state contains information about things like the current colour, transformation and hints. This function has been superseded by (with-state)." " (colour (vector 1 0 0)) ; set current colour to red\n (push)                  ; copy and push drawing state\n (colour (vector 0 1 0)) ; set current colour to green\n (draw-cube)             ; draws a green cube\n (pop)           ; forget old drawing state\n ; current colour is now red again\n")) ("pop" ("" "void" "Destroys the current drawing state, and sets the current one to be the previously pushed one in the stack. The drawing state contains information about things like the current colour, transformation and hints. This function has been superseded by (with-state)." " (colour (vector 1 0 0)) ; set current colour to red\n (push)                  ; copy and push drawing state\n (colour (vector 0 1 0)) ; set current colour to green\n (draw-cube)             ; draws a green cube\n (pop)                   ; forget old drawing state\n ; current colour is now red again\n")) ("grab" ("object-id" "void" "Grabs the specified object. Once an object has grabbed it's state can be modified using the same commands used to set the current drawing state. (ungrab) needs to be used to return to the normal drawing state. Grabbing can also be stacked, in which case ungrab pops to the last grabbed primitive. This function has been superseded by (with-primitive)." " (colour (vector 1 0 0))      ; set the current colour to red\n (define mycube (build-cube)) ; makes a red cube\n (grab mycube)\n (colour (vector 0 1 0)) ; sets the cubes colour to green\n (ungrab)          ; return to normal state\n")) ("ungrab" ("" "void" "Ungrabs the current object, and either returns to the normal drawing state, or pops to the last grabbed primitive. This function has been superseded by (with-primitive)." " (colour (vector 1 0 0))      ; set the current colour to red\n (define mycube (build-cube)) ; makes a red cube\n (grab mycube)\n (colour (vector 0 1 0)) ; sets the cubes colour to green\n (ungrab)          ; return to normal state\n")) ("apply-transform" ("optional-object-id" "void" "Applies the current object transform to the vertex positions of the current object and sets it's transform to identity. Will also use the optional id passed in for the aniquated version of this command" " (rotate (vector 45 0 0))\n (define mycube (build-cube)) ; makes a cube with a rotation\n (with-primitive mycube (apply-transform)) ; applies the rotation to the points of the cube\n")) ("opacity" ("value" "void" "Sets the opacity of the current drawing state, or the current primitive." " (opacity 0.5)\n (define mycube (build-cube)) ; makes a half transparent cube\n")) ("wire-opacity" ("value" "void" "Sets the wireframe opacity of the current drawing state, or the current primitive." " (hint-none)\n (hint-wire)\n (backfacecull 0)\n (line-width 5)\n (wire-colour (vector 1 1 1))\n (wire-opacity 0.5)\n (build-cube) ; makes a half transparent wireframe cube\n")) ("shinyness" ("value" "void" "Sets the shinyness of the current drawing state, or the current primitive. This value sets the tightness of the specular highlight." " (shinyness 100)\n (specular (vector 1 1 1)) ; sets the specular colour\n (define mysphere (build-sphere 10 10)) ; makes a shiny cube\n")) ("colour" ("colour-vector" "void" "Sets the colour of the current drawing state, or the current primitive." " (colour (vector 1 0.5 0.1)) ; mmm orange...\n (define mycube (build-cube)) ; makes an orange cube\n")) ("colour-mode" ("mode" "void" "Changes the way Fluxus interprets colour data for the current drawing state, or the current primitive. Colourmode symbols can consist of: rgb hsv" " (clear)\n (colour-mode 'hsv)\n\n (for ((x (in-range 0 10)))\n   (translate (vector 1 0 0))\n   (colour (vector (/ x 10) 1 1))\n   (build-cube))\n")) ("rgb->hsv" ("colour-vector" "vector" "Converts the RGB colour to HSV." " (rgb->hsv (vector 1 0.5 0.1))\n")) ("hsv->rgb" ("colour-vector" "vector" "Converts the HSV colour to RGB." " (clear)\n (for* ((x (in-range 0 10))  ; builds a 10x10 HSV colour pattern\n        (y (in-range 0 10)))\n     (identity)\n     (translate (vector x y 0))\n     (colour (hsv->rgb (vector (/ x 10) (/ y 10) 1)))\n     (build-cube))\n")) ("wire-colour" ("colour-vector" "void" "Sets the wire frame colour of the current drawing state, or the current primitive. Visible with (hint-wire) on most primitives." " (wire-colour (vector 1 1 0)) ; set yellow as current wire colour\n (hint-wire)\n (define mycube (build-cube)) ; makes a cube with yellow wireframe\n")) ("normal-colour" ("colour-vector" "void" "Sets the normals frame colour of the current drawing state, or the current primitive. Visible with (hint-normal) on most primitives." " (normal-colour (vector 1 1 0)) ; set yellow as current normals colour\n (hint-normal)\n (define mycube (build-cube)) ; makes a cube with yellow wireframe\n")) ("specular" ("colour-vector" "void" "Sets the specular colour of the current drawing state, or the current primitive." " (specular (vector 0 0 1)) ; set blue as specular colour\n (define mysphere (build-sphere 10 10)) ; makes a shiny blue sphere\n")) ("ambient" ("colour-vector" "void" "Sets the ambient colour of the current drawing state, or the current primitive." " (ambient (vector 0 0 1)) ; set blue as ambient colour\n (define mysphere (build-sphere 10 10)) ; makes a boringly blue sphere\n")) ("emissive" ("value" "void" "Sets the emissive colour of the current drawing state, or the current primitive." " (emissive (vector 0 0 1)) ; set blue as emissive colour\n (define mysphere (build-sphere 10 10)) ; makes an bright blue sphere\n")) ("identity" ("" "void" "Sets the drawing state transform to identity, on the state stack, or the current primitive." " (define mycube (with-state\n     (scale (vector 2 2 2)) ; set the current scale to double in each dimension\n     (build-cube))) ; make a scaled cube\n\n (with-primitive mycube\n     (identity)) ; erases the transform and puts the cube back to its original state\n")) ("concat" ("matrix" "void" "Concatenates (multiplies) a matrix on to the current drawing state or current primitive." " (define mymatrix (mrotate (vector 0 45 0))) ; make a matrix\n (concat mymatrix) ; concat it into the current state\n (build-cube) ; make a cube with this rotation\n")) ("translate" ("vector" "void" "Applies a translation to the current drawing state transform or current primitive." " (translate (vector 0 1.4 0)) ; translates the current transform up a bit\n (build-cube) ; build a cube with this transform\n")) ("rotate" ("vector-or-quaternion" "void" "Applies a rotation to the current drawing state transform or current primitive." " (rotate (vector 0 45 0)) ; turns 45 degrees in the Y axis\n (build-cube) ; build a cube with this transform\n")) ("scale" ("vector" "void" "Applies a scale to the current drawing state transform or current primitive." " (scale (vector 0.5 0.5 0.5)) ; scales the current transform to half the size\n (build-cube) ; build a cube with this transform\n")) ("get-transform" ("" "matrix-vector" "Returns a matrix representing the current state transform or for the current primitive." " (clear)\n ; build a hierarchy\n (define a\n     (with-state\n         (colour (vector 1 0.5 0.5))\n         (build-cube)))\n (define b (with-state\n         (colour (vector 0.5 1 0.5))\n         (parent a)\n         (translate (vector 2 0 0))\n         (build-cube)))\n (define c (with-state\n         (colour (vector 0.5 0.5 1))\n         (parent b)\n         (translate (vector 2 0 0))\n         (build-cube)))\n\n (define (animate)\n     ; animate the heirarchy\n     (with-primitive a (rotate (vector 0 0 (sin (time)))))\n     (with-primitive b (rotate (vector 0 0 (sin (time)))))\n     (with-primitive c (rotate (vector 0 0 (sin (time)))))\n\n     ; position a yellow sphere with c's local transform\n     (with-state\n         (concat (with-primitive c (get-transform)))\n         (opacity 0.5)\n         (colour (vector 1 1 0))\n         (draw-sphere))\n\n     ; position a purple sphere with c's global transform\n     (with-state\n         (concat (with-primitive c (get-global-transform)))\n         (opacity 0.5)\n         (colour (vector 1 0 1))\n         (draw-sphere)))\n\n (every-frame (animate))\n")) ("get-global-transform" ("" "matrix-vector" "Returns a matrix representing the current global transform for the current primitive." " (clear)\n ; build a hierarchy\n (define a\n     (with-state\n         (colour (vector 1 0.5 0.5))\n         (build-cube)))\n (define b (with-state\n         (colour (vector 0.5 1 0.5))\n         (parent a)\n         (translate (vector 2 0 0))\n         (build-cube)))\n (define c (with-state\n         (colour (vector 0.5 0.5 1))\n         (parent b)\n         (translate (vector 2 0 0))\n         (build-cube)))\n\n (define (animate)\n     ; animate the heirarchy\n     (with-primitive a (rotate (vector 0 0 (sin (time)))))\n     (with-primitive b (rotate (vector 0 0 (sin (time)))))\n     (with-primitive c (rotate (vector 0 0 (sin (time)))))\n\n     ; position a yellow sphere with c's local transform\n     (with-state\n         (concat (with-primitive c (get-transform)))\n         (opacity 0.5)\n         (colour (vector 1 1 0))\n         (draw-sphere))\n\n     ; position a purple sphere with c's global transform\n     (with-state\n         (concat (with-primitive c (get-global-transform)))\n         (opacity 0.5)\n         (colour (vector 1 0 1))\n         (draw-sphere)))\n\n (every-frame (animate))\n")) ("parent" ("primitive-id" "void" "Parents the current primitive to the supplied parent primitive. The current primitive will now be moved around with the parent by aquiring all the parent's transforms." " (define parent-prim (build-cube)) ; make a parent cube\n (translate (vector 2 0 0)) ; move a bit in x\n (parent parent-prim) ; set parent-prim as the current parent\n (define child-prim (build-cube)) ; make a child cube\n (grab parent-prim)\n (rotate (vector 0 45 0)) ; the child will now be moved by this transform in addition to its own\n (ungrab)\n")) ("line-width" ("value" "void" "Sets the line width (in screen space) of the current drawing state, or the current primitive. Affects wireframe and things like that." " (line-width 5)\n (hint-wire)\n (build-sphere 10 10) ; make a sphere with thick wireframe\n")) ("point-width" ("value" "void" "Sets the point width (in screen space) of the current drawing state, or the current primitive. Affects point rendering and particles in hardware point mode." " (point-width 5)\n (hint-points)\n (build-sphere 10 10) ; make a sphere with thick points\n")) ("blend-mode" ("src dst" "void" "Sets the blend mode of the current drawing state, or the current primitive. This is the way that alpha is composited to the rendering surface. Blendmode symbols can consist of: zero one dst-color one-minus-dst-color src-alpha one-minus-src-alpha dst-alpha one-minus-dst-alpha Also src-alpha-saturate as an option for the source blendmode only." " ; list out all the possible blendmodes\n\n (define src-blend (vector 'zero 'one 'dst-color 'one-minus-dst-color 'src-alpha\n                     'one-minus-src-alpha 'dst-alpha 'one-minus-dst-alpha\n                     'src-alpha-saturate))\n\n (define dst-blend (vector 'zero 'one 'src-color 'one-minus-src-color 'src-alpha\n                     'one-minus-src-alpha 'dst-alpha 'one-minus-dst-alpha))\n\n ; picks a random element\n (define (pick-rnd-item l)\n     (vector-ref l (random (vector-length l))))\n\n ; make lots of random spheres\n (define (rnd-sphere n)\n     (push)\n     (hint-depth-sort)\n     (opacity 0.5)\n     (colour (vector (flxrnd) (flxrnd) (flxrnd)))\n\n     ; set a random blendmode\n     (blend-mode (pick-rnd-item src-blend) (pick-rnd-item dst-blend))\n\n     (translate (vector (flxrnd) (flxrnd) (flxrnd)))\n     (scale (vector 0.1 0.1 0.1))\n     (build-sphere 10 10)\n     (pop)\n     (if (zero? n)\n         0\n         (rnd-sphere (- n 1))))\n\n (clear)\n (clear-colour (vector 0.5 0.5 0.5))\n (rnd-sphere 100)\n")) ("hint-solid" ("" "void" "Sets the render hints to solid of the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-solid) ; this is the default render style so this isn't too exciting\n (build-cube) ; make a solid rendered cube\n")) ("hint-wire" ("" "void" "Sets the render hints to wireframe of the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-wire)\n (build-cube) ; make a wirefame rendered cube\n")) ("hint-wire-stippled" ("" "void" "Sets the render hints to stippled wireframe of the current drawing state, or the current primitive." " (hint-none)\n (hint-wire-stippled)\n (build-cube) ; make a stippled wirefame cube\n")) ("hint-frustum-cull" ("" "void" "Sets the render hints to turn frustum culling on for the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint. When using frustum culling, make sure you call (recalc-bb) on the primitive too." " (hint-frustum-cull)\n")) ("hint-normalize" ("" "void" "If the current state transform contains a scale transformation, transformed normals might not be unit length, resulting in undesirable lighting problems. (hint-normalize) makes all normals unit length after they are transformed. This is required if the current state transform contains nonuniform scaling." " (clear)\n (hint-normalize)\n (build-cube)\n ; non uniform scaling\n (with-primitive (build-cube)\n    (translate #(.5 0 0))\n    (scale #(3 1 1))\n    (translate #(.5 0 0)))\n ; uniform scaling\n (with-primitive (build-cube)\n    (translate #(0 0 2))\n    (scale 2))\n")) ("hint-noblend" ("" "void" "Disables blending. Useful if objects with blending rendered into a pixelprimitive." " (clear)\n (hint-wire)\n (scale #(9.8 8 1))\n (translate #(-1 -.5 0))\n (define p0 (build-pixels 512 512 #t))\n (with-pixels-renderer p0\n    (hint-ignore-depth)\n    (with-primitive (build-particles 2048)\n        (pdata-map! (lambda (p) (vmul (crndvec) 2)) \"p\")\n        (pdata-map! (lambda (c) #(1 .5)) \"c\")))\n\n (hint-noblend)\n (translate #(1 0 0))\n (define p1 (build-pixels 512 512 #t))\n (with-pixels-renderer p1\n    (hint-ignore-depth)\n    (with-primitive (build-particles 2048)\n        (pdata-map! (lambda (p) (vmul (crndvec) 2)) \"p\")\n        (pdata-map! (lambda (c) #(1 .5)) \"c\")))\n")) ("hint-nozwrite" ("" "void" "Disables z writes. Useful for sometimes hacking transparency." " (clear)\n (hint-noblend)\n")) ("line-pattern" ("factor pattern" "void" "Factor specifies a multiplier for each bit in the line stipple pattern. Pattern specifies a 16-bit integer whose bit pattern determines which fragments of a line will be drawn when the line is rasterized." " (hint-none)\n (hint-wire-stippled)\n (line-pattern 4 #x0aaaa)\n (build-cube) ; make a stippled wirefame cube\n")) ("hint-normal" ("" "void" "Sets the render hints to display normals in the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-normal)\n (build-cube) ; display the normals on this cube\n")) ("hint-points" ("" "void" "Sets the render hints to display points in the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-points)\n (build-cube) ; display the vertex points on this cube\n")) ("hint-anti-alias" ("" "void" "Sets the render hints to anti-alias in the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-anti-alias)\n (build-cube) ; display a smoothed cube\n")) ("hint-unlit" ("" "void" "Sets the render hints to unlit in the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-unlit)\n (build-cube) ; display an unlit cube\n")) ("hint-vertcols" ("" "void" "Sets the render hints to use vertex colours in the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint. Vertex colours override the current (colour) state." " (clear)\n (hint-vertcols)\n (define mycube (build-cube)) ; make a cube with vertcols enabled\n\n (with-primitive mycube\n     (pdata-map!\n         (lambda (c)\n             (rndvec)) ; randomise the vertcols\n         \"c\"))\n")) ("hint-box" ("" "void" "Sets the render hints to bounding box display in the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-box)\n (build-sphere 10 10) ; make a sphere with bounding box displayed\n")) ("hint-none" ("" "void" "Clears the render hints in the current drawing state, or the current primitive. This allows you mainly to get rid of the default solid style, but also means that you can turn on and off hints without using push or pop." " (hint-none)\n (hint-wire)\n (build-cube) ; make a cube only visible with wireframe\n")) ("hint-origin" ("" "void" "Sets the render hints to display the object space origin of the primitive in the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-origin)\n (build-sphere 10 10) ; make a sphere with the origin displayed\n")) ("hint-cast-shadow" ("" "void" "(note: Not yet implemented) Sets the render hints to cast shadows for the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-origin)\n (build-sphere 10 10) ; make a sphere with the origin displayed\n")) ("hint-depth-sort" ("" "void" "Sets the render hints to depth sort for the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-depth-sort)\n (build-sphere 10 10)\n")) ("hint-ignore-depth" ("" "void" "Sets the render hints to ignore depth tests for the current drawing state, or the current primitive. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint. This feature is useful for rendering transparent objects, as it means objects will be shown behind previously rendered ones." " (clear)\n (with-state\n     (hint-ignore-depth)\n     (opacity 0.6)\n     (with-state\n         (colour (vector 1 0 0))\n         (build-cube))\n     (with-state\n         (colour (vector 0 1 0))\n         (translate (vector 1 0 0))\n         (build-cube)))\n")) ("hint-lazy-parent" ("" "void" "Sets the render hints to prevent this primitive passing it's transform to it's children. Render hints change the way that primitives are rendered, but may have different effects - or no effect on certain primitive types, hence the name hint." " (hint-lazy-parent)\n (build-sphere 10 10) ; make a sphere with the origin displayed\n")) ("hint-cull-ccw" ("" "void" "Flips the faces which get backface culled" " (hint-cull-ccw)\n (build-sphere 10 10) ; make an inside out\n")) ("hint-sphere-map" ("" "void" "Sets the render hints to render objects as if they were perfecly reflective for the current drawing state, or the current primitive." " (clear)\n (hint-sphere-map)\n (texture (load-texture \"test.png\"))\n (define p (build-torus 1 2 20 20))\n (every-frame (with-primitive p\n                 (rotate #(.543 .59 .87))))\n")) ("texture" ("textureid-number" "void" "Sets the texture of the current drawing state, or the current primitive. Texture ids can be generated by the load-texture function." " (texture (load-texture \"mytexture.png\"))\n (build-sphere 10 10) ; make a sphere textured with mytexture.png\n")) ("multitexture" ("textureunit-number textureid-number" "void" "Sets the texture of the current drawing state, or the current primitive in the same way as the texture function, but allows you to specify the texture unit (0-7) to apply the texture to. Multitexturing allows you to apply different textures and texture coordinates to the same object at once. Texture unit 0 is the default one (which uses the pdata \"t\" for it's texture coords) texture unit n looks for pdata \"tn\" - ie multitexture 1 looks for \"t1\". You need to add these yourself using (pdata-add) or (pdata-copy). Multitexturing is useful when the textures contain alpha, as they can be overlayed, i.e. decals placed on background textures." " (clear)\n (define p (build-torus 1 2 20 20))\n\n (with-primitive p\n     (multitexture 0 (load-texture \"refmap.png\"))\n     (multitexture 1 (load-texture \"transp.png\")))\n")) ("print-scene-graph" ("" "void" "Prints out the current scene graph, useful for debugging." " (print-scene-graph) ; exciting...\n")) ("hide" ("hidden-number" "void" "Sets the hidden state for the current primitive (also affects all child primitives). Hidden primitives can be treated as normal in every way - they just won't be rendered." " (define obj (build-cube))\n (grab obj)\n (hide 1) ; hide this cube\n (ungrab)\n")) ("camera-hide" ("hidden-number" "void" "Sets the hidden state for the current primitive, with the current camera (also affects all child primitives). Allows you to turn off rendering for primitives under different cameras" " (define obj (build-cube))\n (with-primitive obj\n     (camera-hide 1)) ; hide this cube\n")) ("selectable" ("selectable-number" "void" "Sets whether the current primitive can be selected or not using the select command." " (define obj (build-cube))\n (grab obj)\n (selectable 0) ; now it won't be \"seen\" by calling select\n (ungrab)\n")) ("backfacecull" ("setting-number" "void" "Turns backface culling on or off. Backface culling speeds up rendering by removing faces not orientated towards the camera. Defaults to on, but this is not always desired, eg for double sided polygons." " (backfacecull 0)\n")) ("shader" ("vertexprogram-string fragmentprogram-string" "void" "Loads, compiles and sets the GLSL harware shader pair for the current drawing state, or the current primitive. Requires OpenGL 2 support. The shader's uniform data can be controlled via shader-set! and all the pdata is sent through as per-vertex attribute data to the shader." " ; you need to have built fluxus with GLSL=1\n (clear)\n (fluxus-init) ; this is important to add when using shaders\n               ; at the moment, it will be moved somewhere\n               ; to run automatically...\n\n (define s (with-state\n     ; assign the shaders to the surface\n     (shader \"simple.vert.glsl\" \"simple.frag.glsl\")\n     (build-sphere 20 20)))\n\n (with-primitive s\n     ; add and set the pdata - this is then picked up in the vertex shader\n     ; as an input attribute called \"testcol\"\n     (pdata-add \"testcol\" \"v\")\n     ; set the testcol pdata with a random colour for every vertex\n     (pdata-map!\n         (lambda (c)\n             (rndvec))\n         \"testcol\"))\n\n (define (animate)\n     (with-primitive s\n         ; animate the deformamount uniform input parameter\n         (shader-set! (list \"deformamount\" (cos (time))))))\n\n (every-frame (animate))\n")) ("shader-source" ("vertexprogram-source-string fragmentprogram-source-string" "void" "Same as shader, but uses the supplied strings as shader sourcecode. This allows you to embed GLSL shader source inside your scheme scripts." " ; you need to have built fluxus with GLSL=1\n")) ("clear-shader-cache" ("" "void" "Clears the shader cache." " (clear-shader-cache)\n")) ("shader-set!" ("argument-list" "void" "Sets the uniform shader parameters for the GLSL shader. The list consists of token-string value pairs, which relate to the corresponding shader parameters names and values." " ; you need to have built fluxus with GLSL=1\n (clear)\n (fluxus-init) ; this is important to add when using shaders\n               ; at the moment, it will be moved somewhere\n               ; to run automatically...\n\n (define s (with-state\n     ; assign the shaders to the surface\n     (shader \"simple.vert.glsl\" \"simple.frag.glsl\")\n     (build-sphere 20 20)))\n\n (with-primitive s\n     ; add and set the pdata - this is then picked up in the vertex shader\n     ; as an input attribute called \"testcol\"\n     (pdata-add \"testcol\" \"v\")\n     ; set the testcol pdata with a random colour for every vertex\n     (pdata-map!\n         (lambda (c)\n             (rndvec))\n         \"testcol\"))\n\n (define (animate)\n     (with-primitive s\n         ; animate the deformamount uniform input parameter\n         (shader-set! (list \"deformamount\" (cos (time))))))\n\n (every-frame (animate))\n")) ("texture-params" ("texture-unit-number parameter-list" "void" "Sets the current texture state for the specified texture unit. This state controls how the texture is applied to the surface of the object, and how it's filtered in texels, or miplevels. The texture unit is used if you are using multitexturing - the default texture unit is 0. You may need to read up a bit on OpenGL or experiment to find out more about these options." " ; parameters are the following:\n ; tex-env : [modulate decal blend replace]\n ; min : [nearest linear nearest-mipmap-nearest linear-mipmap-nearest linear-mipmap-linear]\n ; mag : [nearest linear]\n ; wrap-s : [clamp repeat]\n ; wrap-t : [clamp repeat]\n ; wrap-r : [clamp repeat] (for cube maps)\n ; border-colour : (vector of length 4)\n ; priority : real number 0 -> 1\n ; env-colour : (vector of length 4)\n ; min-lod : real number (for mipmap blending - default -1000)\n ; max-lod : real number (for mipmap blending - default 1000)\n (texture-params 0 '(min nearest mag nearest))\n"))))) ("primitive-data" ("Primitive data (pdata for short) is fluxus' name for data which comprises primitives. In polygon primitives this means the vertex information, in particle primitives it corresponds to the particle information, in NURBS primitives it's the control vertices. Access to pdata gives you the ability to use primitives which are otherwise not very interesting, and deform and shape other primitives to give much more detailed models and animations. You can also add your own pdata, which is treated exactly like the built in types. Primitive data is named by type strings, the names of which depend on the sort of primitive. All pdata commands operate on the currently grabbed primitive." " ; a function to deform the points of an object\n (define (deform n)\n     (pdata-set! \"p\" n (vadd  (pdata-ref \"p\" n)                ; the original point, plus\n         (vmul (vector (flxrnd) (flxrnd) (flxrnd)) 0.1)))     ; a small random vector\n     (if (zero? n)\n         0\n         (deform (- n 1))))\n     \n (hint-unlit) ; set some render settings to\n (hint-wire)  ; make things easier to see\n (line-width 4)\n (define myobj (build-sphere 10 10)) ; make a sphere\n (grab myobj)\n (deform (pdata-size)) ; deform it\n (ungrab)\n" (("pdata-ref" ("type-string index-number" "value-vector/colour/matrix/number" "Returns the corresponding pdata element." " (pdata-ref \"p\" 1)\n")) ("pdata-set!" ("type-string index-number value-vector/colour/matrix/number" "void" "Writes to the corresponding pdata element." " (pdata-set! \"p\" 1 (vector 0 100 0))\n")) ("pdata-add" ("name-string type-string" "void" "Adds a new user pdata array. Type is one of \"v\":vector, \"c\":colour, \"f\":float or \"m\":matrix." " (pdata-add \"mydata\" \"v\")\n (pdata-set \"mydata\" 0 (vector 1 2 3))\n")) ("pdata-exists?" ("name-string" "void" "Returns true if the pdata array exists on the primitive" " (with-primitive (build-cube)\n   (when (pdata-exists? \"p\") \n     (display \"we have positions!\") (newline))\n   (pdata-add \"myarray\" \"v\")\n   (when (pdata-exists? \"myarray\") \n     (display \"we have myarray!\") (newline)))\n")) ("pdata-names" ("" "void" "Returns a list of the names of the pdata arrays for this primitive. t -> texture p -> position c -> color" " (with-primitive (build-cube)\n     (display (pdata-names)) (newline))\n")) ("pdata-op" ("funcname-string pdataname-string operator" "void" "This is an experimental feature allowing you to do operations on pdata very quickly, for instance adding element for element one array of pdata to another. You can implement this in Scheme as a loop over each element, but this is slow as the interpreter is doing all the work. It's much faster if you can use a pdata-op as the same operation will only be one Scheme call." " (clear)\n (define t (build-torus 1 4 10 10))\n \n (with-primitive t\n     (pdata-op \"+\" \"p\" (vector 1 0 0))  ; add a vector to all the pdata vectors\n     (pdata-op \"+\" \"p\" \"n\")  ; add two pdata vectors element for element\n     (pdata-op \"*\" \"n\" (vector -1 -1 -1)) ;  multiply a vector to all the pdata vectors\n     (pdata-op \"*\" \"n\" \"p\")  ; multiply two pdata vectors element for element\n     (let ((pos (pdata-op \"closest\" \"p\" (vector 100 0 0)))) ;  returns position of the closest vertex to this point\n         (with-state ; draw a sphere there\n             (translate pos)\n             (scale (vector 0.1 0.1 0.1))\n             (build-sphere 5 5)))\n     ; can't think of a good example for these...\n     ;(pdata-op \"sin\" \"mydata\" \"myotherdata\")  ; sine of one float pdata to another\n     ;(pdata-op \"cos\" \"mydata\" \"myotherdata\")  ; cosine of one float pdata to another\n     )\n \n ; most common example of pdata op is for particles\n (define p (with-state\n     (hint-points)\n     (point-width 10)\n     (build-particles 100)))\n \n (with-primitive p\n     (pdata-add \"vel\" \"v\") ; add a velocity vector\n     (pdata-map!\n         (lambda (vel)\n             (srndvec)) ; set random velocities\n         \"vel\")\n     (pdata-map!\n         (lambda (c)\n             (rndvec)) ; set random colours\n         \"c\"))\n \n (every-frame (with-primitive p\n     (pdata-op \"+\" \"p\" \"vel\"))) \n")) ("pdata-copy" ("pdatafrom-string pdatato-string" "void" "Copies the contents of one pdata array to another. Arrays must match types." " (pdata-copy \"p\" \"mydata\") ; copy the vertex positions to a user array\n")) ("pdata-size" ("" "count-number" "Returns the size of the pdata arrays (they must all be the same). This is mainly used for iterating over the arrays." " (define (mashup n)\n     (pdata-set \"p\" n (vector (flxrnd) (flxrnd) (flxrnd))) ; randomise the vertex position\n     (if (zero? n)\n         0\n         (mashup (- n 1)))) ; loops till n is 0\n\n (define shape (build-sphere 10 10))\n (grab shape)\n (mashup (pdata-size)) ; randomise verts on currently grabbed primitive\n (ungrab)\n")) ("recalc-normals" ("smoothornot-number" "void" "For polygon primitives only. Looks at the vertex positions and calculates the lighting normals for you automatically. Call with \"1\" for smooth normals, \"0\" for faceted normals." " (define shape (build-sphere 10 10)) ; build a sphere (which is smooth by default)\n (grab shape)\n (recalc-normals 0) ; make the sphere faceted\n (ungrab)\n"))))) ("primitives" ("Primitives are objects that you can render. There isn't really much else in a fluxus scene, except lights, a camera and lots of primitives." "" (("build-cube" ("" "primitiveid-number" "A simple cube, texture mapped placement per face." " (define mynewcube (build-cube))\n")) ("build-polygons" ("verts-number type-symbol" "primitiveid-number" "Builds a raw polygon primitive with size vertices (everything is initially set to zero). Type is a symbol that refers to the way the vertices are interpreted to build polygons, and can be one of the following: triangle-strip quad-list triangle-list triangle-fan polygon" " (define mynewshape (build-polygons 100 'triangle-strip))\n")) ("build-sphere" ("slices-number stacks-number" "primitiveid-number" "A sphere with the resolution specified, texture mapped in normal \"world map\" style." " (define mynewshape (build-sphere 10 10))\n")) ("build-torus" ("inner-radius-number outer-radius-number slices-number stacks-number" "primitiveid-number" "A torus with the resolution specified, control the size and thickness of the donut with the inner and outer radius." " (define mynewshape (build-torus 0.5 1 12 12))\n")) ("build-plane" ("" "primitiveid-number" "A single quad plane, texture mapped from 0->1 in both dimensions." " (define mynewshape (build-plane))\n")) ("build-seg-plane" ("vertsx-number vertsy-number" "primitiveid-number" "A tesselated poly plane, texture mapped from 0->1 in both dimensions." " (define mynewshape (build-plane))\n")) ("build-cylinder" ("hsegments rsegments" "primitiveid-number" "A capped cylinder, texture map wrapped around, and badly wrapped around the ends." " (define mynewshape (build-cylinder 10 10))\n")) ("build-ribbon" ("numpoints-number" "primitiveid-number" "Builds a ribbon consisting of numpoints points. The geometry is constantly camera facing and is texture mapped so the texture is stretched along the ribbon from start to finish. You use the pdata functions to edit the postions and widths of the segments. If used lit, the normals are faked to approximate a circular cross section. Additionally, if solid rendering is cleared with (hint-none) and (hint-wire) is activated, a faster constant width line will be drawn - width specified by the (line-width) command." " (define mynewshape (build-ribbon 10))\n")) ("build-text" ("text-string" "primitiveid-number" "Builds a sequence of planes, texture mapped so that a font texture can be used to display text. Might also be useful for more abstract things. The font assumed to be non proportional - there is an example font shipped with fluxus Ok, so this isn't a very good font texture :)" " (texture (load-texture \"font.png\"))\n (define mynewshape (build-text \"hello\"))\n")) ("build-type" ("ttf-filename text-string" "primitiveid-number" "Builds a geometric type primitive from a ttf font and some text." " (clear)\n (wire-colour (vector 0 0 1))\n ; this font should be on the default fluxus path (as it's the editor font)\n (define t (build-type \"Bitstream-Vera-Sans-Mono.ttf\" \"fluxus rocks!!\"))\n\n ; make a poly primitive from the type\n (define p (with-state\n     (translate (vector 0 4 0))\n     (type->poly t)))\n\n ; set some texture coords on the poly prim and load a texture onto it\n (with-primitive p\n     (pdata-map!\n         (lambda (t p)\n             (vmul p 0.5))\n         \"t\" \"p\")\n     (texture (load-texture \"refmap.png\")))\n")) ("build-extruded-type" ("ttf-filename text-string extrude-depth" "primitiveid-number" "Builds an extruded geometric type primitive from a ttf font and some text." " (clear)\n (wire-colour (vector 0 0 1))\n ; this font should be on the default fluxus path (as it's the editor font)\n (define t (build-extruded-type \"Bitstream-Vera-Sans-Mono.ttf\" \"fluxus rocks!!\" 1))\n\n ; make a poly primitive from the type\n (define p (with-state\n     (translate (vector 0 4 0))\n     (type->poly t)))\n\n ; set some texture coords on the poly prim and load a texture onto it\n (with-primitive p\n     (pdata-map!\n         (lambda (t p)\n             (vmul p 0.5))\n         \"t\" \"p\")\n     (texture (load-texture \"refmap.png\")))\n")) ("type->poly" ("typeprimitiveid-number" "polyprimid-number" "Converts the mesh of a type primitive into a triangle list polygon primitive. The poly primitive will be a bit slower to render, but you'll be able to do everything you can do with a poly primitive with it, such as add textures and deform it." " (clear)\n (wire-colour (vector 0 0 1))\n ; this font should be on the default fluxus path (as it's the editor font)\n (define t (build-extruded-type \"Bitstream-Vera-Sans-Mono.ttf\" \"fluxus rocks!!\" 1))\n\n ; make a poly primitive from the type\n (define p (with-state\n     (translate (vector 0 4 0))\n     (type->poly t)))\n\n ; set some texture coords on the poly prim and load a texture onto it\n (with-primitive p\n     (pdata-map!\n         (lambda (t p)\n             (vmul p 0.5))\n         \"t\" \"p\")\n     (texture (load-texture \"refmap.png\")))\n")) ("text-params" ("width-number height-number stride-number wrap-number" "primitiveid-number" "Sets parameters for making fonts from texture maps. Defaults: 16/256 16/256 16 0" " ; don't use me!\n")) ("build-nurbs-sphere" ("hsegments rsegments" "primitiveid-number" "Builds a tesselated nurbs sphere, texture mapped in the same fashion as the poly sphere." " (define mynewshape (build-nurbs-sphere 10 10))\n")) ("build-nurbs-plane" ("hsegments rsegments" "primitiveid-number" "Builds a tesselated nurbs plane, texture mapped in uv direction." " (define mynewshape (build-nurbs-plane 10 10))\n")) ("build-particles" ("count-number" "primitiveid-number" "Builds a particles primitive containing num points, all initially set to the origin. You use the pdata functions to edit the postions, colours and sizes. Particles come in two flavors, camera facing sprites, which are the default, can be textured and individually scaled; and points (when hint-points is set), which cannot be textured but are much faster to render, as they are hardware supported gl points. By default these point particles are square, turn on hint-anti-alias to make them circular." " (define mynewshape (build-particles 100))\n")) ("build-image" ("texture-number coordinate-vector size-vector" "primitiveid-number" "Builds an image, which is displayed on screen using 2D orthographic projection. Coordinate defines the location of the image from the upper-left corner. Size specifies the image display resolution in pixels." " (define img (build-image (load-texture \"test.png\") (vector 0 0) (get-screen-size)))\n")) ("build-voxels" ("width-number height-number depth-number" "primitiveid-number" "Builds voxels primitive, similar to pixel primitives, except include a 3rd dimension." " (define vox (build-voxels 10 10 10))\n")) ("blobby->poly" ("blobbyprimitiveid-number" "polyprimid-number" "Converts the voxels from a voxels primitive to those of a blobby primitive, this is only really of use for then converting the voxels to a polygon primitive. The blobby is just the intermediate step." " \n")) ("voxels-width" ("" "width-number" "Returns the width of the current voxels primitive." " (define mynewshape (build-voxels 10 10 10))\n (with-primitive mynewshape\n     (display (vector (voxels-width) (voxels-height) (voxels-depth)))(newline))\n")) ("voxels-height" ("" "height-number" "Returns the height of the current voxels primitive." " (define mynewshape (build-voxels 10 10 10))\n (with-primitive mynewshape\n     (display (vector (voxels-width) (voxels-height) (voxels-depth)))(newline))\n")) ("voxels-depth" ("" "depth-number" "Returns the depth of the current voxels primitive." " (define mynewshape (build-voxels 10 10 10))\n (with-primitive mynewshape\n     (display (vector (voxels-width) (voxels-height) (voxels-depth)))(newline))\n")) ("voxels-calc-gradient" ("" "void" "Fills out the \"g\" pdata array with the gradient of the voxel intensities. This is the first derivative, the change in intensity in x,y and z directions across the voxels. This can be used to approximate normals, is mainly of use for lighting the voxels." " (clear)\n (blend-mode 'src-alpha 'one)\n (hint-nozwrite)\n (texture (load-texture \"splat.png\"))\n (define p (build-voxels 30 30 30))\n (define t 0)\n\n (every-frame (with-primitive p \n     (set! t (+ t 0.02))\n     (for ((i (in-range 0 10)))\n         (voxels-sphere-solid (vector (+ 0.5 (* 0.5 (sin (+ (* i 0.1) t)))) 0.5 0.5) \n             (if (odd? i) (vector 0 0 0) (vmul (vector 1 0.1 0.1) (* i 0.05)))\n             (- 1 (/ i 10))))\n\n     (voxels-box-solid (vector 0.5 0.5 -0.1) (vector 1.1 1.1 1.1) (vector 0 0 0))\n     (voxels-calc-gradient)\n     (voxels-point-light (vector 0 50 0) (vmul (vector 1 1 1) 0.05))))\n")) ("voxels-sphere-influence" ("pos-vector colour-vector strength" "void" "Adds a coloured sperical influence into the voxel values from the centre position." " (clear)\n (blend-mode 'src-alpha 'one)\n (hint-nozwrite)\n (texture (load-texture \"splat.png\"))\n (define p (build-voxels 30 30 30))\n (define t 0)\n\n (every-frame (with-primitive p \n     (set! t (+ t 0.02))\n     (for ((i (in-range 0 10)))\n         (voxels-sphere-solid (vector (+ 0.5 (* 0.5 (sin (+ (* i 0.1) t)))) 0.5 0.5) \n             (if (odd? i) (vector 0 0 0) (vmul (vector 1 0.1 0.1) (* i 0.05)))\n             (- 1 (/ i 10))))\n\n     (voxels-box-solid (vector 0.5 0.5 -0.1) (vector 1.1 1.1 1.1) (vector 0 0 0))\n     (voxels-calc-gradient)\n     (voxels-point-light (vector 0 50 0) (vmul (vector 1 1 1) 0.05))))\n")) ("voxels-sphere-solid" ("pos-vector colour-vector radius" "void" "Sets a solid sphere of coloured voxel values." " (clear)\n (blend-mode 'src-alpha 'one)\n (hint-nozwrite)\n (texture (load-texture \"splat.png\"))\n (define p (build-voxels 30 30 30))\n (define t 0)\n\n (every-frame (with-primitive p \n     (set! t (+ t 0.02))\n     (for ((i (in-range 0 10)))\n         (voxels-sphere-solid (vector (+ 0.5 (* 0.5 (sin (+ (* i 0.1) t)))) 0.5 0.5) \n             (if (odd? i) (vector 0 0 0) (vmul (vector 1 0.1 0.1) (* i 0.05)))\n             (- 1 (/ i 10))))\n\n     (voxels-box-solid (vector 0.5 0.5 -0.1) (vector 1.1 1.1 1.1) (vector 0 0 0))\n     (voxels-calc-gradient)\n     (voxels-point-light (vector 0 50 0) (vmul (vector 1 1 1) 0.05))))\n")) ("voxels-sphere-cube" ("topleft-vector botright-vector colour" "void" "Sets a solid cube of coloured voxel values." " (clear)\n (blend-mode 'src-alpha 'one)\n (hint-nozwrite)\n (texture (load-texture \"splat.png\"))\n (define p (build-voxels 30 30 30))\n (define t 0)\n\n (every-frame (with-primitive p \n     (set! t (+ t 0.02))\n     (for ((i (in-range 0 10)))\n         (voxels-sphere-solid (vector (+ 0.5 (* 0.5 (sin (+ (* i 0.1) t)))) 0.5 0.5) \n             (if (odd? i) (vector 0 0 0) (vmul (vector 1 0.1 0.1) (* i 0.05)))\n             (- 1 (/ i 10))))\n\n     (voxels-box-solid (vector 0.5 0.5 -0.1) (vector 1.1 1.1 1.1) (vector 0 0 0))\n     (voxels-calc-gradient)\n     (voxels-point-light (vector 0 50 0) (vmul (vector 1 1 1) 0.05))))\n")) ("voxels-threshold" ("thresh-number" "void" "Thresholds the voxels and colours those above the threshold white and those below the threshold black." " (clear)\n (blend-mode 'src-alpha 'one)\n (hint-nozwrite)\n (texture (load-texture \"splat.png\"))\n (define p (build-voxels 30 30 30))\n (define t 0)\n\n (every-frame (with-primitive p \n     (set! t (+ t 0.02))\n     (for ((i (in-range 0 10)))\n         (voxels-sphere-solid (vector (+ 0.5 (* 0.5 (sin (+ (* i 0.1) t)))) 0.5 0.5) \n             (if (odd? i) (vector 0 0 0) (vmul (vector 1 0.1 0.1) (* i 0.05)))\n             (- 1 (/ i 10))))\n\n     (voxels-box-solid (vector 0.5 0.5 -0.1) (vector 1.1 1.1 1.1) (vector 0 0 0))\n     (voxels-calc-gradient)\n     (voxels-point-light (vector 0 50 0) (vmul (vector 1 1 1) 0.05))))\n")) ("voxels-point-light" ("pos-vector colour-vector" "void" "Uses the gradient pdata array to light the voxels from a point light source" " (clear)\n (blend-mode 'src-alpha 'one)\n (hint-nozwrite)\n (texture (load-texture \"splat.png\"))\n (define p (build-voxels 30 30 30))\n (define t 0)\n\n (every-frame (with-primitive p \n     (set! t (+ t 0.02))\n     (for ((i (in-range 0 10)))\n         (voxels-sphere-solid (vector (+ 0.5 (* 0.5 (sin (+ (* i 0.1) t)))) 0.5 0.5) \n             (if (odd? i) (vector 0 0 0) (vmul (vector 1 0.1 0.1) (* i 0.05)))\n             (- 1 (/ i 10))))\n\n     (voxels-box-solid (vector 0.5 0.5 -0.1) (vector 1.1 1.1 1.1) (vector 0 0 0))\n     (voxels-calc-gradient)\n     (voxels-point-light (vector 0 50 0) (vmul (vector 1 1 1) 0.05))))\n")) ("build-locator" ("" "primitiveid-number" "A locator is an empty primitive, useful for parenting to (when you don't want to have the parent object visible). This primitive can only be visualised with (hint-origin) to display it's local transform origin." " (define mynewshape (build-locator))\n")) ("locator-bounding-radius" ("locator-bounding-radius size-number" "void" "Sets the bounding box radius for the locator" " (define mylocator (build-locator))\n (with-primitive mylocator\n     (locator-bounding-radius 23.4))\n")) ("load-primitive" ("" "primitiveid-number" "Loads a primitive from disk" " (define mynewshape (load-primitive \"octopus.obj\"))\n")) ("clear-geometry-cache" ("" "void" "Clears cached geometry, so subsequent loads with come from the disk." " (clear-geometry-cache)\n")) ("save-primitive" ("" "void" "Saves the current primitive to disk" " (with-primitive (build-sphere 10 10)\n     (save-primitive \"mymesh.obj\"))\n")) ("build-pixels" ("width-number height-number renderer-active-boolean" "primitiveid-number" "Makes a new pixel primitive. A pixel primitive is used for making procedural textures, which can then be applied to other primitives. For this reason, pixel primitives probably wont be rendered much, but you can render them to preview the texture on a flat plane. Objects can be rendered into pixels primitives. The pixels primitive renderer is disabled by default. To enable it, use the renderer-activate optional boolean parameter." " (clear)\n (define p1 (build-pixels 16 16))\n (with-primitive p1\n    (pdata-map!\n        (lambda (c)\n            (rndvec))\n        \"c\")\n    (pixels-upload)) ; call pixels upload to see the results\n\n (translate (vector 1.5 0 0))\n (define p2 (build-pixels 256 256 #t)) ; render target\n (with-pixels-renderer p2 ; render a cube into the pixels primitive\n    (clear-colour (vector .37 .5 .59))\n    (scale 5)\n    (rotate (vector -5 60 140))\n    (build-cube))\n")) ("pixels-upload" ("" "void" "Uploads the texture data, you need to call this when you've finished writing to the pixelprim, and while it's grabbed." " (define mynewshape (build-pixels 100 100))\n (with-primitive mynewshape\n     (pdata-map!\n         (lambda (c)\n             (rndvec))\n         \"c\")\n     (pixels-upload)) ; call pixels upload to see the results\n")) ("pixels-download" ("" "void" "Downloads the texture data from the GPU to the PData array." " (clear)\n \n (define p (build-pixels 256 256 #t))\n \n (define q (with-pixels-renderer p\n         (clear-colour (vector 1 1 1))\n         (scale 3)\n         (colour (vector 0 0 1))\n         (build-torus 0.2 2 10 20)))\n \n (define i (with-state\n         (translate (vector 0.5 0.5 0))\n         (scale 0.2)\n         (build-cube)))\n \n (every-frame\n     (begin\n     (with-primitive p \n         (pixels-download)\n         ; paint the cube with the colour of the pixel underneath it\n         (let ((c (pdata-ref \"c\" (pixels-index (vector 0.5 0.5 0)))))\n             (with-primitive i (colour c))))\n     (with-pixels-renderer p\n         (with-primitive q\n             (rotate (vector 1 0.2 0))))))\n")) ("pixels->texture" ("pixelprimitiveid-number" "textureid-number" "Returns a texture you can use exactly like a normal loaded one." " (define mypixels (build-pixels 100 100))\n (with-primitive mypixels\n     (pdata-map!\n         (lambda (c)\n             (rndvec))\n         \"c\")\n     (pixels-upload))\n\n (with-state\n     (texture (pixels->texture mypixels))\n     (build-torus 1 2 10 10))\n")) ("pixels-width" ("" "width-number" "Returns the width of the current pixel primitive." " (define mynewshape (build-pixels 100 100))\n (with-primitive mynewshape\n     (display (vector (pixels-width) (pixels-height)))(newline))\n")) ("pixels-height" ("" "width-number" "Returns the height of the current pixel primitive." " (define mynewshape (build-pixels 100 100))\n (with-primitive mynewshape\n     (display (vector (pixels-width) (pixels-height)))(newline))\n")) ("pixels-renderer-activate" ("boolean" "void" "Activates/deactivates the pixel primitive renderer." " (clear)\n (define p (build-pixels 256 256))\n\n (with-primitive p\n     (pixels-renderer-activate #t))\n\n (define cube (with-pixels-renderer p\n                    (clear-colour (vector .2 .4 .8))\n                    (rotate #(30 50 80))\n                    (scale 5)\n                    (build-cube)))\n")) ("build-blobby" ("numinfluences subdivisionsvec boundingvec" "primitiveid-number" "Blobby primitives are a higher level implicit surface representation in fluxus which is defined using influences in 3 dimesional space. These infuences are then summed together, and a particular value is \"meshed\" (using the marching cubes algorithm) to form a smooth surface. The influences can be animated, and the smooth surface moves and deforms to adapt, giving the primitive it's blobby name. build-blobby returns a new blobby primitive. Numinfluences is the number of \"blobs\". Subdivisions allows you to control the resolution of the surface in each dimension, while boundingvec sets the bounding area of the primitive in local object space. The mesh will not be calculated outside of this area. Influence positions and colours need to be set using pdata-set." " (clear)\n (define b (build-blobby 5 (vector 30 30 30) (vector 1 1 1)))\n \n (with-primitive b\n     (shinyness 100)\n     (specular (vector 1 1 1))\n     (hint-vertcols)\n     (pdata-set \"p\" 0 (vector 0.75 0.25 0.5))\n     (pdata-set \"c\" 0 (vector 0.01 0 0))\n     (pdata-set \"s\" 0 0.01)\n     (pdata-set \"p\" 1 (vector 0.25 0.75 0.5))\n     (pdata-set \"c\" 1 (vector 0 0.01 0))\n     (pdata-set \"s\" 1 0.01)\n     (pdata-set \"p\" 2 (vector 0.75 0.75 0.5))\n     (pdata-set \"c\" 2 (vector 0 0 0.01))\n     (pdata-set \"s\" 2 0.01)\n     (pdata-set \"p\" 3 (vector 0.25 0.25 0.5))\n     (pdata-set \"c\" 3 (vector 0.01 0.01 0))\n     (pdata-set \"s\" 3 0.01)\n     (pdata-set \"p\" 4 (vector 0.5 0.5 0.5))\n     (pdata-set \"c\" 4 (vector 0.01 0.01 0.01))\n     (pdata-set \"s\" 4 0.025))\n")) ("blobby->poly" ("blobbyprimitiveid-number" "polyprimid-number" "Converts the mesh of a blobby primitive into a triangle list polygon primitive. This is useful as the polygon primitive will be much much faster to render, but can't deform in the blobby way. Doesn't convert vertex colours over yet unfortunately." " (clear)\n (define b (build-blobby 5 (vector 30 30 30) (vector 1 1 1)))\n \n (with-primitive b\n     (shinyness 100)\n     (specular (vector 1 1 1))\n     (hint-vertcols)\n     (pdata-set \"p\" 0 (vector 0.75 0.25 0.5))\n     (pdata-set \"c\" 0 (vector 0.01 0 0))\n     (pdata-set \"s\" 0 0.01)\n     (pdata-set \"p\" 1 (vector 0.25 0.75 0.5))\n     (pdata-set \"c\" 1 (vector 0 0.01 0))\n     (pdata-set \"s\" 1 0.01)\n     (pdata-set \"p\" 2 (vector 0.75 0.75 0.5))\n     (pdata-set \"c\" 2 (vector 0 0 0.01))\n     (pdata-set \"s\" 2 0.01)\n     (pdata-set \"p\" 3 (vector 0.25 0.25 0.5))\n     (pdata-set \"c\" 3 (vector 0.01 0.01 0))\n     (pdata-set \"s\" 3 0.01)\n     (pdata-set \"p\" 4 (vector 0.5 0.5 0.5))\n     (pdata-set \"c\" 4 (vector 0.01 0.01 0.01))\n     (pdata-set \"s\" 4 0.025))\n \n (define p (with-state\n     (translate (vector 1 0 0))\n     (blobby->poly b)))\n")) ("draw-instance" ("primitiveid-number" "void" "Copies a retained mode primitive and draws it in the current state as an immediate mode primitive." " (define mynewshape (build-cube))\n (colour (vector 1 0 0))\n (draw-instance mynewshape) ; draws a copy of mynewshape\n")) ("draw-cube" ("" "void" "Draws a cube in the current state in immediate mode primitive." " (define (render)\n     (draw-cube))\n (every-frame (render))\n")) ("draw-plane" ("" "void" "Draws a plane in the current state in immediate mode primitive." " (define (render)\n     (draw-plane))\n (every-frame (render))\n")) ("draw-sphere" ("" "void" "Draws a sphere in the current state in immediate mode primitive." " (define (render)\n     (draw-sphere))\n (every-frame (render))\n")) ("draw-cylinder" ("" "void" "Draws a cylinder in the current state in immediate mode primitive." " (define (render)\n     (draw-cylinder))\n (every-frame (render))\n")) ("draw-torus" ("" "void" "Draws a torus in the current state in immediate mode primitive." " (define (render)\n     (draw-torus))\n (every-frame (render))\n")) ("destroy" ("primitiveid-number" "void" "Deletes a built primitive from the renderer. primitive." " (define mynewshape (build-sphere 10 10))\n (destroy mynewshape)\n")) ("poly-indices" ("" "void" "Gets the vertex indices from this primitive." " (define p (build-cube))\n\n (with-primitive p\n     (poly-convert-to-indexed)\n     (display (poly-indices))(newline))\n")) ("poly-type-enum" ("" "void" "Returns the enum value representing the type of the current polygon primitive. This is needed as I can't get my scheme scripts to recognise symbols returned from here. Use (poly-type) instead of this directly. primitive." " (define (poly-type)\t\n   (let ((t (poly-type-enum)))\n     (cond\n       ((eq? t 0) 'triangle-strip)\n       ((eq? t 1) 'quad-list)\n       ((eq? t 2) 'triangle-list)\n       ((eq? t 3) 'triangle-fan)\n       ((eq? t 4) 'polygon))))\n")) ("poly-indexed?" ("" "void" "Returns true if the current polygon primitive is in indexed mode. primitive." " (define p (build-polygons 3 'triangle-strip))\n (with-primitive p\n     (poly-convert-to-indexed)\n     (display (poly-indexed?))(newline))\n")) ("poly-set-index" ("index-list" "void" "Switches the primitive to indexed mode, and uses the list as the index values for this primitive. primitive." " (clear)\n ; lets build our own cube primitive...\n (define p (build-polygons 8 'quad-list))\n \n (with-primitive p\n     ; setup the vertex data\n     (pdata-set \"p\" 0 (vector -1 -1 -1))\n     (pdata-set \"p\" 1 (vector  1 -1 -1))\n     (pdata-set \"p\" 2 (vector  1 -1  1))\n     (pdata-set \"p\" 3 (vector -1 -1  1))\n     (pdata-set \"p\" 4 (vector -1  1 -1))\n     (pdata-set \"p\" 5 (vector  1  1 -1))\n     (pdata-set \"p\" 6 (vector  1  1  1))\n     (pdata-set \"p\" 7 (vector -1  1  1))\n     (pdata-set \"c\" 0 (vector  0  0  0))\n     (pdata-set \"c\" 1 (vector  0  0  1))\n     (pdata-set \"c\" 2 (vector  0  1  0))\n     (pdata-set \"c\" 3 (vector  0  1  1))\n     (pdata-set \"c\" 4 (vector  1  0  0))\n     (pdata-set \"c\" 5 (vector  1  0  1))\n     (pdata-set \"c\" 6 (vector  1  1  0))\n     (pdata-set \"c\" 7 (vector  1  1  1))\n     \n     (hint-wire)\n     (hint-unlit)\n     (hint-vertcols)\n     \n     ; connect the verts together into faces\n     (poly-set-index (list 7 6 5 4  5 6 2 1 \n             4 5 1 0  1 2 3 0\n             3 7 4 0  6 7 3 2)))\n")) ("poly-convert-to-indexed" ("" "void" "Converts the currently grabbed polygon primitive from raw vertex arrays to indexed arrays. This removes duplicate vertices from the polygon, making the pdata arrays shorter, which speeds up processing time." " (define mynewshape (build-sphere 10 10))\n (grab mynewshape)\n (poly-convert-to-indexed)\n (ungrab)\n")) ("build-copy" ("src-primitive-number" "primitiveid-number" "Returns a copy of a primitive" " (define mynewshape (build-sphere 10 10))\n (define myothernewshape (build-copy mynewshape))\n")) ("make-pfunc" ("name-string" "pfuncid-number" "Makes a new primitive function. pfuncs range from general purpose to complex and specialised operations which you can run on primitives. All pfuncs share the same interface for controlling and setting them up - pfunc-set! All pfunc types and arguments are as follows: arithmetic For applying general arithmetic to any pdata array operator string : one of add sub mul div src string : pdata array name other string : pdata array name (optional) constant float : constant value (optional) dst string : pdata array name genskinweights Generates skinweights - adds float pdata called \"s1\" -> \"sn\" where n is the number of nodes in the skeleton - 1 skeleton-root primid-number : the root of the bindpose skeleton for skinning sharpness float : a control of how sharp the creasing will be when skinned skinweights->vertcols A utility for visualising skinweights for debugging. no arguments skinning Skins a primitive - deforms it to follow a skeleton's movements. Primitives we want to run this on have to contain extra pdata - copies of the starting vert positions called \"pref\" and the same for normals, if normals are being skinned, called \"nref\". skeleton-root primid-number : the root primitive of the animating skeleton bindpose-root primid-number : the root primitive of the bindpose skeleton skin-normals number : whether to skin the normals as well as the positions" " (define mypfunc (make-pfunc 'arithmetic))\n")) ("pfunc-set!" ("pfuncid-number argument-list" "void" "Sets arguments on a primitive function. See docs for make-pfunc for all the arguments." " (define mypfunc (make-pfunc 'arithmetic))\n (pfunc-set! mypfunc (list 'operator \"add\"\n                           'src \"p\"\n                           'const 0.4\n                           'dst \"p\"))\n")) ("pfunc-run" ("id-number" "void" "Runs a primitive function on the currently grabbed primitive." " (define mypfunc (make-pfunc 'arithmetic))\n")) ("geo/line-intersect" ("start-vec end-vec" "void" "Returns a list of pdata values at each intersection point of the specified line. The line is in primitive local space, to check with a point in global space, you need to transform the point with the inverse of the primitive transform." " (clear)\n (define s (with-state\n         (build-torus 1 2 10 10)))\n \n (define l (with-state\n         (hint-none)\n         (hint-unlit)\n         (hint-wire)\n         (build-line 2)))\n \n (define (check a b)\n     (with-primitive s\n         (for-each\n             (lambda (intersection)                    \n                 (with-state ; draw a sphere at the intersection point\n                     (translate (cdr (assoc \"p\" intersection)))\n                     (colour (vector 0 1 0))\n                     (scale (vector 0.3 0.3 0.3))\n                     (draw-sphere)))\n         (geo/line-intersect a b))))\n \n (every-frame\n     (with-primitive l\n         (pdata-set \"p\" 0 (vector 0 -5 0))\n         (pdata-set \"p\" 1 (vector (* 5 (sin (time))) 5 0))\n         (check (pdata-ref \"p\" 0) (pdata-ref \"p\" 1))))\n")) ("recalc-bb" ("" "void" "This call regenerates the primitives bounding box. As this call can be expensive, it's up to you when to call it - only if the pdata has changed and just before operations that use the bounding box (such as bb/bb-intersect) is the fastest policy." " (define myprim (build-cube))\n (with-primitive myprim\n   (hint-box)\n   (pdata-set! \"p\" 0 (vector -10 0 0))\n   (recalc-bb))\n")) ("bb/bb-intersect?" ("prim thresh" "void" "Returns #t if the current primitive bounding box intersects with the supplied one, with an additional expanding threshold." " (clear)\n \n (define a (with-state\n      (build-sphere 10 10)))\n \n (define b (with-state\n      (translate (vector 2 0 0))\n      (build-sphere 10 10)))\n \n (every-frame\n     (begin\n         (with-primitive b\n             (translate (vector (* -0.1 (sin (time))) 0 0)))\n         (with-primitive a\n             (when (bb/bb-intersect? b 0)\n                 (colour (rndvec))))))\n")) ("bb/point-intersect?" ("point thresh" "void" "Returns #t if the current primitive bounding box intersects with point supplied, with an additional expanding threshold (so you can do check intersections with spheres). The point is in world space. You need to call (recalc-bb) before using this function, if the primitive has been moved or had it's pdata changed." " (clear)\n \n (define a (with-state\n      (build-sphere 10 10)))\n \n (define b (with-state\n      (translate (vector 2 0 0))\n      (build-sphere 10 10)))\n \n (every-frame\n     (begin\n         (with-primitive b\n             (translate (vector (* -0.1 (sin (time))) 0 0))\n\t\t\t   (recalc-bb))\n         (with-primitive a\n             ; check the centre point and give the radius, this sphere\n             ; check is faster than a bb/bb one\n             (when (bb/point-intersect? (vtransform (vector 0 0 0)\n                     (with-primitive b (get-transform))) 1)\n                 (colour (rndvec))))))\n")) ("get-children" ("" "void" "Gets a list of primitives parented to this one." " ; build a random heirachical structure\n (define (build-heir depth)\n     (with-state\n         (let ((p (with-state\n                         (translate (vector 2 0 0))\n                         (scale 0.9)\n                         (build-cube))))\n             (when (> depth 0)\n                 (parent p)            \n                 (for ((i (in-range 0 5)))\n                     (when (zero? (random 3))\n                         (rotate (vector 0 0 (* 45 (crndf))))\n                         (build-heir (- depth 1))))))))\n \n ; navigate the scene graph and print it out\n (define (print-heir children)\n     (for-each\n         (lambda (child)\n             (with-primitive child\n                 (printf \"id: ~a parent: ~a children: ~a~n\" child (get-parent) (get-children))\n                 (print-heir (get-children))))\n         children))\n \n (clear)\n (build-heir 5)\n (print-heir (get-children))\n")) ("get-parent" ("" "void" "Gets the parent of this node. 1 is the root node." " ; build a random heirachical structure\n (define (build-heir depth)\n     (with-state\n         (let ((p (with-state\n                         (translate (vector 2 0 0))\n                         (scale 0.9)\n                         (build-cube))))\n             (when (> depth 0)\n                 (parent p)            \n                 (for ((i (in-range 0 5)))\n                     (when (zero? (random 3))\n                         (rotate (vector 0 0 (* 45 (crndf))))\n                         (build-heir (- depth 1))))))))\n \n ; navigate the scene graph and print it out\n (define (print-heir children)\n     (for-each\n         (lambda (child)\n             (with-primitive child\n                 (printf \"id: ~a parent: ~a children: ~a~n\" child (get-parent) (get-children))\n                 (print-heir (get-children))))\n         children))\n \n (clear)\n (build-heir 5)\n (print-heir (get-children))\n")) ("get-bb" ("" "bounding-box" "Gets the bounding box this primitive in object space. A bounding box is returned as a list of two vectors, the minimum (closest to the origin) and maximum (furthest) corner." " (with-primitive (build-sphere 10 10)\n     (scale (vector 3 1 0.3))\n     (rotate (vector 30 25 45))\n     (apply-transform)\n     (display (get-bb))(newline))\n"))))) ("util-functions" ("Handy functions to make your life easier..." "" (("time" ("" "time-number" "Returns the number of seconds (+ fraction) since midnight January 1st 1970. This is the simpest animation source for your scripts." " (define (animate)\n     (rotate (vector (sin (time)) 0 0))\n     (draw-cube))\n (every-frame (animate))    \n")) ("delta" ("" "time-number" "Time in seconds since the last frame. Used to make animation frame rate independant." " (define (animate)\n     (rotate (vector (* (delta) 10) 0 0))\n     (draw-cube))\n (every-frame (animate))    \n")) ("flxrnd" ("" "random-number" "Returns a random number between 0 and 1." " (define (animate)\n     (colour (vector (flxrnd) (flxrnd) (flxrnd)))\n     (draw-cube))\n (every-frame (animate))\n")) ("flxseed" ("seed-number" "void" "Seeds the random number generator so we can get the same sequence." " (define (animate)\n     (colour (vector (flxrnd) (flxrnd) (flxrnd)))\n     (draw-cube))\n (flxseed 10) \n (every-frame (animate)) ; the same sequence of colours will be generated\n")) ("set-searchpathss" ("paths-list" "void" "Sets a list of search path strings to use for looking for fluxus related files, such as textures, shaders etc. Paths will be searched in order each time, and need trailing slashes." " (set-searchpaths (append (get-searchpaths) (list \"/path/to/my/textures/\" \"/path/to/my/other/textures/\")))\n")) ("get-searchpaths" ("paths-list" "void" "Gets the list of search path strings to use for looking for fluxus related files, such as textures, shaders etc. Paths will be searched in order each time." " (display (get-searchpaths))(newline)\n")) ("fullpath" ("filename-string" "fullpath-string" "Searches the search paths for the specified file and returns the first location it finds." " (fullpath \"myfile\")\n")) ("framedump" ("filename" "void" "Saves out the current OpenGL front buffer to disk. Reads the filename extension to decide on the format used for saving, \"tif\", \"jpg\" or \"ppm\" are supported. This is the low level form of the frame dumping, use start-framedump and end-framedump instead." " (framedump \"picture.jpg\")\n")) ("tiled-framedump" ("filename" "void" "For rendering images that are bigger than the screen, for printing or other similar stuff. This command uses a tiled rendering method to render bits of the image and splice them together into the image to save. Reads the filename extension to decide on the format used for saving, \"tif\", \"jpg\" or \"ppm\" are supported." " (tiled-framedump \"picture.jpg\" 3000 2000)\n"))))) ("openal" ("OpenAL is a cross platform audio library designed for use in conjunction with 3D applications." "" (("oa-start" ("" "void" "Starts up the openal audio system" " (oa-start)\n (define mysample (oa-load-sample (fullpath \"sample.wav\")))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n")) ("oa-load-sample" ("" "sampleid-number" "Loads a sample and returns the id number, so it can be played." " (oa-start)\n (define mysample (oa-load-sample \"sample.wav\"))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n")) ("oa-update" ("" "void" "Keeps the openal code running, is called by the every-frame code." " (oa-update)\n")) ("oa-play" ("sample-id position pitch gain" "void" "Plays a sample." " (oa-start)\n (define mysample (oa-load-sample (fullpath \"sample.wav\")))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n")) ("oa-set-head-pos" ("pos dir" "void" "Sets the head position, or listener position - which changes the panning and perhaps filtering of the sounds to relate to world space position." " (oa-start)\n (define mysample (oa-load-sample (fullpath \"sample.wav\")))\n (oa-set-head-pos (vector -1 0 0) (vector 0 0 1))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n")) ("oa-set-poly" ("polyphony-count" "void" "Sets the number of samples that can be played at once. Defaults to 256." " (oa-set-poly 256)\n")) ("oa-set-cull-dist" ("distance" "void" "Sets distance at which sounds will be stopped playing" " (oa-set-cull-dist 1000)\n")) ("oa-set-acoustics" ("attenuation-scale max-distance ref-distance rolloff" "void" "Sets some global acoustic parameters" " (oa-set-acoustics 1 1 1 1)\n"))))) ("scheme-utils" ("High level fluxus commands written in Scheme." "" (("detach-parent" ("" "void" "Removes the parent for the current primitive, and fixes up the transform so the primitive doesn't move. Use (parent 1) to avoid this fix up." " ; builds and animates a random heirarchical structure,\n ; click on the objects to detach them from their parents\n (define (build-heir depth)\n     (with-state\n         (let ((p (with-state\n                         (translate (vector 2 0 0))\n                         (scale 0.9)\n                         (build-cube))))\n             (when (> depth 0)\n                 (parent p)\n                 (for ((i (in-range 0 5)))\n                     (when (zero? (random 3))\n                         (rotate (vector 0 0 (* 45 (crndf))))\n                         (build-heir (- depth 1))))))))\n\n (define (animate-heir children depth)\n     (for-each\n         (lambda (child)\n             (with-primitive child\n                 (rotate (vector 0 0 (sin (+ depth (time)))))\n                 (animate-heir (get-children) (+ depth 1))))\n         children))\n\n (define (animate)\n     (animate-heir (get-children) 0)\n     (when (mouse-button 1)\n         (let ((s (select (mouse-x) (mouse-y) 2)))\n             (when (not (zero? s))\n                 (with-primitive s\n                     (detach-parent))))))\n\n (clear)\n (build-heir 5)\n (every-frame (animate))\n")) ("with-state" ("expression ..." "result of last expression" "Encapsulates local state changes, and removes the need for push and pop." " ; state hierachy, by nesting with-state:\n (with-state\n    (hint-vertcols)\n    (colour (vector 0 0 1))\n    (with-state\n        (translate (vector 1 0 0))\n        (build-sphere 10 10))\n     (build-torus 1 2 30 30))\n\n ; making primitives:\n (define my-torus (with-state\n    (hint-vertcols)\n    (colour (vector 0 0 1))\n    (build-torus 1 2 30 30)))\n")) ("with-primitive" ("primitive expression ..." "result of last expression" "Encapsulates primitive state changes, and removes the need for grab and ungrab." " (define my-torus (with-state\n    (colour (vector 0 0 1))\n    (build-torus 1 2 30 30)))\n\n ; change the torus colour:\n (with-primitive my-torus\n    (colour (vector 0 1 0)))\n")) ("with-pixels-renderer" ("pixels-primitive expression ..." "result of last expression" "Allows you to render into a pixel primitive." "")) ("with-ffgl" ("ffgl-pluginid expression ..." "result of last expression" "Allows you to work with the specified FFGL plugin." " (clear)\n (define plugin (ffgl-load \"FFGLTile.dylib\" 256 256))\n\n (with-ffgl plugin\n   (for ([i (ffgl-get-info)])\n        (printf \"~a~n\" i)))\n")) ("pdata-map!" ("procedure read/write-pdata-name read-pdata-name ..." "void" "A high level control structure for simplifying passing over pdata arrays for primitive deformation. Should be easier and less error prone than looping manually. Writes to the first pdata array." " (clear)\n (define my-torus (build-torus 1 2 30 30))\n\n (with-primitive my-torus\n   (pdata-map!\n      (lambda (position)\n          (vadd position (vector (flxrnd) 0 0))) ; jitter the vertex in x\n      \"p\")) ; read/write the position pdata array\n\n (with-primitive my-torus\n   (pdata-map!\n      (lambda (position normal)\n          (vadd position normal)) ; add the normal to the position (expand the object)\n      \"p\" \"n\")) ; read/write the position pdata array, read the normals array\n")) ("pdata-index-map!" ("procedure read/write-pdata-name read-pdata-name ..." "void" "A high level control structure for simplifying passing over pdata arrays for primitive deformation. Same as pdata-map! except pdata-index-map! supplies the index of the current pdata element as the first argument to 'procedure'." " (clear)\n (define my-torus (build-torus 1 2 30 30))\n\n (with-primitive my-torus\n   (pdata-index-map!\n      (lambda (index position)\n          (vadd position (vector (gh index) 0 0))) ; jitter the vertex in x\n      \"p\")) ; read/write the position pdata array\n")) ("pdata-fold" ("procedure start-value read-pdata-name ..." "result of folding procedure over pdata array" "A high level control structure for doing calculations on pdata arrays. Runs the procedure over each pdata element accumulating the result. Should be easier and less error prone than looping manually." " (define my-torus (build-torus 1 2 30 30))\n\n ; find the centre of the primitive by averaging\n ; the points position's together\n (let ((centre\n        (with-primitive my-torus\n                        (vdiv (pdata-fold\n                               vadd\n                               (vector 0 0 0)\n                               \"p\") (pdata-size)))))\n\n   (display centre)(newline))\n")) ("pdata-index-fold" ("procedure start-value read-pdata-name ..." "result of folding procedure over pdata array" "Same as pdata-fold except it passes the index of the current pdata element as the first parameter of 'procedure'." " (define my-torus (build-torus 1 2 30 30))\n\n ; can't think of a good example for this yet...\n (let ((something\n        (with-primitive my-torus\n                        (vdiv (pdata-index-fold\n                               (lambda (index position ret)\n                                   (vadd ret (vmul position index)))\n                               (vector 0 0 0)\n                               \"p\") (pdata-size)))))\n\n   (display something)(newline))\n")) ("collada-import" ("filename-string" "void" "Loads a collada scene file and returns a scene description list. Files need to contain triangulated model data - this is usually an option on the export. Note: this is slow for heavy models" " ;(collada-import \"test.dae\")\n")) ("vmix" ("a b t" "void" "Linearly interpolates the two vectors together by t" " \n ; mix red and blue together\n (colour (vmix (vector 1 0 0) (vector 0 0 1) 0.5))\n")) ("vclamp" ("a" "void" "Clamp the vector so the elements are all between 0 and 1" " \n ; make a valid colour from any old vector\n (colour (vclamp (vector 2 400 -123)))\n")) ("vsquash" ("a" "void" "Normalise the vector so all the elements are between 0 and 1 but maintain the same ratio between them." " \n ; make a valid colour from any old vector\n (colour (vsquash (vector 2 400 -123)))\n")) ("get-line-from-xy" ("" "list of 2 vectors (start position, end position)" "Gets a line representing a segment of the projection of the x,y points into 3D space. at depth z from the camera" " \n")) ("world-pos" ("" "vector" "Gets the world position of a point in 3D world space." " \n")) ("mouse-pos" ("" "vector" "Gets the mouse position in 3D world space." " \n")) ("mouse-pos-z" ("" "vector" "Gets the mouse position in 3D world space at depth z." " \n")) ("2dvec->angle" ("x y" "float" "Converts a 2D vector into an angle, with some dodgy Dave maths" " \n")) ("pixels-circle" ("pos radius colour" "void" "Draws a circle into a pixels primitive" " \n (with-primitive (build-pixels 100 100)\n     (pixels-circle (vector 50 50 0) 30 (vector 1 0 0 1))\n     (pixels-upload))\n")) ("pixels-blend-circle" ("pos radius colour" "void" "Draws a blended circle into a pixels primitive" "\n (with-primitive (build-pixels 100 100)\n     (pixels-blend-circle (vector 50 50 0) 30 (vector 1 0 0 1))\n     (pixels-upload))\n")) ("pixels-dodge" ("pos radius strength" "void" "Lightens a circular area of a pixels primitive" "\n (with-primitive (build-pixels 100 100)\n     (pixels-dodge (vector 50 50 0) 30 (vector 1 0 0 1))\n     (pixels-upload))\n")) ("pixels-burn" ("pos radius strength" "void" "Darkens a circular area of a pixels primitive" "\n (with-primitive (build-pixels 100 100)\n     (pixels-burn (vector 50 50 0) 30 (vector 1 0 0 1))\n     (pixels-upload))\n")) ("pixels-clear" ("col" "void" "Sets all of the pixels to the supplied colour" "\n (with-primitive (build-pixels 100 100)\n     (pixels-clear (vector 1 0 0))\n     (pixels-upload))\n")) ("pixels-index" ("position-vector" "index-number" "Returns the pdata index for the given texture coordinate" " \n (with-primitive (build-pixels 10 10)\n     (display (pixels-index (vector 0.5 0.5 0)))(newline))\n")) ("pixels-texcoord" ("index" "position-vector" "Returns the texture coordinate for the given pdata index" " \n (with-primitive (build-pixels 10 10)\n     (display (pixels-texcoord 25))(newline))\n")) ("poly-type" ("" "void" "Returns a symbol representing the type of the current polygon primitive. primitive." " (define p (build-polygons 3 'triangle-strip))\n (with-primitive p\n     (display (poly-type))(newline))\n")) ("pdata-for-each-face" ("proc pdatanames" "list of pdata values" "Calls proc with the indices for each face in a polygon primitive" " \n")) ("pdata-for-each-triangle" ("proc" "list of pdata values" "Calls proc with the pdata for each triangle in a face - assumes all faces are convex." " \n")) ("poly-build-triangulate" ("primitive-id" "primitive-id" "A new poly primitive of type triangle-list representing the supplied poly primitive." " \n (define triangulated-plane (poly-build-triangulate (build-seg-plane 20 20)))\n")) ("pdata-for-each-tri-sample" ("proc samples-per-triangle" "void" "Calls proc with the triangle indices and a random barycentric coord." " \n")) ("build-extrusion" ("profile-list path-list width-list tex-vscale up" "primitive-id" "Returns an indexed polygon primitive made by extruding the profile along path and scaling using values in width. The path and width lists need to be the same size. tex-vscale allows you to scale the texture coordinates along the length of the extrusion. An up vector is needed for aiming the profile along the path." " \n (clear)\n (build-extrusion \n     (build-circle-points 20 0.3)\n     (list\n         (vector 0 0 0)\n         (vector 0 1 2)\n         (vector 0 -1 4)\n         (vector 0 0 6))\n     (list 0 1 1 0) 1 (vector 0 1 0))\n")) ("build-partial-extrusion" ("profile-list path-list tex-vscale" "primitive-id" "Builds a primitive ready to be used with partial-extrusion. Use this is for animating growth along extrusions." " \n (clear)\n \n (define profile (build-circle-points 10 0.3))\n (define path (build-list 20 (lambda (i) (vector (crndf) (crndf) i))))\n (define width (build-list 20 (lambda (_) 1)))\n \n (hint-wire)\n (define p (build-partial-extrusion profile path 1))\n  \n (every-frame \n     (with-primitive p\n         (partial-extrude (* (length path) 0.5 (+ (sin (time)) 1)) \n             profile path width (vector 0 1 0) 0.1))) \n")) ("partial-extrude" ("profile-list t profile-list path-list width-list up grow-value" "primitive-id" "Animates growth along extrusions. t is a value between 0 and the length of the path, and controls how far along the extrusion to calculate. Grow value is a scale to control how much the profile is scaled to change it's width as it grows." " \n (clear)\n \n (define profile (build-circle-points 10 0.3))\n (define path (build-list 20 (lambda (i) (vector (crndf) (crndf) i))))\n (define width (build-list 20 (lambda (_) 1)))\n \n (hint-wire)\n (define p (build-partial-extrusion profile path 100))\n  \n (every-frame \n     (with-primitive p\n         (partial-extrude (* (length path) 0.5 (+ (sin (time)) 1)) \n             profile path width (vector 0 1 0) 0.1))) \n")) ("build-disk" ("num-points" "primitive-id" "Builds a disk shaped poly primitive" " \n (clear)\n (build-disk 10)\n")) ("rndf" ("" "number" "Returns a random number in the range 0->1" " (display (rndf))(newline)\n")) ("crndf" ("" "number" "Returns a random number in the range -1->1 (centred on zero)" " (display (crndf))(newline)\n")) ("rndvec" ("" "vector" "Returns a random 3 element vector with each element in the range 0->1. If you visualise a lot of these as points, they will fill the unit cube (see the example)." " (clear)\n (hint-none)\n (hint-points)\n (point-width 4)\n (define p (build-particles 1000))\n \n (show-axis 1)\n \n (with-primitive p\n     (pdata-map! \n         (lambda (p)\n             (vector 1 1 1))\n         \"c\")\n     (pdata-map! \n         (lambda (p)\n             (rndvec))\n         \"p\"))\n")) ("crndvec" ("" "vector" "Returns a random 3 element vector with each element in the range -1->1. If you visualise a lot of these as points, they will fill a cube centred on the origin (see the example)." " (clear)\n (hint-none)\n (hint-points)\n (point-width 4)\n (define p (build-particles 1000))\n \n (show-axis 1)\n \n (with-primitive p\n     (pdata-map! \n         (lambda (p)\n             (vector 1 1 1))\n         \"c\")\n     (pdata-map! \n         (lambda (p)\n             (crndvec))\n         \"p\"))\n")) ("srndvec" ("" "vector" "Returns a random 3 element vector. If you visualise a lot of these as points, they will fill a sphere centred on the origin (see the example)." " (clear)\n (hint-none)\n (hint-points)\n (point-width 4)\n (define p (build-particles 1000))\n \n (show-axis 1)\n \n (with-primitive p\n     (pdata-map! \n         (lambda (p)\n             (vector 1 1 1))\n         \"c\")\n     (pdata-map! \n         (lambda (p)\n             (srndvec))\n         \"p\"))\n")) ("hsrndvec" ("" "vector" "Returns a random 3 element vector. If you visualise a lot of these as points, they will cover the surface of a sphere centred on the origin (see the example). The name stands for \"hollow sphere\"." " (clear)\n (hint-none)\n (hint-points)\n (point-width 4)\n (define p (build-particles 1000))\n \n (show-axis 1)\n \n (with-primitive p\n     (pdata-map! \n         (lambda (p)\n             (vector 1 1 1))\n         \"c\")\n     (pdata-map! \n         (lambda (p)\n             (hsrndvec))\n         \"p\"))\n")) ("grndf" ("" "number" "Returns a gaussian random number in the range centred on zero, with a variance of 1" " (display (grndf))(newline)\n")) ("grndvec" ("" "vector" "Returns a gaussian random 3 element vector. If you visualise a lot of these as points, you will see a normal distribution centred on the origin. (see the example)." " (clear)\n (hint-none)\n (hint-points)\n (point-width 4)\n (define p (build-particles 1000))\n \n (show-axis 1)\n \n (with-primitive p\n     (pdata-map! \n         (lambda (p)\n             (vector 1 1 1))\n         \"c\")\n     (pdata-map! \n         (lambda (p)\n             (grndvec))\n         \"p\"))\n")) ("rndbary" ("" "vector" "Returns a vector representing a uniformly distributed triangular barycentric coordinate (wip - doesn't seem to be very uniform to me...)" " (rndbary)\n")) ("rndbary" ("normal" "vector" "Returns a vector representing a random point on a hemisphere, defined by normal." " (clear)\n (hint-none)\n (hint-points)\n (point-width 4)\n (define p (build-particles 1000))\n \n (show-axis 1)\n \n (with-primitive p\n     (pdata-map! \n         (lambda (p)\n             (vector 1 1 1))\n         \"c\")\n     (pdata-map! \n         (lambda (p)\n             (rndhemi (vector 0 1 0)))\n         \"p\"))\n")) ("hrndbary" ("normal" "vector" "Returns a vector representing a random point on a hollow hemisphere, defined by normal." " (clear)\n (hint-none)\n (hint-points)\n (point-width 4)\n (define p (build-particles 1000))\n \n (show-axis 1)\n \n (with-primitive p\n     (pdata-map! \n         (lambda (p)\n             (vector 1 1 1))\n         \"c\")\n     (pdata-map! \n         (lambda (p)\n             (hrndhemi (vector 0 1 0)))\n         \"p\"))\n")) ("build-circle-points" ("num-points radius" "primitive-id" "Returns a list of vectors describing a circle. Useful for generating circles for the extrusion generator." " \n (clear)\n (build-extrusion \n     (build-circle-points 20 0.3)\n     (list\n         (vector 0 0 0)\n         (vector 0 1 2)\n         (vector 0 -1 4)\n         (vector 0 0 6))\n     (list 0 1 1 0) 1 (vector 0 1 0))\n")) ("pdata-for-each-tri-sample" ("proc samples-per-triangle" "void" "Calls proc with the triangle indices and a random barycentric coord?" "")) ("expand" ("distance-value" "void" "Expand object along the normals" " (with-primitive (build-cube)\n   (expand 5))\n")) ("occlusion-texture-bake" ("tex prim samples-per-face rays-per-sample ray-length debug" "void" "Bakes ambient occlusion textures. See ambient-occlusion.scm for more info." ""))))) ("frisbee" ("Frisbee is an experimental high level game engine written for FrTime, a functional reactive programming language available as part of PLT Scheme. It's completely separate to the main fluxus commands, and represents a different way of creating games or other behavoural systems." "" (("vec3" ("x y z" "result-vector" "Creates a new vector usable inside frisbee - use this rather than (vector)" " (vec3 1 2 3)\n")) ("vec3-x" ("v" "result-number" "Returns the x component of the frisbee vector" " (vec3-x (vec3 1 2 3))\n")) ("vec3-y" ("v" "result-number" "Returns the y component of the frisbee vector" " (vec3-y (vec3 1 2 3))\n")) ("vec3-z" ("v" "result-number" "Returns the z component of the frisbee vector" " (vec3-z (vec3 1 2 3))\n")) ("vec3-integral" ("v" "result-vector" "Returns the integral of the frisbee vector in respect to time" " (vec3-integral (vec3 0 0.01 0))\n")) ("scene" ("scene-list" "void" "Sets the frisbee scene up. The list can contain primitive structures, or more lists." " (scene (list (cube)))\n"))))) ("planetarium" ("Planetarium rendering code" "" (("dome-set-camera-transform" ("m" "primitive-id" "Get the render target pixels primitive, so you can set the scene up and animate things 'inside' the dome using (with-pixels-renderer)" "")) ("dome-set-camera-transform" ("m" "primitive-id" "Sets the camera matrix of all the dome cameras" "")) ("dome-camera-set-fov" ("angle near far" "primitive-id" "Sets the fov of the dome cameras (not sure this is right actually...)" "")) ("dome-camera-lag" ("amount" "primitive-id" "Locks all the dome cameras to a primitive" "")) ("dome-camera-lag" ("amount" "primitive-id" "Sets the camera lag for all the dome cameras at once" "")) ("dome-build" ("num-cameras fov-angle texture-size init-thunk" "primitive-id" "Builds a inverted sphere texture mapped with another scene. The scene is rendered by multiple cameras which are combined to give a view which can be very wide angle. fov-angle sets this size, texture-size sets the resolution of the render target and init-thunk is run in the internal pixels-renderer and is for setting up your scene. (should replace thunk with a with-dome)" "")) ("dome-setup-main-camera" ("" "primitive-id" "Sets up the view of the dome geometry to fit (currently) the plymouth immersive vision theatre - this should be useful as an example for other locations." ""))))) ("testing-functions" ("A set of higher level control structures for manipulating objects and state in fluxus in a cleaner and safer manner." "" (("self-test" ("do-logging" "void" "Runs all of the function reference scripts in a separate thread so you can watch it in action. Just checks for syntactic errors in the scheme, changes in bound C++ function signatures and crashes. Graphical code is difficult to test for correctness further (that's my excuse). If do-logging is true it outputs a log text file to the current directory for debugging." " (self-test #t)\n")) ("run-scripts" ("path-to-examples seconds-per-script" "void" "Runs all of the example scripts in a separate thread so you can watch it in action." " (run-scripts path-to-scripts seconds-per-script)\n"))))) ("voxels-utils" ("High level fluxus commands written in Scheme." "" (("voxel-index" ("position-vector" "index-number" "Returns the pdata index for the voxel position" " \n (with-primitive (build-voxels 10 10 10)\n     (display (voxels-index (vector 5 5 5)))(newline))\n")) ("voxels-pos" ("index" "position-vector" "Returns the voxel position for the given pdata index" " \n (with-primitive (build-voxels 10 10 10)\n     (display (voxels-pos 200))(newline))\n"))))))) ("pt" (("frisbee" ("Frisbee é uma game engine escrita para FrTime de alto nível, uma linguagem de programação funcionalmente reativa disponível como parte de PLT Scheme. É completamente separada dos comandos principais do fluxus, e representa uma forma diferente de criar jogos e outros sistemas com comportamento." " EndFunctionDoc\n(module frisbee (lib \"frtime-lang-only.ss\" \"frtime\")\n\n(require\n (lib \"kw.ss\")    ; todo:\n (lib \"match.ss\") ; change to new versions\n scheme/class\n frtime/list\n frtime/etc\n frtime/math\n frtime/lang-ext\n (all-except frtime/frp-core undefined?)\n ; import the procedures we want lifted\n (lifted \"fluxus.ss\"\n     vadd2 vsub2 vmul vdiv vtransform vtransform-rot\n         vnormalise vdot vreflect vdist vmag vcross madd2 msub2 mdiv2 mmul2 mident mtranslate\n         mrotate mscale mtranspose minverse maim qaxisangle qmul qnormalise qtomatrix qconjugate\n         set-camera rndvec crndvec srndvec rndf crndf hsrndvec grndf grndvec)\n (prefix flx- \"fluxus.ss\"))\n\n(provide\n (all-defined)\n (all-from (lib \"frtime-lang-only.ss\" \"frtime\")))\n\n; get around the fact we can't lift the maths macros\n(define vadd vadd2)\n(define vsub vsub2)\n(define madd madd2)\n(define msub msub2)\n(define mmul mmul2)\n(define mdiv mdiv2)\n\n; make lifted versions of the vector procedures\n\n StartFunctionDoc-en\n vec3 x y z\n Returns: result-vector\n Description:\n Creates a new vector usable inside frisbee - use this rather than (vector)\n Example: (vec3 1 2 3)\n EndFunctionDoc\n StartFunctionDoc-pt\n vec3 x y z\n Retorna: vetor-resultante\n Descrição:\n Cria um novo vetor usável dentro de frisbee - use isso ao invés de\n (vector).\n Exemplo: (vec3 1 2 3)\n EndFunctionDoc\n(define (vec3 x y z)\n  (lift #f vector x y z))\n\n StartFunctionDoc-en\n vec3-x v\n Returns: result-number\n Description:\n Returns the x component of the frisbee vector\n Example: (vec3-x (vec3 1 2 3))\n EndFunctionDoc\n StartFunctionDoc-pt\n vec3-x v\n Retorna: número-resultado\n Descrição:\n Retorna o componente x do vetor frisbee.\n Exemplo: (vec3-x (vec3 1 2 3))\n EndFunctionDoc\n(define (vec3-x v)\n  (lift #t vector-ref v 0))\n\n StartFunctionDoc-en\n vec3-y v\n Returns: result-number\n Description:\n Returns the y component of the frisbee vector\n Example: (vec3-y (vec3 1 2 3))\n EndFunctionDoc\n StartFunctionDoc-pt\n vec3-y v\n Retorna: número-resultado\n Descrição:\n Retorna o componente y do vetor frisbee.\n Exemplo: (vec3-y (vec3 1 2 3))\n EndFunctionDoc(define (vec3-y v)\n  (lift #t vector-ref v 1))\n\n StartFunctionDoc-en\n vec3-z v\n Returns: result-number\n Description:\n Returns the z component of the frisbee vector\n Example: (vec3-z (vec3 1 2 3))\n EndFunctionDoc\n StartFunctionDoc-pt\n vec3-z v\n Retorna: número-resultado\n Descrição:\n Retorna o componente z do vetor frisbee.\n Exemplo: (vec3-z (vec3 1 2 3))\n EndFunctionDoc\n(define (vec3-z v)\n  (lift #t vector-ref v 2))\n\n StartFunctionDoc-en\n vec3-integral v\n Returns: result-vector\n Description:\n Returns the integral of the frisbee vector in respect to time\n Example: (vec3-integral (vec3 0 0.01 0))\n EndFunctionDoc\n StartFunctionDoc-pt\n vec3-integral v\n Retorna: vetor-resultado\n Descrição:\n Retorna a integral do vetor frisbee em relação ao tempo.\n Exemplo: (vec3-integral (vec3 0 0.01 0))\n EndFunctionDoc\n(define (vec3-integral v)\n  (vec3 (integral (vec3-x v))\n        (integral (vec3-y v))\n        (integral (vec3-z v))))\n\n(define mouse (vector 0 0))\n(define mouse-left (event-receiver))\n(define mouse-middle (event-receiver))\n(define mouse-right (event-receiver))\n(define keyboard (event-receiver))\n(define fluxus-pulse (event-receiver))\n\n standard behaviours\n\n(define clock\n  (hold\n   (map-e\n    (lambda (e)\n      (current-milliseconds))\n    fluxus-pulse)))\n\n(define mouse-x\n  (hold\n   (map-e\n    (lambda (e)\n      (vector-ref mouse 0))\n    fluxus-pulse)))\n\n(define mouse-y\n  (hold\n   (map-e\n    (lambda (e)\n      (vector-ref mouse 1))\n    fluxus-pulse)))\n\n; reusable frtime constructs and utils\n\n(define (collide-b proc init pos-a pos-b radius )\n  (hold\n   (map-e\n    (lambda (_)\n      (snapshot/apply proc pos-a pos-b))\n    (when-e (< (vdist pos-a pos-b) 2)))\n   init))\n\n(define (key-control-b inc-key dec-key step)\n  (integral\n   (hold\n    (map-e\n     (lambda (key)\n       (if (equal? key dec-key) (- step)\n           (if (equal? key inc-key) step)))\n     keyboard) 0)))\n\n(define (key-press-b key on off)\n  (hold\n   (map-e\n    (lambda (e)\n      (if (eq? e key) on off))\n    keyboard) 0))\n\n(define (key-time-e key)\n  (map-e\n   (lambda (_)\n     (value-now clock))\n   (filter-e\n    (lambda (k)\n      (eq? k key))\n    keyboard)))\n\n(define (metro tick)\n  (let ((tick (floor (* tick 1000))))\n    (when-e (> (modulo (floor milliseconds) tick) (/ tick 2)))))\n\n(define (truncate-list lst count)\n  (cond\n    ((zero? count) '())\n    ((null? lst) '())\n    (else (cons (car lst) (truncate-list (cdr lst) (- count 1))))))\n\n(define (collision-with-list? pos with radius)\n  (foldl\n   (lambda (ob collided)\n     (if (object-struct? ob)\n         (if (< (vdist (object-struct-translate ob) pos) radius)\n             #t\n             collided)\n         collided))\n   #f\n   with))\n\n(define (factory proc event max-size)\n  (collect-b\n   event '()\n   (lambda (e lst)\n     (cons (proc e) (truncate-list lst max-size)))))\n\n(define (make-vector-grid w h d)\n  (let zloop ((z d) (l '()))\n    (cond ((zero? z) l)\n          (else\n           (zloop (- z 1)\n                  (let yloop ((y h) (l l))\n                    (cond ((zero? y) l)\n                          (else\n                           (yloop (- y 1)\n                                  (let xloop ((x w) (l l))\n                                    (cond ((zero? x) l)\n                                          (else\n                                           (xloop (- x 1) (cons (vec3 x y z) l))))))))))))))\n\n\n;---------------------------------------------------------------\n; scene rendering\n\n; the scene list contains everything we need to render\n(define scene-list '())\n\n StartFunctionDoc-en\n scene scene-list\n Returns: void\n Description:\n Sets the frisbee scene up. The list can contain primitive structures, or more lists.\n Example: (scene (list (cube)))\n EndFunctionDoc\n StartFunctionDoc-pt\n scene lista-cena\n Retorna: void\n Descrição:\n Prepara a cena frisbee. A lista pode conter primitivas, ou mais listas.\n Exemplo: (scene (list (cube)))\n EndFunctionDoc\n(define (scene s)\n  (set! scene-list s))\n\n;---------------------------------------------------------------\n; the model object\n(define-struct object-struct (shape colour translate scale rotate matrix hints camera-lock texture))\n\n(define/kw (object #:key\n                   (shape 'cube)\n                   (colour (vector 1 1 1))\n                   (translate (vector 0 0 0))\n                   (scale (vector 1 1 1))\n                   (rotate (vector 0 0 0))\n                   (matrix (flx-mident))\n                   (hints '())\n                   (camera-lock #f)\n                   (texture \"\"))\n  (make-object-struct shape colour translate scale rotate matrix hints camera-lock texture))\n\n; deal with loading model data\n(define model-map '())\n\n(define (get-model filename)\n  (let ((ret (assq filename model-map)))\n    (cond ((list? ret) (cadr ret)) ; we have it already\n          (else ; load and add it to the list\n           (let ((prim (flx-load-primitive filename)))\n             (flx-with-primitive prim (flx-hide 1) (flx-recalc-normals 1))\n             (set! model-map (cons (list filename prim) model-map))\n             ;(printf \"~a~n\" model-map)\n             prim)))))\n\n;---------------------------------------------------------------\n; particle system\n\n(define-struct particles-struct (colour translate scale rotate matrix texture rate speed spread reverse))\n\n(define/kw (particles #:key\n                      (colour (vector 1 1 1))\n                      (translate (vector 0 0 0))\n                      (scale (vector 0.1 0.1 0.1))\n                      (rotate (vector 0 0 0))\n                      (matrix (flx-mident))\n                      (texture \"\")\n                      (rate 1)\n                      (speed 0.1)\n                      (spread 360)\n                      (reverse #f))\n  (make-particles-struct colour translate scale rotate matrix texture rate speed spread reverse))\n\n(define max-particle-systems 10)\n(define num-particles 500)\n(define cur-particle 0)\n\n(define particle-systems '())\n\n(define (new-particle-system)\n  (let ((pp (flx-build-particles num-particles)))\n    (flx-with-primitive pp\n                        (flx-pdata-add \"vel\" \"v\")\n                        (flx-pdata-map!\n                         (lambda (c)\n                           (vector 1 1 1))\n                         \"c\")\n                        (flx-pdata-map!\n                         (lambda (vel)\n                           (vector 0 0 0))\n                         \"vel\"))\n    (set! particle-systems\n          (cons pp particle-systems))))\n\n(define (animate-particles)\n  (for-each\n   (lambda (particles)\n     (flx-with-primitive particles\n                         (flx-pdata-op \"+\" \"p\" \"vel\")))\n   particle-systems))\n\n(define (launch-particles num pos spread speed colour scale)\n  (cond ((not (zero? num))\n         (let ((spread (if (< spread 10) 10 spread)) ; stop rndcone going into infinite loop\n               (vel (flx-vtransform-rot (flx-vmul (rndcone (- 1 (* 2 (/ spread 360)))) speed)\n                                        (flx-get-transform))))\n           (flx-with-primitive (car particle-systems)\n                               (flx-pdata-set! \"p\" cur-particle pos)\n                               (flx-pdata-set! \"c\" cur-particle colour)\n                               (flx-pdata-set! \"s\" cur-particle scale)\n                               (flx-pdata-set! \"vel\" cur-particle vel)\n                               (set! cur-particle (modulo (+ cur-particle 1) (flx-pdata-size)))))\n         (launch-particles (- num 1) pos spread speed colour scale))))\n\n for calculating the spread\n(define (rndcone spread)\n  (let ((v (flx-srndvec)))\n    (if (> (flx-vdot v (vector 1 0 0)) spread)\n        v\n        (rndcone spread))))\n\n\n;--------------------------------------------------------------------\n\n(define (vector-now v)\n  (let ((v (value-now v)))\n    (if (void? v)\n        (vector 0 0 0)\n        (vector (value-now (vector-ref v 0))\n                (value-now (vector-ref v 1))\n                (value-now (vector-ref v 2))))))\n\n(define (matrix-now v)\n  (let ((v (value-now v)))\n    (if (void? v)\n        (flx-mident)\n        v)))\n\n\n; render the scene list\n(define (render-scene-list scene-list)\n\n  (define (set-state colour translate scale rotate matrix hints texture)\n    (flx-colour (vector-now colour))\n    (flx-translate (vector-now translate))\n    (flx-rotate (vector-now rotate))\n    (flx-concat (matrix-now matrix))\n    (flx-scale (vector-now scale))\n    (if (not (string=? texture \"\"))\n        (flx-texture (flx-load-texture texture)))\n    (for-each\n     (lambda (hint)\n       (case hint\n         ((solid) (flx-hint-solid))\n         ((wire) (flx-hint-wire))\n         ((unlit) (flx-hint-unlit))\n         (else (printf \"error, unknown hint :~a ~n\" hint))))\n     (value-now hints)))\n\n  (for-each\n   (lambda (v)\n     (match (value-now v)\n       [($ object-struct shape colour translate scale rotate matrix hints camera-lock texture)\n        (flx-with-state\n         (set-state colour translate scale rotate matrix hints texture)\n         (if camera-lock (flx-set-camera\n                          (flx-mmul (flx-get-transform)\n                                    (flx-mmul\n                                     (flx-mtranslate (vec3 0 0 -10))\n                                     (flx-mrotate (vec3 90 0 0))))))\n         (cond\n           ((string? shape) (flx-draw-instance (get-model shape)))\n           (else\n            (case shape\n              ((cube) (flx-draw-cube))\n              ((sphere) (flx-draw-sphere))\n              ((torus) (flx-draw-torus))\n              ((plane) (flx-draw-plane))\n              (else (printf \"render-scene-list: unknown object shape: ~a~n\" shape))))))]\n\n       [($ particles-struct colour translate scale rotate matrix texture rate speed spread reverse)\n        (flx-with-state\n         (flx-translate (vector-now translate))\n         (flx-rotate (vector-now rotate))\n         (flx-concat (matrix-now matrix))\n         (launch-particles rate\n                           (flx-vtransform (vec3 0 0 0) (flx-get-transform))\n                           (value-now spread)\n                           (value-now speed)\n                           (vector-now colour)\n                           (vector-now scale)))]\n\n       [(? undefined?) (void)]\n       [(? list?)\n        (render-scene-list (value-now v))]\n       [(? void?) (void)]))\n   (value-now scene-list)))\n\n; convert inputs to events\n(define (read-inputs)\n  (if (flx-mouse-button 1) (send-event mouse-left #t))\n  (if (flx-mouse-button 2) (send-event mouse-middle #t))\n  (if (flx-mouse-button 3) (send-event mouse-right #t))\n  (set! mouse (vector (flx-mouse-x) (flx-mouse-y)))\n  (send-event keyboard #f)\n  (for-each\n   (lambda (key)\n     (send-event keyboard key))\n   (flx-keys-down)))\n\n; syncronising rendering with frtime\n(define (loop)\n   emit the next pulse\n  (read-inputs)\n  (send-event fluxus-pulse #t)\n   wait for frtime to update\n  (do-in-manager-after (void))\n  (render-scene-list scene-list)\n  (animate-particles))\n\n(define (clear)\n  (flx-clear)\n  (new-particle-system)\n  (flx-every-frame (loop)))\n\n(clear)\n\n" ())) ("scratchpad" ("Funções disponíveis como parte do scratchpad fluxus." "" (("every-frame" ("função-callback" "void" "Ajusta uma função pra ser chamada todo o tempo em que o render está para desenhar um novo quadro." " (define (myfunc)\n     (colour (rndvec))\n     (draw-torus))\n\n (every-frame (myfunc)) \n")) ("clear" ("" "void" "Limpa o renderizador de todos os objetos e luzes. Limpa o sistema de física e re-inicializa a chamada de volta em every-frame. Geralmente uma boa coisa a fazer é colocar isto no ínicio dos scripts pra ter certeza que tudo esta limpo cada vez que você chamar a execução." " (clear) ; sem isso a gente ia acumular um novo cubo toda vez que F5 fosse pressionado\n (build-cube) \n")) ("start-framedump" ("string-nome string-tipo" "void" "Inicia a gravação de quadros no disco. Tipo pode ser um dos: \"tif\", \"jpg\" ou \"ppm\". Nomes dos arquivos são construidos junto com o número do quadro adicionado, prefixado em 5 zeros." " (start-framedump \"frame\" \"jpg\")\n")) ("end-framedump" ("" "void" "Para a gravação de quadros para o disco." " (end-framedump)\n")) ("set-physics-debug" ("boolean" "void" "Call with #t to turn on debug rendering for the physics." " (set-physics-debug #t)\n")) ("override-frame-callback" ("função-callback" "void" "Permite que você substitua a chamada de volta (callback) do quadro, para controlar o loop de renderização do fluxus de uma forma mais detalhada." " (override-frame-callback myfunc)\n (override-frame-callback default-fluxus-frame-callback) ; set it back again...\n"))))) ("osc" ("OSC significa Open Sound Control, e é um protocolo amplamente usado para passar dados entre aplicações multimidia. Fluxus pode enviar e/ou receber mensagens." " Um exemplo de uso de osc para comunicar entre pd e fluxus.\n Um script fluxus para mover um cubo baseado em mensagens osc\n entrando.\n -- osc.scm\n\n (define value 0)\n\n (define (test)\n     (push)\n     (if (osc-msg \"/zzz\")\n         (set! value (osc 0)))\n     (translate (vector 1 0 value))\n     (draw-cube)\n     (pop))\n \n (osc-source \"6543\")\n (every-frame (test))\n \n --- EOF\n Um patch PD para enviar mensagens de controle ao fluxus:\n --- zzz.pd\n #N canvas 618 417 286 266 10;\n #X obj 58 161 sendOSC;\n #X msg 73 135 connect localhost 6543;\n #X msg 58 82 send /zzz \\$1;\n #X floatatom 58 29 5 0 0 0 - - -;\n #X obj 58 54 / 100;\n #X obj 73 110 loadbang;\n #X connect 1 0 0 0;\n #X connect 2 0 0 0;\n #X connect 3 0 4 0;\n #X connect 4 0 2 0;\n #X connect 5 0 1 0;\n" (("osc-source" ("string-porta" "void" "Inicia o servidor osc, ou muda a porta. Bug conhecido: parece falhar se você usa de volta pra uma mesma porta já usada anteriormente." " (osc-source \"4444\")\t ; listen to port 4444 for osc messages\n")) ("osc-msg" ("string-nome" "void" "Retorna verdadeiro se a mensagem foi recebida desde o último quadro, e ajusta ela como a mensagem atual para chamadas subsequente ao (osc) para ler argumentos." " (cond \n     ((osc-msg \"/hello\")              ; if a the /hello message is recieved\n         (display (osc 1))(newline)))\t; print out the first argument\n")) ("osc" ("número-argumento" "void" "Retorna o argumento da mensagem osc atual." " (cond \n     ((osc-msg \"/hello\")              ; if a the /hello message is recieved\n         (display (osc 1))(newline)))\t; print out the first argument\n")) ("osc-destination" ("string-porta" "void" "Específica o destino para mensagens osc que estejam saindo. O nome da porta precisa ser específicado com todo o url e deve ser algo do tipo \"osc.udp://localhost:4444\"" " (osc-destination \"osc.udp:localhost:4444\")\n (osc-send \"/hello\" \"s\" (list \"boo!\"))  ; send a message to this destination\n")) ("osc-peek" ("" "msg-string" "Esta útil função retorna o nome, formato da string e número/string dos argumentos da última mensagem enviada como uma string - para debugar sua rede osc." " (display (osc-peek))(newline) \n")) ("osc-send" ("string-nome string-formato lista-argumento" "void" "Envia uma mensagem osc com o argumento da lista como dado osc. Somente suporta floats, ints e strings como dados. O formato-string deve ser composto de \"i\", \"f\" e \"s\", e deve bater com os tipos dados na lista. Isto poderia ser removido provavelmente, usando os tipos diretamente, mas fazendo isto desta forma permite que você diga o tipo da mensagem osc explicitamente." " (osc-destination \"osc.udp:localhost:4444\")\n (osc-send \"/hello\" \"sif\" (list \"boo!\" 3 42.3))  ; send a message to this destination\n"))))) ("midi" ("MIDI é Interface Digital de Intrumentos Musicais, e permite instrumentos musicais eletronicos, computadores, e outros equipamentos comunicar, controlar e sincronizar entre si. Fluxus pode receber controles e mensagens de notas MIDI. Example: (display (midi-info))(newline) (midi-init 1) (define (midi-test) (with-state (scale (vector (+ 1 (midi-ccn 0 1)) (+ 1 (midi-ccn 0 2)) (+ 1 (midi-ccn 0 3)))) (draw-cube))) (every-frame (midi-test)) EndSectionDoc StartFunctionDoc-en midi-info Returns: a list of (midi-port-number . midi-port-name-string) pairs Description: Returns information about the available MIDI input ports. Example: (midi-info) EndFunctionDoc StartFunctionDoc-pt midi-info Retorna: uma lista de (numero-porta-mide . string-nome-porta-midi) pares. Descrição: Retorna informação sobre portas de entrada MIDI disponíveis." " (midi-info)\n EndFunctionDoc\nScheme_Object *midi_info(int argc, Scheme_Object **argv)\n{\n\tScheme_Object *ret = NULL;\n\tif (midilistener == NULL)\n\t{\n\t\tmidilistener = new MIDIListener();\n\t}\n\n\tvector<string> port_names = midilistener->info();\n\tint port_count = port_names.size();\n\tScheme_Object **a = (Scheme_Object **)scheme_malloc(port_count *\n\t\t\t\t\t\t\tsizeof(Scheme_Object *));\n\n\tfor (int i = 0; i < port_count; i++)\n\t{\n\t\tScheme_Object *port_num = NULL;\n\t\tScheme_Object *port_name = NULL;\n\n\t\tMZ_GC_DECL_REG(2);\t\tMZ_GC_VAR_IN_REG(0,port_num);\n\t\tMZ_GC_VAR_IN_REG(1,port_name);\n\t\tMZ_GC_REG();\n\t\tport_num = scheme_make_integer(i);\n\t\tport_name = scheme_make_symbol(port_names[i].c_str());\n\n\t\ta[i] = scheme_make_pair(port_num, port_name);\n\n\t\tMZ_GC_UNREG();\t}\n\n\tret = scheme_build_list(port_count, a);\n\n\treturn ret;\n}\n\n StartFunctionDoc-en\n midi-init port-number\n Returns: void\n Description:\n Opens the specified MIDI input port.\n Example: (midi-init 1)\n EndFunctionDoc\n StartFunctionDoc-pt\n midi-init número-porta\n Retorna: void\n Descrição:\n Abre a porta de entrada MIDI especificada.\n Exemplo: (midi-init 1)\n EndFunctionDoc\nScheme_Object *midi_init(int argc, Scheme_Object **argv)\n{\n\tMZ_GC_DECL_REG(1);\tMZ_GC_VAR_IN_REG(0,argv);\n\tMZ_GC_REG();\n\tif (!SCHEME_NUMBERP(argv[0]))\t\tscheme_wrong_type(\"midi-init\", \"number\", 0, argc, argv);\n\tint port = (int)scheme_real_to_double(argv[0]);\n\n\tif (!midilistener)\n\t{\n\t\tmidilistener = new MIDIListener(port);\n\t}\n\telse\n\t{\n\t\tmidilistener->open(port);\n\t}\n\n\tMZ_GC_UNREG();    return scheme_void;\n\n}\n\n StartFunctionDoc-en\n midi-cc channel-number controller-number\n Returns: controller-value-number\n Description:\n Returns the controller value.\n Example: (midi-cc 0 1)\n EndFunctionDoc\n StartFunctionDoc-pt\n midi-cc número-canal número-controle\n Retorna: número-valor-controle\n Descrição:\n Retorna o valor do controle\n Exemplo: (midi-cc 0 1)\n EndFunctionDoc\nScheme_Object *midi_cc(int argc, Scheme_Object **argv)\n{\n\tScheme_Object *ret = NULL;\n\tMZ_GC_DECL_REG(2);\tMZ_GC_VAR_IN_REG(0,argv);\n\tMZ_GC_VAR_IN_REG(1,ret);\n\tMZ_GC_REG();\n\tif (!SCHEME_NUMBERP(argv[0]))\t\tscheme_wrong_type(\"midi-cc\", \"number\", 0, argc, argv);\n\tif (!SCHEME_NUMBERP(argv[1]))\t\tscheme_wrong_type(\"midi-cc\", \"number\", 1, argc, argv);\n\n\tint channel = (int)scheme_real_to_double(argv[0]);\n\tint index = (int)scheme_real_to_double(argv[1]);\n\n\tif (midilistener != NULL)\n\t{\n\t\tint val = midilistener->get_cc(channel, index);\n\t\tret = scheme_make_integer(val);\n\t}\n\telse\n\t{\n\t\tret = scheme_void;\n\t}\n\n\tMZ_GC_UNREG();\treturn ret;\n}\n\n StartFunctionDoc-en\n midi-ccn channel-number controller-number\n Returns: controller-value-number\n Description:\n Returns the controller value normalised to the (0, 1) interval.\n Example: (midi-ccn 0 1)\n EndFunctionDoc\n StartFunctionDoc-pt\n midi-ccn número-canal número-controle\n Retorna: número-valor-controle\n Descrição:\n Retorna o valor normalisado do controle no intervalo (0, 1).\n Exemplo: (midi-ccn 0 1)\n EndFunctionDoc\nScheme_Object *midi_ccn(int argc, Scheme_Object **argv)\n{\n\tScheme_Object *ret = NULL;\n\tMZ_GC_DECL_REG(2);\tMZ_GC_VAR_IN_REG(0,argv);\n\tMZ_GC_VAR_IN_REG(1,ret);\n\tMZ_GC_REG();\n\tif (!SCHEME_NUMBERP(argv[0]))\t\tscheme_wrong_type(\"midi-ccn\", \"number\", 0, argc, argv);\n\tif (!SCHEME_NUMBERP(argv[1]))\t\tscheme_wrong_type(\"midi-ccn\", \"number\", 1, argc, argv);\n\n\tint channel = (int)scheme_real_to_double(argv[0]);\n\tint index = (int)scheme_real_to_double(argv[1]);\n\n\tif (midilistener != NULL)\n\t{\n\t\tfloat val = midilistener->get_ccn(channel, index);\n\t\tret = scheme_make_float(val);\n\t}\n\telse\n\t{\n\t\tret = scheme_make_float(0);\n\t}\n\n\tMZ_GC_UNREG();\treturn ret;\n}\n\n StartFunctionDoc-en\n midi-note\n Returns: #(on-off-symbol channel note velocity) or #f\n Description:\n Returns the next event from the MIDI note event queue or #f if the queue is empty.\n Example: (midi-note)\n EndFunctionDoc\n StartFunctionDoc-pt\n midi-note\n Retorna: #(símbolo-ligado-desligado canal nota velocidade) ou #f\n Descrição:\n Retorna o próximo evento da fila de eventos de nota MIDI ou #f se a\n fila está vazia.\n Exemplo: (midi-note)\n EndFunctionDoc\nScheme_Object *midi_note(int argc, Scheme_Object **argv)\n{\n\tScheme_Object *ret = NULL;\n\tMZ_GC_DECL_REG(2);\tMZ_GC_VAR_IN_REG(2,ret);\n\tMZ_GC_REG();\n\tret = scheme_false;\n\tif (midilistener != NULL)\n\t{\n\t\tMIDINote *note = midilistener->get_note();\n\t\tif (note)\n\t\t{\n\t\t\tret = scheme_make_vector(4, scheme_void);\n\t\t\tif (note->on_off == MIDIListener::MIDI_NOTE_OFF)\t\t\t\tSCHEME_VEC_ELS(ret)[0]= scheme_intern_symbol(\"note-off\");\n\t\t\telse\n\t\t\t\tSCHEME_VEC_ELS(ret)[0]= scheme_intern_symbol(\"note-on\");\n\n\t\t\tSCHEME_VEC_ELS(ret)[1]= scheme_make_integer(note->channel);\n\t\t\tSCHEME_VEC_ELS(ret)[2]= scheme_make_integer(note->note);\n\t\t\tSCHEME_VEC_ELS(ret)[3]= scheme_make_integer(note->velocity);\n\t\t}\n\t}\n\n\tMZ_GC_UNREG();\treturn ret;\n}\n\n StartFunctionDoc-en\n midi-peek\n Returns: msg-string\n Description:\n Returns the name, and event type, and parameter bytes of the last MIDI\n event as a string for debugging purposes.\n Example: (display (midi-peek))(newline)\n EndFunctionDoc\n StartFunctionDoc-pt\n midi-peek\n Retorna: string-msg\n Descrição:\n Retorna o nome, tipo de evento e os bytes parâmetros do último\n evento de MIDI como uma string para propósitos de debugging.\n Exemplo: (display (midi-peek))(newline)\n EndFunctionDoc\nScheme_Object *midi_peek(int argc, Scheme_Object **argv)\n{\n\tif (midilistener != NULL)\n\t{\n\t\treturn scheme_make_utf8_string(midilistener->get_last_event().c_str());\n\t}\n\telse\n\t{\n\t\treturn scheme_make_utf8_string(\"\");\n\t}\n}\n\n#ifdef STATIC_LINK\nScheme_Object *midi_scheme_reload(Scheme_Env*env)\n#else\nScheme_Object *scheme_reload(Scheme_Env*env)\n#endif\n{\n\tScheme_Env*menv = NULL;\n\tMZ_GC_DECL_REG(2);\tMZ_GC_VAR_IN_REG(0,env);\n\tMZ_GC_VAR_IN_REG(1,menv);\n\tMZ_GC_REG();\n\t add all the modules from this extension\n\tmenv = scheme_primitive_module(scheme_intern_symbol(\"fluxus-midi\"), env);\n\n\tscheme_add_global(\"midi-init\",\n\t\t\tscheme_make_prim_w_arity(midi_init, \"midi-init\", 1, 1), menv);\n\tscheme_add_global(\"midi-info\",\n\t\t\tscheme_make_prim_w_arity(midi_info, \"midi-info\", 0, 0), menv);\n\tscheme_add_global(\"midi-cc\",\n\t\t\tscheme_make_prim_w_arity(midi_cc, \"midi-cc\", 2, 2), menv);\n\tscheme_add_global(\"midi-ccn\",\n\t\t\tscheme_make_prim_w_arity(midi_ccn, \"midi-ccn\", 2, 2), menv);\n\tscheme_add_global(\"midi-note\",\n\t\t\tscheme_make_prim_w_arity(midi_note, \"midi-note\", 0, 0), menv);\n\tscheme_add_global(\"midi-peek\",\n\t\t\tscheme_make_prim_w_arity(midi_peek, \"midi-peek\", 0, 0), menv);\n\n\tscheme_finish_primitive_module(menv);\n\tMZ_GC_UNREG();\n\treturn scheme_void;\n}\n\n#ifndef STATIC_LINK\nScheme_Object *scheme_initialize(Scheme_Env*env)\n{\n\treturn scheme_reload(env);\n}\n\nScheme_Object *scheme_module_name()\n{\n\treturn scheme_intern_symbol(\"fluxus-midi\");\n}\n#endif" ())) ("tartaruga" ("O construtor polygonal Turtle é um modo experimental de construir objetos poligonais usando uma tartaruga do estilo logo no espaço 3d. Em que você pode dirigir a tartaruga ao redor colocando vértices e construindo formas proceduralmente. A tartaruga também pode ser usa para deformar objetos poligonais existentes, fixando ela a objetos que você já criou." " (define (build n)\n     (turtle-reset)\n     (turtle-prim 4)\n     (build-loop n n)\n     (turtle-build))\n \n (define (build-loop n t)\n     (turtle-turn (vector 0 (/ 360 t) 0))\n     (turtle-move 1)\n     (turtle-vert)\n     (if (< n 1)\n         0\n         (build-loop (- n 1) t)))\n" (("turtle-prim" ("número-tipo" "void" "Inicia a construção de uma nova primitiva poligonal com a tartaruga. O tipo especifica o tipo da face do poligono e é um dos seguintes: 0: triangle strip, 1: quad list, 2: triangle list, 3: triangle fan, 4: general polygon" " (turtle-prim 0)\n")) ("turtle-vert" ("" "void" "Cria um novo vértice na posição atual, ou ajusta o vértice atual se o construtor tartaruga estiver fixado." " (turtle-vert)\n")) ("turtle-build" ("" "void" "Constrói o objeto com a lista de vértices definida e dá isto ao renderizador. Não tem efeito se o construtor tartaruga estive fixado a uma primitiva." " (define mynewshape (turtle-build))\n")) ("turtle-move" ("número-distância" "void" "Move a tartaruga pra frente na sua orientação atual." " (turtle-move 1)\n")) ("turtle-push" ("" "void" "O construtor tartaruga tem sua própria pilha de transformações, Push lembra a posição atual e orientação." " (turtle-push)\n")) ("turtle-pop" ("" "void" "O construtor tartaruga tem sua própria pilha de transformações. Pop esquece a posição atual e orientação, e vai de volta para o estado do último push." " (turtle-pop)\n")) ("turtle-turn" ("vetor-rotação" "void" "Rotaciona a orientação da tartaruga com o ângulos euler fornecidos (rotações em x, y e z)" " (turtle-turn (vector 45 0 0))\n")) ("turtle-reset" ("" "void" "Reinicia a atual posição e rotação da tartaruga para a origem." " (turtle-reset)\n")) ("turtle-attach" ("número-id-primitiva" "void" "Anexa a tartaruga a uma primitiva poligonal existente. Isso significa que você será capaz de deformar pontos de objetos existentes usando o construtor tartaruga." " (define myshape (build-sphere 10 10))\n (turtle-attach myshape)\n")) ("turtle-skip" ("número-contador" "void" "Quando anexado, faz com que a tartaruga pule vértices. Este valor pode ser negativo, o que vai resultar na tartaruga escrevendo para vértices anteriores." " (turtle-skip -1)\n")) ("turtle-position" ("" "void" "Quando anexado, retorna o índice atual da pdata que a tartaruga esta escrevendo para." " (display (turtle-position))(newline)\n")) ("turtle-seek" ("número-posição" "void" "Quando anexado, ajusta o índice absoluto da pdata que a tartaruga está escrevendo para." " (turtle-seek 0)\n"))))) ("fisica" ("O sistema de física em fluxus é baseado na biblioteca ODE, que permite a você adicionar propriedades físicas a objetos e colocá-los em movimento. Já que ODE foi projetada para simulações em corpos rígidos, estruturas são descritas em termos de objetos, dobras e forças. Uma explicação muito mais compreensiva destes conceitos pode ser encontrada na documentação de ODE, que você provavelmente baixou se teve que compilar fluxus, ou pode ser encontrado em @url{http://ode.org/ode-docs.html} Para ajudar com a depuração de dobras, tente chamar (render-physics) em cada frame, o que vai renderizar locators mostrando a você posições e eixos de dobras que possuem informação posicional." "" (("collisions" ("on/off-número" "void" "Habilita ou desabilita detecção de colisão. Padrão é desligado." " (collisions 1)\n")) ("ground-plane" ("vetor-plano número-offset" "void" "Cria um plano passivo infinito pra usar como 'chão'." " (ground-plane (vector 0 1 0) 0)\n")) ("active-box" ("número-id-primitiva" "void" "Permite que o objeto seja afetado pelo sistema físico, usando uma caixa como um volume limite. Como um objeto ativo, ele vai ser transformado por ODE. Nota: rotações só funcionam corretamente se você específicar suas escalagens primeiro, depois rotacionar (translação não importa) basicamente, ode não pode lidar com tranformações cortadas." " (define mycube (build-cube))\n (active-box mycube)\n")) ("active-cylinder" ("número-id-primitiva" "void" "Permite que o objeto seja afetado pelo sistema físico, usando um cilindro como um volume limite. Como um objeto ativo, ele vai ser transformado por ODE. Nota: rotações só funcionam corretamente se você específicar suas escalagens primeiro, depois rotacionar (translação não importa) basicamente, ode não pode lidar com tranformações cortadas." " (define mycube (build-cube))\n (active-cylinder mycube)\n")) ("active-sphere" ("número-id-primitiva" "void" "Permite que o objeto seja afetado pelo sistema físico, usando uma esfera como um volume limite. Como um objeto ativo, ele vai ser transformado por ODE. Nota: rotações só funcionam corretamente se você específicar suas escalagens primeiro, depois rotacionar (translação não importa) basicamente, ode não pode lidar com tranformações cortadas." " (define mycube (build-cube))\n (active-sphere mycube)\n")) ("active-mesh" ("número-primitivaid" "void" "Permite que o objeto seja afetado pelo sistema de física, usando a malha como volume de colisão. Esta função funciona apenas em primitivas, lista de triangulos indexadas. Como um objeto ativo, ela vai ser transformada por ode. Nota: rotações só funcionam corretamente se você especificar suas transformações de escala antes, depois rotacionar (translação não importa), basicamente ode não consegue lidar com cisalhamento de transformações." " (define myshape (load-primitive \"bot.obj\"))\n (active-mesh myshape)\n")) ("passive-box" ("número-id-primitiva" "void" "Permite que o objeto seja resolvido pelo sistema de física, usando uma caixa como o limite. Como um objeto passivo, objetos ativos vão colidir com ele, mas este não vai ser transformado. Nota: rotações só funcionam corretamente se você especificar suas transformaçoes de escala primeiro, depois rotacionar (translação não importa) basicamente, ode não pode lidar com transformações cortadas." " (define mycube (build-cube))\n (passive-box mycube)\n")) ("passive-cylinder" ("número-id-primitiva" "void" "Permite que o objeto seja resolvido pelo sistema de física, usando um cilindro como o limite. Como um objeto passivo, objetos ativos vão colidir com ele, mas este não vai ser transformado. Nota: rotações só funcionam corretamente se você especificar suas transformaçoes de escala primeiro, depois rotacionar (translação não importa) basicamente, ode não pode lidar com transformações cortadas." " (define mycube (build-cube))\n (passive-cylinder mycube)\n")) ("passive-sphere" ("número-id-primitiva" "void" "Permite que o objeto seja resolvido pelo sistema de física, usando uma esfera como o limite. Como um objeto passivo, objetos ativos vão colidir com ele, mas este não vai ser transformado. Nota: rotações só funcionam corretamente se você especificar suas transformaçoes de escala primeiro, depois rotacionar (translação não importa) basicamente, ode não pode lidar com transformações cortadas." " (define mycube (build-cube))\n (passive-sphere mycube)\n")) ("passive-mesh" ("numero-primitivaid" "void" "Permite que o objeto seja atuado no sistema de física, usando a malha como o volume de colisão. Esta função funciona apenas em primitivas, lista-de-triangulos indexados. Como um objeto passivo, objetos ativos podem colidir com ela, mas ela não vai sofrer transformação. Nota: rotações só funcionam corretamente se você especificar suas transformaçoes de escala primeiro, depois rotacionar (translação não importa) basicamente, ode não pode lidar com transformações cortadas." " (define myshape (load-primitive \"bot.obj\"))\n (passive-mesh myshape)\n")) ("physics-remove" ("numero-primitivaid" "void" "Remove o objeto do sistema de física." " (define mycube (build-cube))\n (active-box mycube)\n (physics-remove mycube)\n")) ("surface-params" ("slip1-número slip2-número softerp-número softcfm-número" "void" "Ajusta alguns parâmetros globais de superfície que afetam o atrito e reflexão. Veja seção 7.3.7 dos docs de ODE para uma explicação desses parâmetros." " (surface-params 0.1 0.1 0.1 0.1)\n")) ("build-balljoint" ("número-id-primitiva número-id-primitiva vetor-eixo" "void" "Cria um balljoint para conectar dois objetos (veja os docs de ode para uma descrição detalhada das diferenças entre os tipos de dobras). ODE considera as juntas(joints) serem uma restrição imposta entre dois objetos. Quando criando uma junção, é importante ter as duas primitivas sendo juntas na posição desejada antes de criar uma junção. Junções podem ser criadas, modificadas e indexadas de uma maneira similar a outras primitivas." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (build-balljoint shape1 shape2 (vector 0 0 0)) \n (kick shape1 (vector 0 2 0))\n \n (set-physics-debug #t)\n")) ("build-fixedjoint" ("número-id-primitiva" "void" "Cria uma junção para conectar um objeto ao ambiente global. Isto trava o objeto no lugar." " (clear)\n (define shape1 (with-state \n         (translate (vector 0 1 0))\n         (build-cube)))\n (active-box shape1)\n \n (build-fixedjoint shape1) ; not very exciting... \n")) ("build-hingejoint" ("numero-id-primitiva1 número-id-primitiva2 vetor-ancora vetor eixo" "void" "Cria uma junção circular para conectar dois objetos ( veja os docs de ODE para uma descrição detalhada entre tipos de junções). ODE considera as juntas(joints) serem uma restrição imposta entre dois objetos. Quando criando uma junção, é importante ter as duas primitivas sendo juntas na posição desejada antes de criar uma junção. Junções podem ser criadas, modificadas e indexadas de uma maneira similar a outras primitivas." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (build-hingejoint shape1 shape2 (vector 0 0 0) (vector 0 0 1)) \n (kick shape1 (vector 0 2 0))\n \n (set-physics-debug #t)\n")) ("build-sliderjoint" ("número-id-primitiva1 número-id-primitiva2 vetor-eixo" "hingeid-number" "Cria uma junção deslizante entre dois objetos (veja a documentação de ODE para uma descrição detalhada das diferenças entre os tipos de conexões). ODE considera as juntas(joints) serem uma restrição imposta entre dois objetos. Quando criando uma junção, é importante ter as duas primitivas sendo juntas na posição desejada antes de criar uma junção. Junções podem ser criadas, modificadas e indexadas de uma maneira similar a outras primitivas." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (build-sliderjoint shape1 shape2 (vector 1 0 0)) \n (kick shape1 (vector 0 2 0))\n \n (set-physics-debug #t)\n")) ("build-hinge2joint" ("número-id-primitiva1 número-id-primitiva2 vetor-ancora vetor-eixo1 vetor-eixo2" "numero-id-dobradiça(hinge)" "Cria uma dobradiça de junções para conectar dois objetos (veja a documentação de ODE para uma descrição detalhada das diferenças entre os tipos de conexões). ODE considera as juntas(joints) serem uma restrição imposta entre dois objetos. Quando criando uma junção, é importante ter as duas primitivas sendo juntas na posição desejada antes de criar uma junção. Junções podem ser criadas, modificadas e indexadas de uma maneira similar a outras primitivas." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (build-hinge2joint shape1 shape2 (vector 0 0 0) (vector 1 0 0) (vector 0 1 0)) \n (kick shape1 (vector 0 2 0))\n \n (set-physics-debug #t)\n")) ("build-amotorjoint" ("número-id-primitiva1 número-id-primitiva2 vetor-eixo" "número-id-dobradiça(hinge)" "Cria uma junção com mobilidade angular para conectar dois objetos (veja a documentação de ODE para uma descrição detalhada das diferenças entre os tipos de conexões). ODE considera as juntas(joints) serem uma restrição imposta entre dois objetos. Quando criando uma junção, é importante ter as duas primitivas sendo juntas na posição desejada antes de criar uma junção. Junções podem ser criadas, modificadas e indexadas de uma maneira similar a outras primitivas." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (build-amotorjoint shape1 shape2 (vector 1 0 0)) \n (kick shape1 (vector 0 2 0))\n \n (set-physics-debug #t)\n")) ("joint-param" ("número-id-junção param-string número-valor" "número-id-dobradiça(hinge)" "Ajusta o parâmetro da junção para uma junta onde param é um dos seguintes: \"HiStop\", \"Vel\", \"FMax\", \"FudgeFactor\", \"Bounce, \"CFM\", \"StopERP\", \"StopCFM\", \"SuspensionERP\", \"SuspensionCFM\", \"Vel2\", \"FMax2\". Veja Seção 7.5.1 da documentação de ODE para uma explicação de cada um desses parâmetros, e a qual tipos de junções eles aplicam." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (define j (build-hinge2joint shape1 shape2 (vector 0 0 0) (vector 1 0 0) (vector 0 1 0)))\n (joint-param j \"Vel2\" 0.1)\n (joint-param j \"FMax2\" 0.2)\n (joint-param j \"LoStop\" -0.75)\n (joint-param j \"HiStop\" 0.75)\n \n (set-physics-debug #t)\n")) ("joint-angles" ("jointid-number número-angulo número-vel" "void" "Ajusta um novo ângulo para este joint, com uma velocidade dada para chegar lá." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (define j (build-hingejoint shape1 shape2 (vector 0 0 0) (vector 0 1 0)))\n (joint-param j \"FMax\" 20)\n (joint-param j \"LoStop\" -1)\n (joint-param j \"HiStop\" 1)\n \n (set-physics-debug #t)\n \n (define (animate)\n     (joint-angle j 0.1 (* 5 (sin (time)))))\n")) ("joint-slide" ("numero-jointid força" "void" "Aplica a força dada na direção do slide. Isto é, aplica uma força de magnitude força, na direçao do eixo do slide, ao corpo1, e com a mesma magnitude mas direção contrária ao corpo2." " (clear)\n (ground-plane (vector 0 1 0) -1)\n (collisions 1)\n \n (define shape1 (with-state \n         (translate (vector -1 0 0))\n         (build-cube)))\n (active-box shape1)\n \n (define shape2 (with-state \n         (translate (vector 1 0 0))\n         (build-cube)))\n (active-box shape2)\n \n (define j (build-sliderjoint shape1 shape2 (vector 1 0 0)))\n (joint-param j \"FMax\" 20)\n (joint-param j \"LoStop\" -1)\n (joint-param j \"HiStop\" 1)\n \n (set-physics-debug #t)\n \n (define (animate)\n     (joint-slide j (* 5 (sin (time)))))\n")) ("set-max-physical" ("número-max" "void" "Ajusta o máximo número de objetos que o sistema de física pode lidar. Quando o máximo nível foi alcançado os objetos mais antigos são automaticamente destroidos." " (clear)\n (set-max-physical 200)\n \n (every-frame\n     (with-state\n     (translate (vector 0 5 0))\n         (scale (srndvec))\n         (colour (rndvec))\n         (let ((ob (build-cube)))    \n             (active-box ob)\n             (kick ob (vmul (srndvec) 3))\n             (twist ob (vmul (srndvec) 2)))))\n")) ("set-mass" ("número-id-primitiva número-massa" "void" "Ajusta a massa de um objeto ativo no sistema de física" " (clear)\n (ground-plane (vector 0 1 0) 0)\n (collisions 1)\n (set-max-physical 20)\n \n ; not a great example, but these boxes will have \n ; different mass, so behave a bit differently.\n \n (every-frame\n     (when (> (rndf) 0.92)\n         (with-state\n             (translate (vector 0 5 0))\n             (scale (vmul (rndvec) 5))\n             (colour (rndvec))\n             (let ((ob (build-cube)))    \n                 (active-box ob)\n                 (set-mass ob (* (rndf) 10))\n                 (kick ob (vmul (srndvec) 3))\n                 (twist ob (vmul (srndvec) 2))))))    \n")) ("gravity" ("vetor-gravidade" "void" "Ajusta a força e direção da gravidade." " (clear)\n (ground-plane (vector 0 1 0) 0)\n (collisions 1)\n (set-max-physical 20)\n \n (every-frame\n     (begin\n         (gravity (vector 0 (sin (time)) 0)) ; change gravity! :)\n         (when (> (rndf) 0.92)\n             (with-state\n                 (translate (vector 0 5 0))\n                 (scale (rndvec))\n                 (colour (rndvec))\n                 (let ((ob (build-cube)))    \n                     (active-box ob)\n                     (kick ob (vmul (srndvec) 3))\n                     (twist ob (vmul (srndvec) 2)))))))\n")) ("kick" ("número-id-primitiva vetor-chute" "void" "Aplica força de translação ao objeto." " (clear)\n (collisions 1)\n (set-max-physical 20)\n (gravity (vector 0 0 0))\n\n (every-frame\n     (when (> (rndf) 0.92)\n         (with-state\n             (scale (rndvec))\n             (colour (rndvec))\n             (let ((ob (build-cube)))\n                 (active-box ob)\n                 (kick ob (vmul (srndvec) 3))\n                 (twist ob (vmul (srndvec) 2))))))\n")) ("twist" ("número-id-primitiva vetor-giro" "void" "Aplica força rotacional ao objeto" " (clear)\n (collisions 1)\n (set-max-physical 20)\n (gravity (vector 0 0 0))\n\n (every-frame\n     (when (> (rndf) 0.92)\n         (with-state\n             (scale (rndvec))\n             (colour (rndvec))\n             (let ((ob (build-cube)))\n                 (active-box ob)\n                 (kick ob (vmul (srndvec) 3))\n                 (twist ob (vmul (srndvec) 2))))))\n")) ("add-force" ("número-primitivaid vetor-força" "void" "Adiciona força ao corpo" " (clear)\n (collisions 1)\n (for ([i (in-range 15)])\n    (let* ([p (vmul (srndvec) 15)]\n           [c (with-state\n                    (translate p)\n                    (build-cube))])\n        (active-box c)\n        (set-gravity-mode c #f)\n        (add-force c (vmul p -10))))\n")) ("add-torque" ("número-primitivaid vetor-torque" "void" "Adiciona torque ao corpo" " (clear)\n (define c (build-cube))\n (active-box c)\n (add-torque c #(10 0 0))\n")) ("set-gravity-mode" ("número-primitivaid modo-booleano" "void" "Ajusta se o corpo é influenciado pela gravidade do mundo ou não." " (clear)\n (collisions 1)\n (define a (with-state\n               (translate (vector -.95 5 0))\n               (build-cube)))\n (define b (build-cube))\n (active-box a)\n (active-box b)\n (set-gravity-mode b #f)\n")) ("has-collided" ("número-id-primitiva" "void" "Retorna verdadeiro se a primitiva pega colidiu no ultimo frame." " (clear)\n (ground-plane (vector 0 1 0) 0)\n (collisions 1)\n (set-max-physical 20)\n \n (define ob (with-state\n     (translate (vector 0 5 0))\n     (build-cube)))\n \n (active-box ob)\n \n (every-frame\n     (when (has-collided ob)\n         (with-primitive ob\n             (colour (rndvec)))))\n"))))) ("matematica" ("Estas funções sao optimizadas para gráficos em 3d, e a colisão entre ciência da computação e matemática é aparente aqui, então vetores representando \"vectors\" são nesse contexto tidos como 3 elementos em tamanho, quaternions são vetores de tamanho 4, e matrizes são vetores de 16 elementos." "" (("vmul" ("vetor número" "vetor resultante" "Multiplica um vetor por um número." " (vmul (vector 1 2 3) 2)\n")) ("vadd" ("vetor vetor" "vetor resultante" "Adiciona dois vetores, um ao outro." " (vadd (vector 1 2 3) (vector 1 2 3))\n")) ("vsub" ("vetor vetor" "vetor resultante" "Subtrai um vetor de outro." " (vsub (vector 1 2 3) (vector 1 2 3))\n")) ("vdiv" ("vetor número" "vetor resultante" "Divide um vetor por um número" " (vdiv (vector 1 2 3) 2)\n")) ("vtransform" ("vetor matriz" "vetor resultante" "Multiplica (transforma) um vetor por uma matriz." " (vtransform (vector 0 1 0) (mrotate (vector 90 0 0)))\n")) ("vtransform-rot" ("vetor matriz" "vetor resultante" "Multiplica (transforma) um vetor por uma matriz, mas deixa de fora a parte de translação. Para ser usado em operações involvendo normais." " (vtransform-rot (vector 0 1 0) (mrotate (vector 90 0 0)))\n")) ("vnormalise" ("vetor" "vetor resultante" "Retorna a forma normalisada do vetor (length=1)" "")) ("vdot" ("vetor vetor" "número resultante" "Retorna o produto multiplicado de dois vetores." " (vdot (vector 0 1 0) (vector 1 0 0))\n")) ("vmag" ("vetor" "número resultante" "Retorna a magnitude, ou alcance do vetor" " (vmag (vector 0 1 1))\n")) ("vreflect" ("vetor vetor" "vetor-resultante" "Retorna a reflexão de um vetor em relação ao outro." " (vreflect (vector 0 1 1) (vector 1 0 1))\n")) ("vdist" ("vetor vetor" "número resultante" "Tratando os vetores como pontos, retorna a distancia entre eles." " (vdist (vector 100 100 0) (vector 0 0 100))\n")) ("vdist-sq" ("vetor vetor" "número resultante" "Tratando os vetores como pontos, retorna a distancia entre eles." " (vdist-sq (vector 100 100 0) (vector 0 0 100))\n")) ("vcross" ("vetor vetor" "vetor resultante" "Retorna o produto cruzado entre dois vetores, resultando em um vetor que é perpendicular aos cruzados." " (vcross (vector 100 100 0) (vector 0 0 100)) \n")) ("mmul" ("vetor-matriz vetor-matriz" "vetor-matriz" "Multiplica duas matrizes." " (mmul (mtranslate (vector 1 0 0)) (mrotate (vector 0 90 0)))\n")) ("madd" ("vetor-matriz vetor-matriz" "vetor-matriz" "Adiciona duas matrizes." " (madd (mtranslate (vector 1 0 0)) (mrotate (vector 0 90 0)))\n")) ("msub" ("vetor-matriz vetor-matriz" "vetor-matriz" "Subtrai uma matriz de outra." " (msub (mtranslate (vector 1 0 0)) (mrotate (vector 0 90 0)))\n")) ("mdiv" ("vetor-matriz vetor-matriz" "vetor-matriz" "Divide uma matriz por outra." " (mdiv (mtranslate (vector 1 0 0)) (mrotate (vector 0 90 0)))\n")) ("mident" ("" "vetor-matriz" "Retorna a matriz identidade" " (mident)\n")) ("mtranslate" ("vetor" "vetor-matriz" "Retorna uma matriz representando a tranformação(translação) especificada." " (mtranslate (vector 100 0 0))\n")) ("mrotate" ("vetor" "vetor-matriz" "Retorna uma matriz representando a rotação especificada. Aceita um vetor de angulos euler, ou um quatérnio." " (mrotate (vector 0 45 0))\n")) ("mscale" ("vetor" "vetor-matriz" "Retorna uma matriz representando a escalagem especificada." " (mscale (vector 0.5 2 0.5))\n")) ("mtranspose" ("vetor-matriz" "vetor matriz" "Retorna a transposta do vetor de entrada" " (mtranspose (mident))\n")) ("minverse" ("vetor-matriz" "vetor-matriz" "Retorna o inverso do vetor de entrada." " (minverse (mscale (vector 0.5 2 0.5)))\n")) ("maim" ("vetor-mira vetor-acima" "vetor-matriz" "Retorna uma matriz representando uma rotação de mira de forma que o eixo X aponta pra baixo da direção de mira, e o eixo y aponta pra cima do vetor de cima. Provavelmente sofre do Gimbal Lock." " (maim (vector 0 0 1) (vector 0 1 0))\n")) ("matrix->euler" ("matriz-vetor" "vetor" "Retorna os angulos euler extraidos da matriz." " (matrix->euler (mrotate (vector 15 0 0)))\n")) ("qaxisangle" ("vetor-eixo angulo" "vetor-quaternion" "Retorna o quatérnio representando o ângulo de rotação sobre o eixo especificado." " (qaxisangle (vector 0 1 0) 45)\n")) ("qmul" ("vetor-quatérnio vetor-quatérnio" "vetor-quatérnio" "Multiplica um quatérnio por outro." " (qmul (qaxisangle (vector 0 1 0) 45) (qaxisangle (vector 0 0 1) 180))\n")) ("qnormalise" ("vetor-quatérnio" "vetor-quatérnio" "Normalisa um quatérnio" " (qnormalise (qaxisangle (vector 0 19 0) 45))\n")) ("qtomatrix" ("vetor-quatérnio" "vetor-matriz" "Converte um quatérnio em uma matriz de rotação" " (qtomatrix (qaxisangle (vector 0 1 0) 45))\n")) ("qconjugate" ("vetor-quatérnio" "vetor-quatérnio" "Conjuga um quatérnio" " (qconjugate (qaxisangle (vector 0 1 0) 45))\n")) ("fmod" ("numero-numerador numero-denominador" "numero-real" "Retorna o resto em ponto-flutuante de numerador/denominador." " (fmod 14.4 10)\n")) ("snoise" ("numero-real" "numero-real" "Retorna Simplex Noise 1D/2D/3D/4D no intervalo -1->1 dependendo do número de parâmetros." " (snoise 1.0 2.0) ; 2D noise\n (snoise 6.1 2.4 .5 1.3) ; 4D noise\n \n ; example on a pixel prim\n (clear)\n (with-primitive (build-pixels 100 100)\n     (pdata-index-map!\n         (lambda (i c)\n             (snoise (* 0.1 (modulo i (pixels-width)))\n                     (* 0.1 (quotient i (pixels-height)))))\n         \"c\")\n     (pixels-upload))\n")) ("noise" ("numero-real" "numero-real" "Retorna o valor do Noise Perlin nas coordenadas especificadas." " (noise 1.0 2.0) ; 2D noise\n (noise 6.1 2.4 .5) ; 3D noise\n\n ; example on a pixel prim\n (clear)\n (with-primitive (build-pixels 100 100)\n     (pdata-index-map!\n         (lambda (i c)\n             (noise (* 0.1 (modulo i (pixels-width)))\n                    (* 0.1 (quotient i (pixels-height)))))\n         \"c\")\n     (pixels-upload))\n")) ("noise-seed" ("numero-unsigned" "void" "Ajusta o valor da semente para o noise." " (noise-seed 1)\n")) ("noise-detail" ("numeros-oitavos numeros-queda" "void" "Ajusta o caráter e nível de detalhe produzido pelo função noise Perlin." " (noise-detail 4) ; noise with 4 octaves\n (noise-detail 4 .5) ; noise with 4 octaves and .5 falloff\n"))))) ("luzes" ("Sem luzes você não seria capaz de ver nada. Por sorte fluxus te dá uma de graça por padrão, uma luz pontual difusa e branca fixa à camêra. Para iluminações mais interessantes, você vai precisar destas funções. Usando as funções fixas de pipeline gráfico padrão, falando simplisticamente, OpenGL multiplica estes valores pela superficie do material (ajustado com comandos do estado local [local state] como ambient e diffuse) e o valor cor da textura dando a cor final." "" (("make-light" ("simbolo-tipo simbolo-travado-camera[cameralocked]" "lightid-number" "Faz uma luz nova. O tipo pode ser um destes: point, directional ou spot. Se a string de cameralocked não estiver livre então esta vai ser fixa à câmera, e mexer ao redor quando você mover a câmera." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n")) ("light-ambient" ("número-id-luz colour" "void" "Ajusta a contribuição do ambiente para a luz especificada." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n")) ("light-diffuse" ("número-id-luz colour" "void" "Ajusta a contribuição difusa para a luz especificada." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n")) ("light-specular" ("número-id-luz colour" "void" "Ajusta a contribuição especular para a luz específicada." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n")) ("light-position" ("número-id-luz vetor-posição" "void" "Ajusta a posição da luz especificada. Em espaço global se livre, em espaço da câmera se fixa." " ; turn off the main light\n (light-diffuse 0 (vector 0 0 0))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'point 'free))\n (light-position mylight (vector 5 2 0))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)) \n")) ("light-spot-angle" ("número-id-luz número-ângulo" "void" "Ajusta o ângulo do cone da luz spot especificada. Se não é uma luz spot este comando não tem nenhum efeito." " ; turn down the main light\n (light-diffuse 0 (vector 0.1 0.1 0.1))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'spot 'free))\n (light-position mylight (vector (+ 4 (crndf)) (crndf) 2))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n (light-spot-angle mylight (+ 5 (random 40)))\n (light-spot-exponent mylight 500)\n (light-attenuation mylight 'constant 1) \n (light-direction mylight (vector -1 0 -1))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)\n     (scale (vector 10 10 10))\n     (translate (vector -0.5 -0.5 0))\n     (build-seg-plane 20 20)) \n")) ("light-spot-exponent" ("número-id-luz número-exponente" "void" "Ajusta a exponencial da luz spot (dispersão do cone) específicada. Não funciona com outra lâmpada senão a spot." " ; turn down the main light\n (light-diffuse 0 (vector 0.1 0.1 0.1))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'spot 'free))\n (light-position mylight (vector (+ 4 (crndf)) (crndf) 2))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n (light-spot-angle mylight (+ 5 (random 40)))\n (light-spot-exponent mylight 500)\n (light-attenuation mylight 'constant 1) \n (light-direction mylight (vector -1 0 -1))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)\n     (scale (vector 10 10 10))\n     (translate (vector -0.5 -0.5 0))\n     (build-seg-plane 20 20)) \n")) ("light-attenuation" ("número-id-luz símbolo-tipo número-atenuação" "void" "Ajusta a atenuação da luz (decaimento com distância) da luz especificada. O símbolo-tipo, pode ser um dos: constant, linear ou quadratic." " ; turn down the main light\n (light-diffuse 0 (vector 0.1 0.1 0.1))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'spot 'free))\n (light-position mylight (vector (+ 4 (crndf)) (crndf) 2))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n (light-spot-angle mylight (+ 5 (random 40)))\n (light-spot-exponent mylight 500)\n (light-attenuation mylight 'constant 1) \n (light-direction mylight (vector -1 0 -1))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)\n     (scale (vector 10 10 10))\n     (translate (vector -0.5 -0.5 0))\n     (build-seg-plane 20 20)) \n")) ("light-direction" ("número-id-luz vetor-direção" "void" "Ajusta a direção da luz direcional. Se não é uma luz direcional, este comando não tem efeito." " ; turn down the main light\n (light-diffuse 0 (vector 0.1 0.1 0.1))\n (light-specular 0 (vector 0 0 0))\n (light-ambient 0 (vector 0 0 0))\n \n (define mylight (make-light 'spot 'free))\n (light-position mylight (vector (+ 4 (crndf)) (crndf) 2))\n (light-diffuse mylight (rndvec))\n (light-ambient mylight (vmul (rndvec) 0.1))\n (light-specular mylight (vmul (rndvec) 10))\n (light-spot-angle mylight (+ 5 (random 40)))\n (light-spot-exponent mylight 500)\n (light-attenuation mylight 'constant 1) \n (light-direction mylight (vector -1 0 -1))\n \n (with-state\n     (ambient (vector 1 1 1))\n     (colour (vector 1 1 1))\n     (specular (vector 0.5 0.5 0.5))\n     (shinyness 20)\n     (build-torus 1 2 20 20)\n     (scale (vector 10 10 10))\n     (translate (vector -0.5 -0.5 0))\n     (build-seg-plane 20 20)) \n"))))) ("renderer" ("Estes comandos são os controladores de baixo nível do renderizador. Você não deveria usá-los a menos que esteja implementando um renderizador do fluxus fora da interface scratchpad." "" (("make-renderer" ("" "número-render-id" "Faz um novo renderizador de gráfico da cena [scenegraph]" " (make-renderer)\n")) ("renderer-grab" ("número-id-renderizador" "void" "Faz este renderizador o atual contexto para comandos." " (renderer-grab renderer)\n")) ("renderer-ungrab" ("" "void" "Pop o contexto da pilha do renderizador." " (renderer-grab renderer)\n")) ("fluxus-render" ("" "void" "Limpa o buffer de fundo, e renderiza tudo." " (fluxus-render)\n")) ("tick-physics" ("" "void" "Atualiza o sistema de física." " (tick-physics)\n")) ("render-physics" ("" "void" "Renderiza o sistema de física (para gráficos ajudantes). Este é o comando de baixo nível - use set-physics-debug ao invés." " (render-physics)\n")) ("reset-renderers" ("" "void" "Deleta todos os renderizadores e faz um novo como padrão." " (reset-renderers)\n")) ("reshape" ("número-largura número-altura" "void" "Chama reshape no render atual." " (reshape 100 100)\n")) ("fluxus-init" ("" "void" "Inicia todo o sistema de renderização, só precisa ser chamado uma vez." " (fluxus-init)\n")) ("fluxus-error-log" ("" "void" "Retorna uma string contendo informação sobre o erro no último frame." " (display (fluxus-error-log))\n"))))) ("audio" ("Esta parte do fluxus é responsável por capturar o som entrando, e processar ele em dados harmonicos, usando fft (Fast Fourier Transform). As harmonicas são bandas de frequência em que o som é dividido, dando alguma indicação da qualidade do som. É o mesmo que você ve num equalisador gráfico - de fato, um dos scripts de exemplo (bars.scm) age como tal, e pode ser usado para testar se o áudio está funcionando." " (start-audio \"alsa_pcm:capture_1\" 1024 44100)\n (define (animate)\n\t\t(colour (vector (gh 1) (gh 2) (gh 3))) ; make a colour from the harmonics, and set it to be the current colour \n\t\t(draw-cube)) ; draw a cube with this colour\n (every-frame (animate))\n" (("start-audio" ("string-porta-do-jack número-tamanho-buffer número-taxa-amostragem" "void" "Inicia o áudio com as configurações específicadas, você precisa chamar isto primeiro, ou colocar isto em $HOME/.fluxus.scm para chamar automaticamente na inícialização. Tenha a porta do jack como uma string vazia (\"\") e ele não vai tentar conectar em nada para você. Que pode então usar qjackctrl ou equivalente para fazer a conexão manualmente. Fluxus lè uma única fonte mono." " (start-audio \"alsa_pcm:capture_1\" 1024 44100)\n")) ("gh" ("número-harmonico" "void" "Fluxus converte áudio entrando em frequências harmônicas, que pode então ser ligada em suas animações através desse comando. Existem 16 bandas harmônicas disponiveis, o argumento do valor-harmônico vai ser arredondado se maior ou menor que 16, então você pode usar esse comando sem se preocupar sobre erros fora do alcance." " (define (animate)\n\t\t(colour (vector (gh 1) (gh 2) (gh 3))) ; make a colour from the harmonics, and set it to be the current colour \n\t\t(draw-cube)) ; draw a cube with this colour\n (every-frame (animate))\n")) ("ga" ("" "vetor-buffer-audio" "Retorna o conteúdo do buffer de audio atual." " (clear)\n (define p (build-ribbon 128))\n (with-primitive p\n    (hint-unlit)\n    (pdata-map! (lambda (w) .1) \"w\"))\n\n (every-frame\n    (let ([a (ga)])\n        (with-primitive p\n            (pdata-index-map!\n                (lambda (i p)\n                    (vector (* .25 (- i (/ (pdata-size) 2))) (* 10 (vector-ref a i)) 0))\n                \"p\"))))\n")) ("gain" ("número-gain" "void" "Ajusta o nível de amplificação para o som fft, é 1 por padrão." " (gain 100) ; muito quieto?!\n")) ("process" ("wavfile-string" "void" "Este comando desativa temporariamente a leitura em tempo real da entrada da pista de áudio e lê um arquivo wav ao invés. Para usar com o comando framedump para processar audio offline para fazer videos musicais. A vantagem disto é que ele trava a taxa de quadros então a quantidade certa de áudio é lida para cada quadro - fazendo com que a sincrônia entre quadros e audio seja possível." " (process \"somemusic.wav\") ; read a precorded audio file\n")) ("smoothing-bias" ("número-valor" "void" "Uma espécie de média balanceada para as bandas harmônicas que as acalmam com o tempo. Esta opção é por padrão definida como 1.5. O melhor valor realmente depende da qualidade da música, e do tamanho do buffer, e varia de 0 -> 2. Fica mais óbvio se você tentar com o script bars.scm" " (smoothing-bias 0) ; no smoothing\n")) ("update-audio" ("" "void" "Atualiza o subsistema de áudio. Esta função é chamada para você (por frame) no fluxus-canvas.ss" " (update-audio)\n"))))) ("ffgl" ("Freeframe é um sistema de plugin para efeitos de vídeo em tempo-real multi-plataforma. Fluxus suporta FreeFrame 1.5 também conhecido como FreeFrameGL ou FFGL. Plugins FF CPU de renderização em software não são suportadas no momento. Para mais informação visite http://www.freeframe.org" " (clear)\n\n (define p (build-pixels 256 256 #t)) ; input pixelprimitive\n\n (translate (vector 1.1 0 0))\n ; output pixelprimitive - rendering is not active\n ; otherwise it would overwrite the plugin output\n (define op (build-pixels 256 256))\n\n ; load the FFGLTile plugin from the FreeFrame SDK\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (for ([i (ffgl-get-info)]) ; print plugin information\n        (printf \"~a~n\" i))\n   (printf \"~a~n\" (ffgl-get-parameters)) ; parameter names as strings\n   (ffgl-process op p)) ; set destination and source pixelprimitives\n\n (define (anim)\n    ; set plugin parameters as keywords arguments\n    (with-ffgl plugin\n        (ffgl-set-parameter! #:tilex (/ (mouse-x) (vx (get-screen-size)))\n                             #:tiley (/ (mouse-y) (vy (get-screen-size)))))\n    ; render to the input pixelprimitive\n    (with-pixels-renderer p\n        (with-state\n            (clear-colour #(0 1 0))\n            (scale 5)\n            (rotate (vector (* 50 (time)) -17 (* -35 (time))))\n            (draw-cube))))\n\n (every-frame (anim))\n EndFunctionDoc\n StartFunctionDoc-en\n ffgl-load filename-string width-number height-number\n Returns: plugininstance-number\n Description:\n Loads an FFGL plugin and returns a plugin instance. Plugin width and height\n have to be the same as the resolution of the pixel primitive you are about to\n process with the plugin.\n Example: (clear)\n ; load the FFGLTile plugin from the FreeFrame SDK\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-load string-nome-do-arquivo tamanho-comprimento tamanho-altura\n Retorna: número-da-instancia-do-plugin\n Descrição:\n Carrega um plugin FFGL e retorna uma sua instância. Altura e\n comprimento do plugin tem de ser da mesma resolução da primitiva\n piexel que você está prestes a usar.\n Exemplo: (clear)\n ; load the FFGLTile plugin from the FreeFrame SDK\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n EndFunctionDoc\nScheme_Object *ffgl_load(int argc, Scheme_Object **argv)\n{\n  MZ_GC_DECL_REG(1);  MZ_GC_VAR_IN_REG(0,argv);\n  MZ_GC_REG();  ArgCheck(\"ffgl-load\", \"sii\", argc, argv);\n  unsigned ret = FFGLManager::Get()->Load(StringFromScheme(argv[0]),\n        IntFromScheme(argv[1]), IntFromScheme(argv[2]));\n  MZ_GC_UNREG();  if (ret == 0)\n    return scheme_void;\n  else\n    return scheme_make_integer_value(ret);\n}\n\nScheme_Object *ffgl_push(int argc, Scheme_Object **argv)\n{\n  MZ_GC_DECL_REG(1);  MZ_GC_VAR_IN_REG(0,argv);\n  MZ_GC_REG();  ArgCheck(\"ffgl-push\", \"i\", argc, argv);\n  FFGLManager::Get()->Push(IntFromScheme(argv[0]));\n  MZ_GC_UNREG();  return scheme_void;\n}\n\nScheme_Object *ffgl_pop(int argc, Scheme_Object **argv)\n{\n  FFGLManager::Get()->Pop();\n  return scheme_void;\n}\n\n StartFunctionDoc-en\n ffgl-get-info\n Returns: (list of plugin-version-number plugin-id-string plugin-name-string\n                   plugin-type-symbol plugint-description-string plugin-about-string)\n Description:\n Returns plugin information.\n Example: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (for ([i (ffgl-get-info)]) ; print plugin information\n        (printf \"~a~n\" i)))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-get-info\n Retorna: (lista de numero-versao-plugin string-id-plugin string-nome-plugin\n                    tipo-simbolo-plugin string-descriçao plugin string-sobre-plugin)\n Descrição:\n Retorna informação sobre o plugin.\n Exemplo: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (for ([i (ffgl-get-info)]) ; print plugin information\n        (printf \"~a~n\" i)))\n EndFunctionDoc\nScheme_Object *ffgl_get_info(int argc, Scheme_Object **argv)\n{\n  Scheme_Object *info[6];\n  Scheme_Object *ret = NULL;\n  MZ_GC_DECL_REG(4);  MZ_GC_ARRAY_VAR_IN_REG(0,info, 6);\n  MZ_GC_VAR_IN_REG(3,ret);\n  MZ_GC_REG();\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-get-info can only be called while an FFGL plugin is grabbed\" << endl;\n    MZ_GC_UNREG();    return scheme_void;\n  }\n  FFGLPlugin *p = pi->plugin;\n\n  info[0] = scheme_make_double(p->PluginVersion);\n  info[1] = scheme_make_utf8_string(p->PluginID);\n  info[2] = scheme_make_utf8_string(p->PluginName);\n  info[3] = (p->PluginType == FFGLPlugin::FFGL_EFFECT)?\n                  scheme_intern_symbol(\"effect\") :\n                  scheme_intern_symbol(\"source\");\n  info[4] = scheme_make_utf8_string(p->PluginDescription.c_str());\n  info[5] = scheme_make_utf8_string(p->PluginAbout.c_str());\n\n  ret = scheme_build_list(6, info);\n  MZ_GC_UNREG();  return ret;\n}\n\n StartFunctionDoc-en\n ffgl-get-parameters\n Returns: parameter-string-list\n Description:\n Returns the list of parameters.\n Example: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"~a~n\" (ffgl-get-parameters)))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-get-parameters\n Retorna: lista-string-parametros\n Descrição:\n Retorna a lista com os parametros\n Exemplo: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"~a~n\" (ffgl-get-parameters)))\n EndFunctionDoc\nScheme_Object *ffgl_get_parameters(int argc, Scheme_Object **argv)\n{\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-get-parameters can only be called while an FFGL plugin is grabbed\" << endl;\n    return scheme_void;\n  }\n  FFGLPlugin *p = pi->plugin;\n\n  map<string, FFGLParameter> parameters = p->GetParameters();\n\n  int n = parameters.size();\n  map<string, FFGLParameter>::iterator i = parameters.begin();\n\n  Scheme_Object *params[n];\n  Scheme_Object *ret = NULL;\n  MZ_GC_DECL_REG(4);  MZ_GC_ARRAY_VAR_IN_REG(0,params, n);\n  MZ_GC_VAR_IN_REG(3,ret);\n  MZ_GC_REG();  for (int j = 0; j < n; j++, ++i)\n  {\n    params[j] = scheme_make_utf8_string(i->first.c_str());\n  }\n\n  ret = scheme_build_list(n, params);\n  MZ_GC_UNREG();  return ret;\n}\n\n StartFunctionDoc-en\n ffgl-get-parameter-default parameter-name-symbol\n Returns: default-parameter-value\n Description:\n Returns the default parameter value for the given parameter.\n Example: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"tilex default: ~a~n\" (ffgl-get-parameter-default 'tilex)))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-get-parameter-default simbolo-nome-parametro\n Retorna: valor-padrao-parametro\n Descrição:\n Retorna o valor padrão do parametro dado.\n Exemplo: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"tilex default: ~a~n\" (ffgl-get-parameter-default 'tilex)))\n EndFunctionDoc\nScheme_Object *ffgl_get_parameter_default(int argc, Scheme_Object **argv)\n{\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-get-parameter-default can only be called while an FFGL plugin is grabbed\" << endl;\n    return scheme_void;\n  }\n  FFGLPlugin *p = pi->plugin;\n\n  Scheme_Object *ret = NULL;\n  MZ_GC_DECL_REG(2);  MZ_GC_VAR_IN_REG(0,argv);\n  MZ_GC_VAR_IN_REG(1,ret);\n  MZ_GC_REG();\n  ArgCheck(\"ffgl-get-parameter-default\", \"S\", argc, argv);\n  string pname = SCHEME_SYM_VAL(argv[0]);  float f;\n  const char *str;\n  if (!(p->GetDefaultValue(pname, &f, &str)))\n  {\n    Trace::Stream << \"ffgl-get-parameter-default: cannot find parameter \" << pname << endl;\n    MZ_GC_UNREG();    return scheme_void;\n  }\n  if (str == NULL)\n  {\n    ret = scheme_make_double(f);\n  }\n  else\n  {\n    ret = scheme_make_utf8_string(str);\n  }\n\n  MZ_GC_UNREG();  return ret;\n}\n\n StartFunctionDoc-en\n ffgl-get-parameter parameter-name-symbol\n Returns: parameter-value\n Description:\n Returns the current value of the given parameter.\n Example: (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"tilex default: ~a~n\" (ffgl-get-parameter 'tilex)))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-get-parameter simbolo-nome-parametro\n Retorna: valor-parametro\n Descrição:\n Retorna o valor atual do parametro dado.\n Exemplo: (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"tilex default: ~a~n\" (ffgl-get-parameter 'tilex)))\n EndFunctionDoc\nScheme_Object *ffgl_get_parameter(int argc, Scheme_Object **argv)\n{\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-get-parameter can only be called while an FFGL plugin is grabbed\" << endl;\n    return scheme_void;\n  }\n  FFGLPlugin *p = pi->plugin;\n\n  Scheme_Object *ret = NULL;\n  MZ_GC_DECL_REG(2);  MZ_GC_VAR_IN_REG(0,argv);\n  MZ_GC_VAR_IN_REG(1,ret);\n  MZ_GC_REG();\n  ArgCheck(\"ffgl-get-parameter\", \"S\", argc, argv);\n  string pname = SCHEME_SYM_VAL(argv[0]);  float f;\n  const char *str;\n  if (!(p->GetParameter(pi, pname, &f, &str)))\n  {\n    Trace::Stream << \"ffgl-get-parameter: cannot find parameter \" << pname << endl;\n    MZ_GC_UNREG();    return scheme_void;\n  }\n  if (str == NULL)\n  {\n    ret = scheme_make_double(f);\n  }\n  else\n  {\n    ret = scheme_make_utf8_string(str);\n  }\n\n  MZ_GC_UNREG();  return ret;\n}\n\n StartFunctionDoc-en\n ffgl-activate boolean\n Returns: void\n Description:\n Activates, deactivates the plugin.\n Example: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (ffgl-activate #t))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-activate booleano\n Retorna: void\n Descrição:\n Ativa, desativa o plugin.\n Exemplo: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (ffgl-activate #t))\n EndFunctionDoc\nScheme_Object *ffgl_activate(int argc, Scheme_Object **argv)\n{\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-activate can only be called while an FFGL plugin is grabbed\" << endl;\n    return scheme_void;\n  }\n\n  MZ_GC_DECL_REG(1);  MZ_GC_VAR_IN_REG(0,argv);\n  MZ_GC_REG();\n  ArgCheck(\"ffgl-activate\", \"b\", argc, argv);\n\n  pi->Activate(BoolFromScheme(argv[0]));\n\n  MZ_GC_UNREG();  return scheme_void;\n}\n\n StartFunctionDoc-en\n ffgl-active?\n Returns: boolean\n Description:\n Returns #t if the plugin is active, or #f otherwise.\n Example: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (when (ffgl-active?)\n     (display \"plugin is active\")))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-active?\n Retorna: booleano\n Descrição:\n Retorna #t se o plugin está ativo, ou #f se não.\n Exemplo: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (when (ffgl-active?)\n     (display \"plugin is active\")))\n EndFunctionDoc\nScheme_Object *ffgl_active(int argc, Scheme_Object **argv)\n{\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-active? can only be called while an FFGL plugin is grabbed\" << endl;\n    return scheme_void;\n  }\n\n  Scheme_Object *ret;\n  MZ_GC_DECL_REG(1);  MZ_GC_VAR_IN_REG(0,ret);\n  MZ_GC_REG();\n  ret = pi->Active() ? scheme_true : scheme_false;\n\n  MZ_GC_UNREG();  return ret;\n}\n\nScheme_Object *ffgl_set_parameter_list(int argc, Scheme_Object **argv)\n{\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-set-parameter! can only be called while an FFGL plugin is grabbed\" << endl;\n    return scheme_void;\n  }\n  FFGLPlugin *p = pi->plugin;\n\n  Scheme_Object *params = NULL;\n  MZ_GC_DECL_REG(2);  MZ_GC_VAR_IN_REG(0,argv);\n  MZ_GC_VAR_IN_REG(1,params);\n  MZ_GC_REG();\n  ArgCheck(\"ffgl-set-parameter-list\", \"l\", argc, argv);\n\n  params = scheme_list_to_vector(argv[0]);\n\n  for (int n = 0; n < SCHEME_VEC_SIZE(params);n += 2)\n  {\n    if (SCHEME_SYMBOLP(SCHEME_VEC_ELS(params)[n])&& SCHEME_VEC_SIZE(params)> (n + 1))\n    {\n       get the parameter name\n      string pname = SCHEME_SYM_VAL(SCHEME_VEC_ELS(params)[n]);      if (SCHEME_NUMBERP(SCHEME_VEC_ELS(params)[n+ 1]))\n      {\n        float f = FloatFromScheme(SCHEME_VEC_ELS(params)[n+ 1]);\n        if (!(p->SetParameter(pi, pname, f)))\n        {\n          Trace::Stream << \"ffgl-set-parameter!: cannot set parameter \" << pname << endl;\n        }\n      }\n      else\n      if (SCHEME_CHAR_STRINGP(SCHEME_VEC_ELS(params)[n+ 1]))\n      {\n        string s = StringFromScheme(SCHEME_VEC_ELS(params)[n+ 1]);\n        if (!(p->SetParameter(pi, pname, s)))\n        {\n          Trace::Stream << \"ffgl-set-parameter!: cannot set parameter \" << pname << endl;\n        }\n      }\n      else\n      {\n        Trace::Stream << \"ffgl-set-parameter!: wrong parameter type \" << pname << endl;\n      }\n    }\n    else\n    {\n      Trace::Stream << \"ffgl-set-parameter-list: wrong parameter list\" << endl;\n    }\n  }\n\n  MZ_GC_UNREG();  return scheme_void;\n}\n\n StartFunctionDoc-en\n ffgl-get-min-inputs\n Returns: number\n Description:\n Returns the minimum number of input pixel primitives the plugin requires.\n Example: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"~a~n\" (ffgl-get-min-inputs)))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-get-min-inputs\n Retorna: número\n Descrição:\n Retorna o número mínimo de primitivas pixel que o plugin precisa.\n Exemplo: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"~a~n\" (ffgl-get-min-inputs)))\n EndFunctionDoc\nScheme_Object *ffgl_get_min_inputs(int argc, Scheme_Object **argv)\n{\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-get-min-inputs can only be called while an FFGL plugin is grabbed\" << endl;\n    return scheme_void;\n  }\n  FFGLPlugin *p = pi->plugin;\n\n  Scheme_Object *ret;\n  MZ_GC_DECL_REG(1);  MZ_GC_VAR_IN_REG(0,ret);\n  MZ_GC_REG();\n  ret = scheme_make_integer(p->GetMinInputs());\n\n  MZ_GC_UNREG();  return ret;\n}\n\n StartFunctionDoc-en\n ffgl-get-max-inputs\n Returns: number\n Description:\n Returns the maximum number of input pixel primitives the plugin accepts.\n Example: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"~a~n\" (ffgl-get-max-inputs)))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-get-max-inputs\n Retorna: número\n Descrição:\n Retorna o número máximo de primitivas pixel que o plugin aceita.\n Exemplo: (clear)\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (printf \"~a~n\" (ffgl-get-max-inputs)))\n EndFunctionDoc\nScheme_Object *ffgl_get_max_inputs(int argc, Scheme_Object **argv)\n{\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-get-max-inputs can only be called while an FFGL plugin is grabbed\" << endl;\n    return scheme_void;\n  }\n  FFGLPlugin *p = pi->plugin;\n\n  Scheme_Object *ret;\n  MZ_GC_DECL_REG(1);  MZ_GC_VAR_IN_REG(0,ret);\n  MZ_GC_REG();\n  ret = scheme_make_integer(p->GetMaxInputs());\n\n  MZ_GC_UNREG();  return ret;\n}\n\n StartFunctionDoc-en\n ffgl-set-time! time-number\n Returns: void\n Description:\n Sets the time in seconds.\n Example: (clear)\n (define plugin (ffgl-load \"FFGLTime\" 256 256))\n\n (with-ffgl plugin\n   (ffgl-set-time! (time)))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-set-time! número-tempo\n Retorna: void\n Descrição:\n Ajusta o tempo em segundos\n Exemplo: (clear)\n (define plugin (ffgl-load \"FFGLTime\" 256 256))\n\n (with-ffgl plugin\n   (ffgl-set-time! (time)))\n EndFunctionDoc\nScheme_Object *ffgl_set_time(int argc, Scheme_Object **argv)\n{\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-set-time! can only be called while an FFGL plugin is grabbed\" << endl;\n    return scheme_void;\n  }\n  FFGLPlugin *p = pi->plugin;\n\n  DECL_ARGV();  ArgCheck(\"ffgl-set-time!\", \"f\", argc, argv);\n\n  double time = DoubleFromScheme(argv[0]);\n  if (!(p->SetTime(pi, time)))\n  {\n    Trace::Stream << \"ffgl-set-time!: cannot set time\" << endl;\n  }\n\n  MZ_GC_UNREG();  return scheme_void;\n}\n\n StartFunctionDoc-en\n ffgl-process output-pixelprimitiveid-number input-pixelprimitiveid-number ...\n Returns: void\n Description:\n Sets output and input pixel primitives for the grabbed plugin.\n The resolution of the pixel primitives has to be same as the resolution the\n plugin is initialised.\n Example: (clear)\n\n (define p (build-pixels 256 256 #t))\n (define op (build-pixels 256 256))\n\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (ffgl-process op p))\n\n (define (anim)\n    (with-pixels-renderer p\n        (with-state\n            (clear-colour #(0 1 0))\n            (scale 5)\n            (rotate (vector (* 50 (time)) -17 (* -35 (time))))\n            (draw-cube))))\n\n (every-frame (anim))\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-process numero-saida-primitivapixelid número-entrada-primitivapixelid\n Retorna: void\n Descrição:\n Ajusta primitivas pixel de saída e entrada para a primitiva pega. A\n resolução das primitivas pixel tem de ser as mesmas do plugin inicializado.\n Exemplo: (clear)\n\n (define p (build-pixels 256 256 #t))\n (define op (build-pixels 256 256))\n\n (define plugin (ffgl-load \"FFGLTile\" 256 256))\n\n (with-ffgl plugin\n   (ffgl-process op p))\n\n (define (anim)\n    (with-pixels-renderer p\n        (with-state\n            (clear-colour #(0 1 0))\n            (scale 5)\n            (rotate (vector (* 50 (time)) -17 (* -35 (time))))\n            (draw-cube))))\n\n (every-frame (anim))\n EndFunctionDoc\nScheme_Object *ffgl_process(int argc, Scheme_Object **argv)\n{\n  FFGLPluginInstance *pi = FFGLManager::Get()->Current();\n  if (pi == NULL)\n  {\n    Trace::Stream << \"ffgl-process can only be called while an FFGL plugin is grabbed\" << endl;\n    return scheme_void;\n  }\n\n  Scheme_Object *ret = NULL;\n  MZ_GC_DECL_REG(2);  MZ_GC_VAR_IN_REG(0,argv);\n  MZ_GC_VAR_IN_REG(1,ret);\n  MZ_GC_REG();\n  vector<PixelPrimitive *> pixels;\n  for (int i = 0; i < argc; i++)\n  {\n    if (SCHEME_NUMBERP(argv[i]))    {\n      Primitive *prim = Engine::Get()->Renderer()->GetPrimitive(IntFromScheme(argv[i]));      PixelPrimitive *pp = dynamic_cast<PixelPrimitive *>(prim);\n      if (pp == NULL)\n      {\n        pixels.clear();\n        Trace::Stream << \"ffgl-process can only be called on a pixelprimitive\" << endl;\n        MZ_GC_UNREG();        return scheme_void;\n      }\n      pixels.push_back(pp);\n    }\n    else\n    {\n      pixels.clear();\n      Trace::Stream << \"ffgl-process can only be called on a pixelprimitive\" << endl;\n      MZ_GC_UNREG();      return scheme_void;\n    }\n  }\n\n  pi->SetPixels(pixels);\n  pixels.clear();\n  MZ_GC_UNREG();  return scheme_void;\n}\n\n StartFunctionDoc-en\n ffgl-clear-instances\n Returns: void\n Description:\n Clears FFGL plugin instances.\n Example: (ffgl-clear-instances)\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-clear-instances\n Retorna: void\n Descrição:\n Limpa as instancias do plugin FFGL\n Exemplo: (ffgl-clear-instances)\n EndFunctionDoc\nScheme_Object *ffgl_clear_instances(int argc, Scheme_Object **argv)\n{\n  FFGLManager::Get()->ClearInstances();\n  return scheme_void;\n}\n\n StartFunctionDoc-en\n ffgl-clear-cache\n Returns: void\n Description:\n Clears FFGL plugin cache and instances.\n Example: (ffgl-clear-cache)\n EndFunctionDoc\n StartFunctionDoc-pt\n ffgl-clear-cache\n Retorna: void\n Descrição:\n Limpa o cache e instancias do plugin FFGL\n Exemplo: (ffgl-clear-cache)\n EndFunctionDoc\nScheme_Object *ffgl_clear_cache(int argc, Scheme_Object **argv)\n{\n  FFGLManager::Shutdown();\n  return scheme_void;\n}\n\nvoid FFGLFunctions::AddGlobals(Scheme_Env*env)\n{\n  MZ_GC_DECL_REG(1);  MZ_GC_VAR_IN_REG(0,env);\n  MZ_GC_REG();  scheme_add_global(\"ffgl-load\", scheme_make_prim_w_arity(ffgl_load, \"ffgl-load\", 3, 3), env);\n  scheme_add_global(\"ffgl-push\", scheme_make_prim_w_arity(ffgl_push, \"ffgl-push\", 1, 1), env);\n  scheme_add_global(\"ffgl-pop\", scheme_make_prim_w_arity(ffgl_pop, \"ffgl-pop\", 0, 0), env);\n  scheme_add_global(\"ffgl-get-info\", scheme_make_prim_w_arity(ffgl_get_info, \"ffgl-get-info\", 0, 0), env);\n  scheme_add_global(\"ffgl-get-parameters\", scheme_make_prim_w_arity(ffgl_get_parameters, \"ffgl-get-parameters\", 0, 0), env);\n  scheme_add_global(\"ffgl-get-parameter-default\", scheme_make_prim_w_arity(ffgl_get_parameter_default, \"ffgl-get-parameter-default\", 1, 1), env);\n  scheme_add_global(\"ffgl-get-parameter\", scheme_make_prim_w_arity(ffgl_get_parameter, \"ffgl-get-parameter\", 1, 1), env);\n  scheme_add_global(\"ffgl-set-parameter-list\", scheme_make_prim_w_arity(ffgl_set_parameter_list, \"ffgl-set-parameter-list\", 1, 1), env);\n  scheme_add_global(\"ffgl-activate\", scheme_make_prim_w_arity(ffgl_activate, \"ffgl-activate\", 1, 1), env);\n  scheme_add_global(\"ffgl-active?\", scheme_make_prim_w_arity(ffgl_active, \"ffgl-active?\", 0, 0), env);\n  scheme_add_global(\"ffgl-get-min-inputs\", scheme_make_prim_w_arity(ffgl_get_min_inputs, \"ffgl_get_min_inputs\", 0, 0), env);\n  scheme_add_global(\"ffgl-get-max-inputs\", scheme_make_prim_w_arity(ffgl_get_max_inputs, \"ffgl_get_max_inputs\", 0, 0), env);\n  scheme_add_global(\"ffgl-set-time!\", scheme_make_prim_w_arity(ffgl_set_time, \"ffgl_set_time!\", 1, 1), env);\n  scheme_add_global(\"ffgl-process\", scheme_make_prim_w_arity(ffgl_process, \"ffgl-process\", 1, -1), env);\n  scheme_add_global(\"ffgl-clear-instances\", scheme_make_prim_w_arity(ffgl_clear_instances, \"ffgl-clear-instances\", 0, 0), env);\n  scheme_add_global(\"ffgl-clear-cache\", scheme_make_prim_w_arity(ffgl_clear_cache, \"ffgl-clear-cache\", 0, 0), env);\n  MZ_GC_UNREG();}" ())) ("estado-global" ("Estado global é realmente qualquer coisa que controla o renderizador globalmente, então ele afeta todas as primitivas ou controla o renderizador diretamente - p.e. controle de câmera ou efeitos de tela cheia como \"embaçamento\"." "" (("clear-engine" ("" "void" "Limpa o renderizador, e o sistema de física. Este comando não deve ser chamado diretamente, use clear ao invés, já que limpa algumas outras coisas também, e chama clear-engine ele mesmo." " (clear-engine) ; woo hoo!\n")) ("blur" ("número-quantidade" "void" "Ajusta a opção de blur na tela inteira. Menos é mais, mas se você ajustar isto muito baixo vai fazer com que a edição na tela fique impossível de ler, então salve seus scripts primeiro :)." " (blur 0.1) ; para belos rastros\n")) ("fog" ("cor-nuvem-vetor número-quantidade número-ínicio númeor-final" "void" "Ajusta os paramêtros da neblina pra dar uma indicação de profundidade visual (perspectiva aérea no jargão de pintores). Isto pode obscurecer a edição na tela, então mantenha a quantidade baixa." " (clear-colour (vector 0 0 1)) ; fica legal se o fundo de tela bate.\n (fog (vector 0 0 1) 0.01 1 100) ; neblina azul\n")) ("show-axis" ("número-mostrar" "void" "Mostra os eixos de origem do espaço usado;" " (show-axis 1)\n")) ("show-fps" ("número-mostrar" "void" "Mostra uma contaem de fps na parte inferior esquerda da tela." " (show-fps 1)\n")) ("lock-camera" ("número-id-primitiva" "void" "Trava a transformação da camera em cima da transformação do objeto específicado. É como parentear a câmera ao objeto. Esta é a forma mais fácil de dirigir a câmera proceduralmente. Use um número id de 0 para destravar a câmera." " (clear)\n (define obj (build-cube)) ; make a cube for the camera to lock to\n\n (with-state ; make a background cube so we can tell what's happening\n     (hint-wire)\n     (hint-unlit)\n     (texture (load-texture \"test.png\"))\n     (colour (vector 0.5 0.5 0.5))\n     (scale (vector -20 -10 -10))\n     (build-cube))\n\n (lock-camera obj) ; lock the camera to our first cube\n (camera-lag 0.1)  ; set the lag amount, this will smooth out the cube jittery movement\n\n (define (animate)\n     (with-primitive obj\n         (identity)\n         (translate (vector (fmod (time) 5) 0 0)))) ; make a jittery movement\n\n (every-frame (animate))\n")) ("camera-lag" ("número-quantidade" "void" "O travamento da câmera tem um atraso construído junto o que significa que o movimento vai ser macio em relativo a primitiva ao qual ela está travada." " (clear)\n (define obj (build-cube)) ; make a cube for the camera to lock to\n\n (with-state ; make a background cube so we can tell what's happening\n     (hint-wire)\n     (hint-unlit)\n     (texture (load-texture \"test.png\"))\n     (colour (vector 0.5 0.5 0.5))\n     (scale (vector -20 -10 -10))\n     (build-cube))\n\n (lock-camera obj) ; lock the camera to our first cube\n (camera-lag 0.1)  ; set the lag amount, this will smooth out the cube jittery movement\n\n (define (animate)\n     (with-primitive obj\n         (identity)\n         (translate (vector (fmod (time) 5) 0 0)))) ; make a jittery movement\n\n (every-frame (animate))\n")) ("load-texture" ("pngnomedoarquivo-string" "void" "Carrega uma imagem do disco, converte esta a uma textura e retorna o número id. O carregamento da textura se dá no cache de memória, então repetidamente chamar esta função não vai causar que carregue de novo. Use force-load-texture se você está mudando a textura enquanto o script estiver rodando. O png pode ser RGB ou RGBA para usar transparência alpha." " ; simple usage:\n (texture (load-texture \"mytexture.png\"))\n (build-cube) ; the cube will be texture mapped with the image\n\n ; complex usages:\n\n ; the options list can contain the following keys and values:\n ; id: texture-id-number (for adding images to existing textures - for mipmapping and cubemapping)\n ; type: [texture-2d cube-map-positive-x cube-map-negative-x cube-map-positive-y\n ;         cube-map-negative-y cube-map-positive-z cube-map-negative-z]\n ; generate-mipmaps : exact integer, 0 or 1\n ; mip-level : exact integer\n ; border : exact integer\n\n ; setup an environment cube map\n (define t (load-texture \"cube-left.png\" (list 'type 'cube-map-positive-x)))\n (load-texture \"cube-right.png\" (list 'id t 'type 'cube-map-negative-x))\n (load-texture \"cube-top.png\" (list 'id t 'type 'cube-map-positive-y))\n (load-texture \"cube-bottom.png\" (list 'id t 'type 'cube-map-negative-y))\n (load-texture \"cube-front.png\" (list 'id t 'type 'cube-map-positive-z))\n (load-texture \"cube-back.png\" (list 'id t 'type 'cube-map-negative-z))\n (texture t)\n\n ; setup a mipmapped texture with our own images\n ; you need as many levels as it takes you to get to 1X1 pixels from your\n ; level 0 texture size\n (define t2 (load-texture \"m0.png\" (list 'generate-mipmaps 0 'mip-level 0)))\n (load-texture \"m1.png\" (list 'id t2 'generate-mipmaps 0 'mip-level 1))\n (load-texture \"m2.png\" (list 'id t2 'generate-mipmaps 0 'mip-level 2))\n (load-texture \"m3.png\" (list 'id t2 'generate-mipmaps 0 'mip-level 3))\n (texture (load-texture \"mytexture.png\"\n        (list\n          'generate-mipmaps 0  ; turn mipmapping off\n              'border 2)))          ; add a border to the texture\n\n (build-cube) ; the cube will be texture mapped with the image\n")) ("clear-texture-cache" ("" "void" "Clears the texture cache, meaning changed textures on disk are reloaded." " (clear-texture-cache)\n")) ("frustum" ("número-esquerda número-direita número-baixo número-topo" "void" "Ajusta o frustum da camera, e portanto o quociente de aspecto do frame." " (frustum -1 1 -0.75 0.75) ; definições padrão\n")) ("clip" ("número-frente número-trás" "void" "Ajusta os planos de clipagem da frente e de trás para o frustum da câmera, portanto o ângulo de visão. Mude a distância da frente do clip para alterar a perspectiva de telephoto para fisheye." " (clip 1 10000) ; default settings\n")) ("ortho" ("" "void" "Ajusta a projeção ortográfica - p.e. sem perspectiva." " (ortho)\n")) ("persp" ("" "void" "Ajusta a projeção como perspectiva (o padrão) depois que ortho foi acionada." " (persp)\n")) ("set-ortho-zoom" ("número-quantidade" "void" "Ajusta o nível de zoom para a projeção ortográfica." " (set-ortho-zoom 2)\n")) ("clear-colour" ("vetor-cor" "void" "Ajusta a cor que vai limpar o renderizador, isto forma a cor do fundo da cena." " (clear-colour (vector 1 0 0)) ; RED!!!")) ("clear-frame" ("número-ajuste" "void" "ajusta a limpeza do frame, desligado ou ligado." " (clear-frame 0)\n (clear-frame 1)\n")) ("clear-zbuffer" ("número-ajuste" "void" "Ajusta a limpeza do zbuffer, desligado ou ligado." " (clear-zbuffer 0)\n (clear-zbuffer 1)\n")) ("clear-accum" ("número-ajuste" "void" "Ajusta a limpeza do buffer de acumulação, ligado ou desligado" " (clear-accum 1)\n")) ("build_camera" ("" "numeroid-camera" "adiciona uma nova camera/view retorna sua id" " (clear)\n (viewport 0 0.5 0.5 0.5)\n\n (define cam2 (build-camera))\n (current-camera cam2)\n (viewport 0.5 0 0.5 1)\n\n (define cam3 (build-camera))\n (current-camera cam3)\n (set-camera (mmul (mtranslate (vector 0 0 -5))\n         (mrotate (vector 0 45 0))))\n (viewport 0 0 0.5 0.5)\n\n ; render a primitive in one view only\n (define t (with-state\n     (translate (vector 3 0 0))\n     (scale 0.3)\n     (colour (vector 1 0 0))\n     (build-torus 1 2 10 10)))\n\n (with-primitive t\n     (hide 1) ; hide in all\n     (camera-hide 0)) ; unhide in current camera\n\n\n (current-camera 0)\n\n (define c (with-state\n         (hint-cull-ccw)\n         (hint-unlit)\n         (hint-wire)\n         (line-width 2)\n         (colour (vector 0.4 0.3 0.2))\n         (wire-colour (vector 0 0 0))\n         (scale 10)\n         (build-cube)))\n\n (define p (with-state\n         (scale 3)\n         (load-primitive \"widget.obj\")))\n\n (every-frame\n     (with-primitive p\n         (rotate (vector 0 1 0))))\n")) ("current_camera" ("numero-cameraid" "void" "Ajusta a camera atual para usar" " (clear)\n (viewport 0 0.5 0.5 0.5)\n\n (define cam2 (build-camera))\n (current-camera cam2)\n (viewport 0.5 0 0.5 1)\n\n (define cam3 (build-camera))\n (current-camera cam3)\n (set-camera (mmul (mtranslate (vector 0 0 -5))\n         (mrotate (vector 0 45 0))))\n (viewport 0 0 0.5 0.5)\n\n ; render a primitive in one view only\n (define t (with-state\n     (translate (vector 3 0 0))\n     (scale 0.3)\n     (colour (vector 1 0 0))\n     (build-torus 1 2 10 10)))\n\n (with-primitive t\n     (hide 1) ; hide in all\n     (camera-hide 0)) ; unhide in current camera\n\n\n (current-camera 0)\n\n (define c (with-state\n         (hint-cull-ccw)\n         (hint-unlit)\n         (hint-wire)\n         (line-width 2)\n         (colour (vector 0.4 0.3 0.2))\n         (wire-colour (vector 0 0 0))\n         (scale 10)\n         (build-cube)))\n\n (define p (with-state\n         (scale 3)\n         (load-primitive \"widget.obj\")))\n\n (every-frame\n     (with-primitive p\n         (rotate (vector 0 1 0))))\n")) ("viewport" ("numero-x numero-y numero-largura numero-altura" "void" "Ajusta a viewport na câmera atual. Esta é a altura da janela que a câmera renderiza, aonde 0,0 é a ponta inferior esquerda e 1,1 é a ponta superior direita." " (clear)\n (viewport 0 0.5 0.5 0.5)\n\n (define cam2 (build-camera))\n (current-camera cam2)\n (viewport 0.5 0 0.5 1)\n\n (define cam3 (build-camera))\n (current-camera cam3)\n (set-camera (mmul (mtranslate (vector 0 0 -5))\n         (mrotate (vector 0 45 0))))\n (viewport 0 0 0.5 0.5)\n\n ; render a primitive in one view only\n (define t (with-state\n     (translate (vector 3 0 0))\n     (scale 0.3)\n     (colour (vector 1 0 0))\n     (build-torus 1 2 10 10)))\n\n (with-primitive t\n     (hide 1) ; hide in all\n     (camera-hide 0)) ; unhide in current camera\n\n\n (current-camera 0)\n\n (define c (with-state\n         (hint-cull-ccw)\n         (hint-unlit)\n         (hint-wire)\n         (line-width 2)\n         (colour (vector 0.4 0.3 0.2))\n         (wire-colour (vector 0 0 0))\n         (scale 10)\n         (build-cube)))\n\n (define p (with-state\n         (scale 3)\n         (load-primitive \"widget.obj\")))\n\n (every-frame\n     (with-primitive p\n         (rotate (vector 0 1 0))))\n")) ("get-camera" ("" "vetor-matriz" "Pega a transformação da camera. Esta é a função de baixo nível, use get-camera-transform ao invés." " (get-camera)\n")) ("get-locked-matrix" ("" "vetor-matriz" "Pega a matriz de tranformação da câmera travada. Leva em consideração o atraso." " (get-locked-matrix)\n")) ("set-camera" ("" "void" "Ajusta a matriz de transformação da câmera. Esta é a interface de baixo nível usada por set-camera-transform, a qual você devia usar geralmente ao invés." " (set-camera (mtranslate (vector 0 0 -10)))\n")) ("get-projection-transform" ("" "matriz-de-projeção" "Pega a matriz de projeção atual." " (get-projection-transform)\n")) ("set-projection-transform" ("vetor-matriz" "void" "Ajusta a matriz de projeção diretamente." " (set-projection-transform (vector 1 0 0 0 0 4/3 0 0 0 0 -1 -1 0 0 -2 -0))\n")) ("get-screen-size" ("" "vetor-tamanho" "Retorna um vetor contendo a atual largura e altura da janela" " (get-screen-size)\n")) ("set-screen-size" ("vetor-tamanho" "void" "Ajusta a altura e largura da janela." " (set-screen-size (vector 10 10)) ; small window time :)\n (set-screen-size (vector 720 576)) ; and back again!\n")) ("select" ("número-janelaposX número-janelaposY número-tamanho-pixel" "número-id-primitiva" "Olha na região específicada e retorna a id da primitiva mais próxima à renderização da câmera lá, ou 0 se não existente." " (display (select 10 10 2))(newline)\n")) ("select-all" ("numero-telax numero-telay numero-tamanhopixel" "lista de numeros-primitivaid" "Procura na região especificada e retorna todas ids renderizadas lá em uma lista, ou '() se não existe nenhuma." " (display (select-all 10 10 2))(newline)\n")) ("desiredfps" ("número-fps" "void" "Desacelera o renderizador de forma a não pegar 100% de cpu. Isto dá um limite acima na taxa de fps, o que não completamente bate o número dado, mas nós estamos trabalhando nisto..." " (desiredfps 100000) ; faz fluxus renderizar tão rápido quanto pode\n                     ; e levar 100% de cpu.\n")) ("draw-buffer" ("nome-buffer" "void" "Seleciona qual buffer para desenhar, se em modo estéreo você iria fazer 'back-right e 'back-left" " (draw-buffer 'back)\n")) ("read-buffer" ("nome-buffer" "void" "Seleciona qual buffer para ler." " (read-buffer 'back)\n")) ("set-stereo-mode" ("modo" "bool" "seleciona qual modo estéreo a usar, atualmente somente 'cristal-eyes e 'no-stereo são suportados o retorno indica se a operação foi bem sucedida ou não 'crystal-eyes vai retornar falso se você não tem uma janela estéreo." " (set-stereo-mode 'crystal-eyes)\n")) ("set-colour-mask" ("vetor" "void" "Ajusta a máscara de cor dando a esta um quatérnio de booleanos que correspondem aos canais vermelho, verde, azul e alpha respectivamente depois desta operação você vai ver apenas aquelas cores que você ajustar como verdadeiras (isto é útil apenas para estéreo com óculos azul-vermelhos)" " (set-colour-mask #(#t #f #f #t))\n")) ("shadow-light" ("número-ajuste" "void" "Ajusta a luz para usar na geração de sombras, ajuste para 0 para desativar renderização de sombras." " (shadow-light 1)\n")) ("shadow-length" ("número-ajuste" "void" "Ajusta o alcance do volume da renderização da sombra." " (shadow-length 10)\n")) ("shadow-debug" ("número-ajuste" "void" "Liga debug na renderização do volume da sombra." " (shadow-debug 1)\n")) ("accum" ("simbolo-modo número-valor" "void" "Controla o buffer de acumulação (somente chama glAccum embaixo do tapete). Símbolos possíveis são: accum load return add mult" " (accum 'add 1)\n")) ("print-info" ("" "void" "Imprime uma porção de informaçao do renderizador." " (print-info)\n")) ("set-cursor" ("simbolo-nome-imagem" "void" "Troca o cursor do mouse. Simbolos da imagem do cursor consistem em: 'right-arrow, 'left-arrow, 'info, 'destroy, 'help, 'cycle, 'spray, 'wait, 'text, 'crosshair, 'up-down, 'left-right, 'top-side, 'bottom-side, 'left-side, 'right-side, 'top-left-corner, 'top-right-corner, 'bottom-right-corner, 'bottom-left-corner, 'full-crosshair, 'none, 'inherit O cursor padrão quando a janela é criada é 'inherit." " (set-cursor 'crosshair)\n")) ("set-full-screen" ("" "void" "Pede que a janela atual do fluxus fique tela cheia." " (set-full-screen)\n"))))) ("estado-local" ("As funções de estado local controlam a renderização ou do estado corrente - ou do estado da primitiva correntemente pega(grabbed). Em Fluxus estado significa significa a forma que as coisas são mostradas, tanto ligando/desligando opções de render, mudando o estilo de diferentes opções, ou alterando a transformação corrente." "" (("push" ("" "void" "Empurra uma cópia do estado corrente de desenho para o topo da pilha. O estado de desenho contém informação sobre coisas como cor corrente, transformação e dicas(hints)." " (colour (vector 1 0 0)) ; aplica cor corrente pra vermelho\n (push)                  ; copia e empurra estado de desenho\n (colour (vector 0 1 0)) ; aplica cor corrente pra verde\n (draw-cube)         ; desenha um cubo verde\n (pop)           ; esquece estado de desenho antigo\n ; cor corrente é vermelha de novo.\n")) ("pop" ("" "void" "Destrói o estado de desenho corrente, e aplica para o estado corrente o antigo anteriormente empurrado na pilha. O estado de desenho contém informação sobre coisas como cor corrente, transformação e dicas(hints)." " (colour (vector 1 0 0)) ; aplica cor corrente pra vermelho\n (push)                  ; copia e empurra estado de desenho\n (colour (vector 0 1 0)) ; aplica cor corrente pra verde\n (draw-cube)             ; desenha um cubo verde\n (pop)                   ; esquece estado de desenho antigo\n ; cor corrente é vermelha de novo.\n")) ("grab" ("id-do-objeto" "void" "Pega o objeto especificado. Uma vez que o objeto foi pego seu estado pode ser modificado usando os mesmos comandos usados pra ajustar o estado de desenho atual. (ungrab) precisa ser usado para retornar ao estado de desenho normal. \"grabbing\" também pode ser \"pilhado\", neste caso (ungrab) pula para a próxima primitiva pega." " (colour (vector 1 0 0))      ; aplica a cor atual para vermelho\n (define mycube (build-cube)) ; faz um cubo vermelho\n (grab mycube)\n (colour (vector 0 1 0)) ; aplica a cor do cubo como verde\n (ungrab)          ; retorna ao estado normal\n")) ("ungrab" ("" "void" "Solta o objeto pego atualmente, e ou retorna ao estado de desenho normal, ou tira a ultima primitiva pega do topo da pilha." " (colour (vector 1 0 0))      ; aplica a cor atual para vermelho\n (define mycube (build-cube)) ; faz um cubo vermelho\n (grab mycube)\n (colour (vector 0 1 0)) ; aplica a cor verde ao cubo\n (ungrab)          ; retorna ao estado normal\n")) ("apply-transform" ("id-do-objeto" "void" "Aplica a transformação corrente às posições dos vértices do objeto dado e ajusta sua tranformação para identidade." " (rotate (vector 45 0 0))\n (define mycube (build-cube)) ; faz um cubo com uma rotação\n (with-primitive mycube (apply-transform)) ; aplica a rotação aos pontos do cubo\n")) ("opacity" ("valor" "void" "Ajusta a opacidade do estado de desenho atual, ou da primitiva pega atualmente." " (opacity 0.5)\n (define mycube (build-cube)) ; faz um cubo semi-transparente.\n")) ("wire-opacity" ("valor" "void" "Ajusta a opacidade das beiradas da malha no estado ou da primitiva atual." " (hint-none)\n (hint-wire)\n (backfacecull 0)\n (line-width 5)\n (wire-colour (vector 1 1 1))\n (wire-opacity 0.5)\n (build-cube) ; makes a half transparent wireframe cube\n")) ("shinyness" ("valor" "void" "Ajusta o brilho do estado atual de desenho, ou da primitiva atualmente pega. Esse valor ajusta a densidade do brilho especular." " (shinyness 100)\n (specular (vector 1 1 1)) ; ajusta a cor especular\n (define mysphere (build-sphere 10 10)) ; makes a shiny cube\n")) ("colour" ("vetor-cor" "void" "Ajusta a cor do estado de desenho atual, ou a primitiva atualmente pega." " (colour (vector 1 0.5 0.1)) ; mmm laranja...\n (define mycube (build-cube)) ; faz um cubo laranja\n")) ("colour-mode" ("modo Returns: void Description: Muda a forma como Fluxus interpreta dados de cor para o estado de desenho ou da primitiva atual. Os simbolos dos modos de cor são: rgb hsv Exemplo: (clear) (colour-mode 'hsv) (for ((x (in-range 0 10))) (translate (vector 1 0 0)) (colour (vector (/ x 10) 1 1)) (build-cube)) EndFunctionDoc Scheme_Object *colour_mode(int argc, Scheme_Object **argv) { DECL_ARGV(); ArgCheck(\"colour-mode\", \"S\", argc, argv); string mode=SymbolName(argv[0]); if (mode==\"rgb\") Engine::Get()->State()->ColourMode=MODE_RGB; else if (mode==\"hsv\") Engine::Get()->State()->ColourMode=MODE_HSV; else Trace::Stream<<\"colour mode not recognised: \"<<mode<<endl; MZ_GC_UNREG(); return scheme_void; } StartFunctionDoc-en rgb->hsv colour-vector Returns: vector Description: Converts the RGB colour to HSV. Example: (rgb->hsv (vector 1 0.5 0.1)) EndFunctionDoc StartFunctionDoc-pt rgb->hsv vetor-cor" "vetor" "Converte a cor RGB para HSV." " (rgb->hsv (vector 1 0.5 0.1))\n")) ("hsv->rgb" ("vetor-cor" "vetor" "Converte a cor HSV para RGB" " (clear)\n (for* ((x (in-range 0 10))  ; builds a 10x10 HSV colour pattern\n        (y (in-range 0 10)))\n     (identity)\n     (translate (vector x y 0))\n     (colour (hsv->rgb (vector (/ x 10) (/ y 10) 1)))\n     (build-cube))\n")) ("wire-colour" ("vetor-cor" "void" "Ajusta a cor do \"wire frame\" do estado de desenho atual, ou a primitiva atualmente pega. Visível com (hint-wire) na maioria das primitivas." " (wire-colour (vector 1 1 0)) ; ajusta a cor do fio como amarelo\n (hint-wire)\n (define mycube (build-cube)) ; faz um cubo com wireframe amarelo\n")) ("specular" ("vetor-cor" "void" "Ajusta a cor especular do estado de desenho corrente, ou o objeto atualmente pego." " (specular (vector 0 0 1)) ; ajusta azul como a cor especular\n (define mysphere (build-sphere 10 10)) ; faz uma esfera azul brilhante.\n")) ("ambient" ("vetor-cor" "void" "Ajusta a cor ambiente do estado de desenho corrente, ou a primitiva atualmente pega." " (ambient (vector 0 0 1)) ; ajusta a cor ambiente como azul\n (define mysphere (build-sphere 10 10)) ; faz uma chata esfera azul\n")) ("emissive" ("valor" "void" "Ajusta a cor emissiva do estado de desenho atual, ou da primitiva atualmente pega." " (emissive (vector 0 0 1)) ; ajusta a cor emissiva para azul\n (define mysphere (build-sphere 10 10)) ; faz uma esfera azul brilhante\n")) ("identity" ("" "void" "Ajusta a transformação do estado de desenho para identidade, no estado da pilha, ou a primitiva atualmente pega." " (define mycube (with-state\n     (scale (vector 2 2 2)) ; ajusta o tamanho atual pro dobro em cada dimensão\n     (build-cube))) ; faz um cubo aumentado\n\n (with-primitive mycube\n     (identity)) ; apaga a transformação e coloca o cubo de volta ao seu\n                 ; estado original\n")) ("concat" ("matrix" "void" "Concatena (multiplica) uma matriz para o estado de desenho atual ou primitiva pega." " (define mymatrix (mrotate (vector 0 45 0))) ; faz uma matriz\n (concat mymatrix) ; concat ela no estado atual\n (build-cube) ; faz um cubo com esta rotação\n")) ("translate" ("vetor" "void" "Aplica uma translação ao estado de desenho atual ou primitiva pega" " (translate (vector 0 1.4 0)) ; translada a transformação atual pra\n                              ; cima um pouco\n (build-cube) ; constrói um cubo com esta transformação\n")) ("rotate" ("vetor-ou-quaternion" "void" "Aplica uma rotação ao estado de desenho atual ou primitiva pega." " (rotate (vector 0 45 0)) ; vira 45 graus no eixo Y\n (build-cube) ; constrói um cubo com esta transformação\n")) ("scale" ("vetor" "void" "Aplica uma escalagem ao estado de desenho atual ou primitiva pega." " (scale (vector 0.5 0.5 0.5)) ; escala a tranformação atual para\n                              ; metade do tamanho\n (build-cube) ; constrói um cubo com esta transformação\n")) ("get-transform" ("" "vetor-matriz" "Retorna uma matriz representando o estado de tranformação corrente ou para a primitiva pega." " (clear)\n ; build a hierarchy\n (define a\n     (with-state\n         (colour (vector 1 0.5 0.5))\n         (build-cube)))\n (define b (with-state\n         (colour (vector 0.5 1 0.5))\n         (parent a)\n         (translate (vector 2 0 0))\n         (build-cube)))\n (define c (with-state\n         (colour (vector 0.5 0.5 1))\n         (parent b)\n         (translate (vector 2 0 0))\n         (build-cube)))\n\n (define (animate)\n     ; animate the heirarchy\n     (with-primitive a (rotate (vector 0 0 (sin (time)))))\n     (with-primitive b (rotate (vector 0 0 (sin (time)))))\n     (with-primitive c (rotate (vector 0 0 (sin (time)))))\n\n     ; position a yellow sphere with c's local transform\n     (with-state\n         (concat (with-primitive c (get-transform)))\n         (opacity 0.5)\n         (colour (vector 1 1 0))\n         (draw-sphere))\n\n     ; position a purple sphere with c's global transform\n     (with-state\n         (concat (with-primitive c (get-global-transform)))\n         (opacity 0.5)\n         (colour (vector 1 0 1))\n         (draw-sphere)))\n\n (every-frame (animate))\n")) ("get-global-transform" ("" "matriz-vetor" "Retorna uma matriz representando a transformação global atual para a primitiva atual" " (clear)\n ; build a hierarchy\n (define a\n     (with-state\n         (colour (vector 1 0.5 0.5))\n         (build-cube)))\n (define b (with-state\n         (colour (vector 0.5 1 0.5))\n         (parent a)\n         (translate (vector 2 0 0))\n         (build-cube)))\n (define c (with-state\n         (colour (vector 0.5 0.5 1))\n         (parent b)\n         (translate (vector 2 0 0))\n         (build-cube)))\n\n (define (animate)\n     ; animate the heirarchy\n     (with-primitive a (rotate (vector 0 0 (sin (time)))))\n     (with-primitive b (rotate (vector 0 0 (sin (time)))))\n     (with-primitive c (rotate (vector 0 0 (sin (time)))))\n\n     ; position a yellow sphere with c's local transform\n     (with-state\n         (concat (with-primitive c (get-transform)))\n         (opacity 0.5)\n         (colour (vector 1 1 0))\n         (draw-sphere))\n\n     ; position a purple sphere with c's global transform\n     (with-state\n         (concat (with-primitive c (get-global-transform)))\n         (opacity 0.5)\n         (colour (vector 1 0 1))\n         (draw-sphere)))\n\n (every-frame (animate))\n")) ("parent" ("id-primitiva" "void" "Parenteia a primitiva correntemente pega à primitiva pai dada. A primitiva corrente vai ser agora movida junto com o pai por adquirir todas as suas transformações." " (define parent-prim (build-cube)) ; make a parent cube\n (translate (vector 2 0 0)) ; move a bit in x\n (parent parent-prim) ; set parent-prim as the current parent\n (define child-prim (build-cube)) ; make a child cube\n (grab parent-prim)\n (rotate (vector 0 45 0)) ; the child will now be moved by this transform in addition to its own\n (ungrab)\n")) ("line-width" ("valor" "void" "Ajusta a largura da linha (em espaço de tela) do estado de desenho corrente, ou da primitiva correntemente pega, Afeta wireframe e afins." " (line-width 5)\n (hint-wire)\n (build-sphere 10 10) ; faz uma esfera com um denso wireframe\n")) ("point-width" ("value" "void" "Ajusta o tamanho do ponto (em espaço na tela) do estado de desenho corrente, ou da primitiva pega. Afeta a renderização de pontos e particulas no hardware." " (point-width 5)\n (hint-points)\n (build-sphere 10 10) ; faz uma esfera com pontos grossos\n")) ("blend-mode" ("src dst" "void" "Ajusta o modo de mistura do estado de desenho corrente, ou da primitiva pega. Esse é o modo que o alpha é composto no superficie renderizada." " ; list out all the possible blendmodes\n\n (define src-blend (vector 'zero 'one 'dst-color 'one-minus-dst-color 'src-alpha\n                     'one-minus-src-alpha 'dst-alpha 'one-minus-dst-alpha\n                     'src-alpha-saturate))\n\n (define dst-blend (vector 'zero 'one 'src-color 'one-minus-src-color 'src-alpha\n                     'one-minus-src-alpha 'dst-alpha 'one-minus-dst-alpha))\n\n ; picks a random element\n (define (pick-rnd-item l)\n     (vector-ref l (random (vector-length l))))\n\n ; make lots of random spheres\n (define (rnd-sphere n)\n     (push)\n     (hint-depth-sort)\n     (opacity 0.5)\n     (colour (vector (flxrnd) (flxrnd) (flxrnd)))\n\n     ; set a random blendmode\n     (blend-mode (pick-rnd-item src-blend) (pick-rnd-item dst-blend))\n\n     (translate (vector (flxrnd) (flxrnd) (flxrnd)))\n     (scale (vector 0.1 0.1 0.1))\n     (build-sphere 10 10)\n     (pop)\n     (if (zero? n)\n         0\n         (rnd-sphere (- n 1))))\n\n (clear)\n (clear-colour (vector 0.5 0.5 0.5))\n (rnd-sphere 100)\n")) ("hint-solid" ("" "void" "Ajusta as dicas pra renderizar como solid no estado de desenho corrente, ou a primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas." " (hint-solid) ; esse é o estilo de render original então não deve\n              ; muito estimulante\n (build-cube) ; faz um cubo renderizado sólido\n")) ("hint-wire" ("" "void" "Ajusta o render para wireframe no modo de estado corrente, ou da primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas." " (hint-wire)\n (build-cube) ; faz um cubo em wireframe\n")) ("hint-wire-stippled" ("" "void" "Ajusta as dicas de render para fios pontilhados no estado de desenho ou primitiva atual." " (hint-none)\n (hint-wire-stippled)\n (build-cube) ; make a stippled wirefame cube\n")) ("hint-frustum-cull" ("" "void" "Ajusta as dicas de render para ativar frustum culling no estado de desenho, ou primitiva atual. Dicas de render muda a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou não ter efeito em certos tipos de primitivas, por isso o nome dica. Quando usar frustum culling, certifique-se de chamar (recalc-bb) na primitiva também." " (hint-frustum-cull)\n")) ("hint-normalize" ("" "void" "Se o estado de transformação atual contém uma escalagem, as normais transformadas podem não ser unitárias em tamanho, resultando em problemas indesejáveis em relação à iluminação. (hint-normalize) faz todas as normais serem de tamanho unitário depois de terem sido transformadas. Isto é requerido se o estado de desenho atual contém escalagem não uniforme." " (clear)\n (hint-normalize)\n (build-cube)\n ; non uniform scaling\n (with-primitive (build-cube)\n    (translate #(.5 0 0))\n    (scale #(3 1 1))\n    (translate #(.5 0 0)))\n ; uniform scaling\n (with-primitive (build-cube)\n    (translate #(0 0 2))\n    (scale 2))\n")) ("hint-noblend" ("" "void" "Desativa blending. Útil se objetos com blending render estão num pixelprimitive." " (clear)\n (hint-wire)\n (scale #(9.8 8 1))\n (translate #(-1 -.5 0))\n (define p0 (build-pixels 512 512 #t))\n (with-pixels-renderer p0\n    (hint-ignore-depth)\n    (with-primitive (build-particles 2048)\n        (pdata-map! (lambda (p) (vmul (crndvec) 2)) \"p\")\n        (pdata-map! (lambda (c) #(1 .5)) \"c\")))\n\n (hint-noblend)\n (translate #(1 0 0))\n (define p1 (build-pixels 512 512 #t))\n (with-pixels-renderer p1\n    (hint-ignore-depth)\n    (with-primitive (build-particles 2048)\n        (pdata-map! (lambda (p) (vmul (crndvec) 2)) \"p\")\n        (pdata-map! (lambda (c) #(1 .5)) \"c\")))\n")) ("hint-noswrite" ("" "void" "Desativa escrita em z. Útil para algumas transparencias hackeadas." " (clear)\n (hint-noblend)\n")) ("line-pattern" ("fator padrão" "void" "Fator especifica um multiplicador para cada bit no padrão da linha pontilhada. Padrão especifica um inteiro de 16 bits em que o padrão do bit determina qual fragmento da linha vai ser desenhado quando a linha é rasterizada." " (hint-none)\n (hint-wire-stippled)\n (line-pattern 4 #x0aaaa)\n (build-cube) ; make a stippled wirefame cube\n")) ("hint-normal" ("" "void" "Ajusta as dicas de render para fazer aparecer normais no estado de desenho corrente, ou da primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas." " (hint-normal)\n (build-cube) ; mostra as normais do cubo\n")) ("hint-points" ("" "void" "Ajusta as dicas para aparecer pontos no estado de desenho corrente, ou da primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas." " (hint-points)\n (build-cube) ; mostra os pontos dos vertices deste cubo\n")) ("hint-anti-alias" ("" "void" "Ajusta as dicas de render para anti-alias no estado de desenho atual, ou da primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas." " (hint-anti-alias)\n (build-cube) ; mostra um cubo macio\n")) ("hint-unlit" ("" "void" "Ajusta as dicas de render para luzes desligadas no estado de desenho corrente, ou da primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas." " (hint-unlit)\n (build-cube) ; mostra um cubo sem iluminação\n")) ("hint-vertcols" ("" "void" "Ajusta as dicas de render pra usar cores de vértices no estado de desenho corrente, ou da primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas. Cores de vértices modificam o estado atual de (colour)." " (clear)\n (hint-vertcols)\n (define mycube (build-cube)) ; make a cube with vertcols enabled\n\n (with-primitive mycube\n     (pdata-map!\n         (lambda (c)\n             (rndvec)) ; randomise the vertcols\n         \"c\"))\n")) ("hint-box" ("" "void" "Ajusta as dicas de render para mostrar a caixa envolvente no estado de desenho corrente, ou a primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas." " (hint-box)\n (build-sphere 10 10) ; faz uma esfera com a bounding box\n")) ("hint-none" ("" "void" "Limpa as dicas de render no estado de desenho corrente, ou da primitiva pega. Isso permite que você se livre do estilo sólido default, mas também significa que voce pode ligar e desligar dicas sem usar push ou pop" " (hint-none)\n (hint-wire)\n (build-cube) ; faz um cubo vísivel apenas em wireframe\n")) ("hint-origin" ("" "void" "Ajusta as dicas de render para mostrar a origem espacial do objeto no estado de desenho corrente, ou da primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas." " (hint-origin)\n (build-sphere 10 10) ; make a sphere with the origin displayed\n")) ("hint-cast-shadow" ("" "void" "(nota: não implementado ainda) Ajusta as dicas de render para fazer sombra para o estado de desenho atual, ou a primitiva pega. Dicas de render podem mudar a forma que as primitivas são renderizadas, mas pode ter efeitos diferentes- ou nenhum efeito em certas primitivas, portanto o nome dica." " (hint-origin)\n (build-sphere 10 10) ; make a sphere with the origin displayed\n")) ("hint-depth-sort" ("" "void" "Ajusta as dicas de render para separar em profundidade o estado corrente, ou a primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas." " (hint-depth-sort)\n (build-sphere 10 10)\n")) ("hint-ignore-depth" ("" "void" "Ajusta as dicas de render para ignorar tested de profundidade no estado corrente de desenho, ou da primitiva pega. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas. Essa capacidade é util para renderizar objetos transparentes, já que ela significa que objetos vão aparecer atrás de outros já renderizados." " (clear)\n (with-state\n     (hint-ignore-depth)\n     (opacity 0.6)\n     (with-state\n         (colour (vector 1 0 0))\n         (build-cube))\n     (with-state\n         (colour (vector 0 1 0))\n         (translate (vector 1 0 0))\n         (build-cube)))\n")) ("hint-lazy-parent" ("" "void" "Ajusta as dicas de render para prevenir esta primitiva de passar suas transformações a um filho. Dicas de render mudam a forma como as primitivas são renderizadas, mas podem ter efeitos diferentes - ou nenhum efeito em certas primitivas portanto o nome dicas." " (hint-lazy-parent)\n (build-sphere 10 10) ; make a sphere with the origin displayed\n")) ("hint-cull-ccw" ("" "void" "Vira as faces das quais a face anterior é excluida(culled)." " (hint-cull-ccw)\n (build-sphere 10 10) ; make an inside out\n")) ("hint-sphere-map" ("" "void" "Ajusta as dicas para renderizar objetos como se eles fossem perfeitamente refletivos para o estado ou primitiva atual." " (clear)\n (hint-sphere-map)\n (texture (load-texture \"test.png\"))\n (define p (build-torus 1 2 20 20))\n (every-frame (with-primitive p\n                 (rotate #(.543 .59 .87))))\n")) ("texture" ("número-id-textura" "void" "Ajusta a textura do estado corrente, ou da primitiva pega. Ids de textura podem ser geradas pela função load-texture." " (texture (load-texture \"mytexture.png\"))\n (build-sphere 10 10) ; faz uma textura com mytexture.png\n")) ("multitexture" ("número-textureunit número-id-primitiva" "void" "Ajusta a textura do estado corrente de desenho, ou da primitiva pega da mesma forma que a função textura, mas permite que você especifique a unidade de textura (0-7) para aplicar-lá.Multitextura permite você aplicar diferentes texturas e coordenadas ao mesmo objeto de uma vez. Unidade de textura 0 é o padrão (que usa a pdata \"t\" para suas coordenadas) unidade de textura n olha pela pdata \"tn\" - ie multitexture 1 olha por \"t1\". Você precisa adicionar estas você mesmo usando (pdata-add) ou (pdata-copy). Multitexturas é útil quando a textura contém alpha, já que elas podem ser sobrepostas, por exemplo adesivos colocados em texturas de fundo." " (define obj (build-sphere 10 10)) ; make a sphere\n (grab obj)\n (multitexture 0 (load-texture \"mytextureA.png\"))\n (multitexture 1 (load-texture \"mytextureB.png\"))\n (pdata-add \"t1\" \"v\")   ; make some texture coords for texture B\n (pdata-copy \"t\" \"t1\")  ; copy them from the default texture coords\n (ungrab)\n")) ("print-scene-graph" ("" "void" "Mostra o scene graph corrente, útil para debug." " (print-scene-graph) ; exciting...\n")) ("hide" ("número-escondido" "void" "Ajusta o estado escondido para a primitiva pega (tbm afeta todas as primitivas filhas). Primitivas escondidas podem ser tratadas normalmente em todas as formas - elas apenas não serão renderizadas." " (define obj (build-cube))\n (grab obj)\n (hide 1) ; hide this cube\n (ungrab)\n")) ("camera-hide" ("número-escondido" "void" "Ajusta os estado escondido para a primitiva atual, com a camêra atual (também afeta todas as primitivas descendentes). Permite que você desligue a renderização para as primitivas em camêras diferentes." " (define obj (build-cube))\n (with-primitive obj\n     (camera-hide 1)) ; hide this cube\n")) ("selectable" ("número-selecionável" "void" "Ajusta se a primitiva pega pode ser selecionada ou não, usando o comando select." " (define obj (build-cube))\n (grab obj)\n (selectable 0) ; agora ela nao vai ser \"vista\", quando chamar select\n (ungrab)\n")) ("backfacecull" ("número-ajuste" "void" "Liga ou desliga o corte de face-traseira. Backface culling acelera a renderização removendo faces não orientadas em direção da câmera. É ligado por padrão, mas isto não é desejado sempre, eg para poligonos com dupla face." " (backfacecull 0)\n")) ("shader" ("vertexprograma-string fragmentprogram-string" "void" "Abre, compila e ajusta o par de GLSL hardware shader para o estado de desenho atual, ou a primitiva pega. Requer OpenGL 2. Os dados uniformes do shader podem ser controlados via shader-set! e todas as pdatas são enviadas como um atributo por vértice ao shader." " ; you need to have built fluxus with GLSL=1\n (clear)\n (fluxus-init) ; this is important to add when using shaders\n               ; at the moment, it will be moved somewhere\n               ; to run automatically...\n\n (define s (with-state\n     ; assign the shaders to the surface\n     (shader \"simple.vert.glsl\" \"simple.frag.glsl\")\n     (build-sphere 20 20)))\n\n (with-primitive s\n     ; add and set the pdata - this is then picked up in the vertex shader\n     ; as an input attribute called \"testcol\"\n     (pdata-add \"testcol\" \"v\")\n     ; set the testcol pdata with a random colour for every vertex\n     (pdata-map!\n         (lambda (c)\n             (rndvec))\n         \"testcol\"))\n\n (define (animate)\n     (with-primitive s\n         ; animate the deformamount uniform input parameter\n         (shader-set! (list \"deformamount\" (cos (time))))))\n\n (every-frame (animate))\n")) ("shader" ("vertexprograma-string fragmentprogram-string" "void" "" " ; you need to have built fluxus with GLSL=1\n (clear)\n")) ("clear-shader-cache" ("" "número-id-primitiva" "Limpa o cache do shader." " (clear-shader-cache)\n")) ("shader-set!" ("lista-argumentos" "void" "Ajusta os parâmetros do shader uniforme para o shader GLSL. A lista contém valores pares simbolos-strings, que relacionam os parâmetros de shader correspondentes nomes e valores" " ; you need to have built fluxus with GLSL=1\n (clear)\n (fluxus-init) ; this is important to add when using shaders\n               ; at the moment, it will be moved somewhere\n               ; to run automatically...\n\n (define s (with-state\n     ; assign the shaders to the surface\n     (shader \"simple.vert.glsl\" \"simple.frag.glsl\")\n     (build-sphere 20 20)))\n\n (with-primitive s\n     ; add and set the pdata - this is then picked up in the vertex shader\n     ; as an input attribute called \"testcol\"\n     (pdata-add \"testcol\" \"v\")\n     ; set the testcol pdata with a random colour for every vertex\n     (pdata-map!\n         (lambda (c)\n             (rndvec))\n         \"testcol\"))\n\n (define (animate)\n     (with-primitive s\n         ; animate the deformamount uniform input parameter\n         (shader-set! (list \"deformamount\" (cos (time))))))\n\n (every-frame (animate))\n")) ("texture-params" ("número-unidade-textura lista-parametros" "void" "Ajusta o estado de textura atual para a unidade de textura especificada. Esse estado controla como a textura é aplicada à superfície do objeto, e como é filtrada nos texels, ou miplevels. A unidade de textura é usada se você está usando multitextura - o padrão da unidade de textura é 0. Você talvez precise ler um pouco sobre OpenGL ou experimentar para descubrir mais sobre essas opções." " ; parameters are the following:\n ; tex-env : [modulate decal blend replace]\n ; min : [nearest linear nearest-mipmap-nearest linear-mipmap-nearest linear-mipmap-linear]\n ; mag : [nearest linear]\n ; wrap-s : [clamp repeat]\n ; wrap-t : [clamp repeat]\n ; wrap-r : [clamp repeat] (for cube maps)\n ; border-colour : (vector of length 4)\n ; priority : real number 0 -> 1\n ; env-colour : (vector of length 4)\n ; min-lod : real number (for mipmap blending - default -1000)\n ; max-lod : real number (for mipmap blending - default 1000)\n (texture-params 0 '(min nearest mag nearest))\n"))))) ("dados-primitivos" ("Dados primitivos (pdata para diminuir) é o nome fluxus' para dados que formam primitivas. Em primitivas poligonais isto significa informação dos vértices, em primitivas de partículas isto corresponde a informação da partícula, em primitivas NURBS são os vértices de controle. Acesso a pdata dá a você a habilidade de usar primitivas que de outra forma não seria tão interessante, e deformar e fazer outras primitivas resultando em modelos muito mais detalhados e animações. Você pode também adicionar sua própria pdata, que é tratado exatamente como os tipos já existentes. Dados primitivos são nomeados por strings de tipo, os nomes de qual depende a ordem da primitiva. Todos os comandos Pdata operam na primitiva atualmente pega [grabbed]." " ; uma função para deformar os pontos de um objeto\n (define (deform n)\n     (pdata-set! \"p\" n (vadd  (pdata-ref \"p\" n)                ; o ponto original, mais\n         (vmul (vector (flxrnd) (flxrnd) (flxrnd)) 0.1)))     ; um pequeno vetor randomico\n     (if (zero? n)\n         0\n         (deform (- n 1))))\n     \n (hint-unlit) ; ajustar algumas opções de render\n (hint-wire)  ; para fazer as coisas mais fáceis de ver\n (line-width 4)\n (define myobj (build-sphere 10 10)) ; fazer uma esfera\n (grab myobj)\n (deform (pdata-size)) ; deformá-la\n (ungrab)\n" (("pdata-ref" ("string-tipo número-index" "vetor-valor/cor/matriz/número" "Retorna o elemento pdata correspondente." " (pdata-ref \"p\" 1)\n")) ("pdata-set!" ("string-tipo número-index vetor-valor/cor/matriz/número" "void" "Escreve ao elemento pdata correspondente." " (pdata-set! \"p\" 1 (vector 0 100 0))\n")) ("pdata-add" ("nome-string string-tipo" "void" "Adiciona uma nova array de pdata do usuario. Tipo é um dos sequintes \"v\":vector, \"c\":colour, \"f\":float ou \"m\":matrix." " (pdata-add \"mydata\" \"v\")\n (pdata-set \"mydata\" 0 (vector 1 2 3))\n")) ("pdata-exists?" ("string-nome" "void" "Retorna verdadeiro se a array pdata existe na primitiva." " (with-primitive (build-cube)\n   (when (pdata-exists? \"p\") \n     (display \"we have positions!\") (newline)))\n   (pdata-add \"myarray\" \"v\")\n   (when (pdata-exists? \"myarray\") \n     (display \"we have myarray!\") (newline))))\n")) ("pdata-names" ("" "void" "Retorna uma lista com nomes das arrays de pdata para esta primitiva t -> texture p -> position c -> color" " (with-primitive (build-cube)\n     (display (pdata-names)) (newline))\n")) ("pdata-op" ("string-nomefunc string-nomepdata operador" "void" "Esta é uma função experimental que permite a você fazer operações na pdata muito rapidamente, para constar adicionar elemento por elemento de uma array de pdata para outra. Você pode implementar isto em scheme como um loop sobre cada elemento, mas isto é devagar já que o interpretador está fazendo todo o trabalho. É muito mais rápido se você puder usar um pdata-op já que a mesma operação vai ser apenas uma chamada à scheme." " (clear)\n (define t (build-torus 1 4 10 10))\n \n (with-primitive t\n     (pdata-op \"+\" \"p\" (vector 1 0 0))  ; add a vector to all the pdata vectors\n     (pdata-op \"+\" \"p\" \"n\")  ; add two pdata vectors element for element\n     (pdata-op \"*\" \"n\" (vector -1 -1 -1)) ;  multiply a vector to all the pdata vectors\n     (pdata-op \"*\" \"n\" \"p\")  ; multiply two pdata vectors element for element\n     (let ((pos (pdata-op \"closest\" \"p\" (vector 100 0 0)))) ;  returns position of the closest vertex to this point\n         (with-state ; draw a sphere there\n             (translate pos)\n             (scale (vector 0.1 0.1 0.1))\n             (build-sphere 5 5)))\n     ; can't think of a good example for these...\n     ;(pdata-op \"sin\" \"mydata\" \"myotherdata\")  ; sine of one float pdata to another\n     ;(pdata-op \"cos\" \"mydata\" \"myotherdata\")  ; cosine of one float pdata to another\n     )\n \n ; most common example of pdata op is for particles\n (define p (with-state\n     (hint-points)\n     (point-width 10)\n     (build-particles 100)))\n \n (with-primitive p\n     (pdata-add \"vel\" \"v\") ; add a velocity vector\n     (pdata-map!\n         (lambda (vel)\n             (srndvec)) ; set random velocities\n         \"vel\")\n     (pdata-map!\n         (lambda (c)\n             (rndvec)) ; set random colours\n         \"c\"))\n \n (every-frame (with-primitive p\n     (pdata-op \"+\" \"p\" \"vel\")))\n")) ("pdata-copy" ("string-pdata-de string-pdata-para" "void" "Copia o conteúdo de uma array pdata para outra. As arrays tem que ser do mesmo tipo." " (pdata-copy \"p\" \"mydata\") ; copia as posições de vértices para uma array do usuário\n")) ("pdata-size" ("" "número-contador" "Retorna o tamanho das arrays pdata (elas precisam ser todas a mesma). Isto é principalmente para iterar através das arrays." " (define (mashup n)\n     (pdata-set \"p\" n (vector (flxrnd) (flxrnd) (flxrnd))) ; randomise the vertex position\n     (if (zero? n)\n         0\n         (mashup (- n 1)))) ; loops till n is 0\n\n (define shape (build-sphere 10 10))\n (grab shape)\n (mashup (pdata-size)) ; randomise verts on currently grabbed primitive\n (ungrab)\n")) ("recalc-normals" ("número-macio-ou-não" "void" "Para primitivas poligonais apenas. Olha a posição dos vértices e cálcula as normais da luz pra você automaticamente. Chame com \"1\" para normais macias, \"0\" para normais facetadas." " (define shape (build-sphere 10 10)) ; build a sphere (which is smooth by default)\n (grab shape)\n (recalc-normals 0) ; make the sphere faceted\n (ungrab)\n"))))) ("primitivas" ("Primitivas são objetos que você pode renderizar. Não há muito mais coisas numa cena do fluxus, exceto luzes, uma camera e muitas primitivas." "" (("build-cube" ("" "número-de-id-da-primitiva" "Um simples cubo, mapeamento de textura por face." " (define mynewcube (build-cube))\n")) ("build-polygons" ("número-de-vértices tipo-de-número" "número-de-id-primitiva" "Cónstroi uma primitiva de polígono cru com tamanho de vértices (tudo é inicialmente tido como zero). Tipo é um número que referencia a forma as quais os vértices são interpretados para construir os poligonos, e podem ser os seguintes: 0=TRISTRIP, 1=QUADS, 2=TRILIST, 3=TRIFAN, 4=POLYGON." " (define mynewshape (build-polygons 100 'triangle-strip))\n")) ("build-sphere" ("número-de-cortes-horizontais número-de-cortes-verticais" "número-id-primitiva" "Uma esfera com a resolução especificada, a textura mapeada no estilo normal \"world map\"." " (define mynewshape (build-sphere 10 10))\n")) ("build-torus" ("número-raio-interior número-raio-exterior número-cortes número-fatias" "número-id-primitiva" "Um torus com a resolução especificada, controle o tamanho e a grossura da \"rosquinha\" com o raio inferior e exterior." " (define mynewshape (build-torus 0.5 1 12 12))\n")) ("build-plane" ("" "número-id-primitiva" "Um único plano quadrado, mapeado de 0->1 em ambas as dimensões." " (define mynewshape (build-plane))\n")) ("build-seg-plane" ("número-de-vértices-x número-de-vértices-y" "número-id-primitiva" "Um plano poligonal tesselado, mapeado de 0->1 em ambas dimensões." " (define mynewshape (build-plane))\n")) ("build-cylinder" ("h-segmentos r-segmentos" "número-id-primitiva" "Um cilindro coberto, textura mapeada em volta, e mal mapeada em volta do fim." " (define mynewshape (build-cylinder 10 10))\n")) ("build-ribbon" ("numpoints-número" "número-id-primitiva" "Cónstroi uma linha consistindo de numpoints pontos. A geometria aponta para a câmera constantemente e a textura é mapeada de forma que se alonga na linha do início ao fim. Você usa as funções pdata para editar as posições e largura das linhas. Se usado iluminado, as normais são falseadas para aproximar uma seção circular cruzada. Adicionalmente, se renderização sólida for limpa com (hint-none) e (hint-wire) ativado, uma rápida linha constante vai ser desenhada - largura específicada pelo comando (line-width)." " (define mynewshape (build-ribbon 10))\n")) ("build-text" ("string-texto" "número-id-primitiva" "Constrói uma sequencia de planos, mapeados de forma que uma textura de fonte possa ser usada para visualização. Pode vir a ser útil para coisas mais abstratas. A fonte é assumida como não proporcional - tem um exemplo de fonte acompanhando o fluxus. Ok, so this isn't a very good font texture :)" " (texture (load-texture \"font.png\"))\n (define mynewshape (build-text \"hello\"))\n")) ("build-nurbs-sphere" ("h-segmentos r-segmentos" "número-id-primitiva" "Constrói uma esfera nurbs tesselada, mapead da mesma forma que a esfera poligonal." " (define mynewshape (build-nurbs-sphere 10 10))\n")) ("build-nurbs-plane" ("h-segmento r-segmento" "número-id-primitiva" "Constrói um plano nurbs tesselado, mapeado na direção uv." " (define mynewshape (build-nurbs-plane 10 10))\n")) ("build-particles" ("número-contagem" "número-id-primitiva" "Cónstroi uma primitiva de partículas contendo num pontos, tudo inicialmente aplicado à origem. Você usa as funções pdata para editar as posições, cores e tamanhos. Partículas vêm em dois tipos, sprites apontando pra câmera, que são o padrão, podem ser texturizadas e escaladas individualmente; e pontuais (quando hint-points está aplicado), que não podem ser texturizadas mas são muito mais rápidas de renderizar, já que elas são pontos gl suportados pelo hardware. Por defeito essas partículas pontuais são quadradas, ligue hint-anti-alias para faze-las circulares." " (define mynewshape (build-particles 100))\n")) ("build-locator" ("" "número-id-primitiva" "Um locator é uma primitiva vazia, útil para parentesco (quando você não quer ter o objeto pai visivel). Essa primitiva só pode ser visualizada com (hint-origin) para mostrar sua origem de transformação local." " (define mynewshape (build-locator))\n")) ("load-primitive" ("" "número-id-primitiva" "" " (define mynewshape (load-primitive \"octopus.obj\"))\n")) ("clear-geometry-cache" ("" "número-id-primitiva" "" " (clear-geometry-cache)\n")) ("save-primitive" ("" "número-id-primitiva" "" " (with-primitive (build-sphere 10 10)\n     (save-primitive \"mymesh.obj\"))\n")) ("build-pixels" ("número-largura número-altura" "número-id-primitiva" "Faz uma nova primitiva pixel. Uma primitiva pixel é usada pra fazer texturas procedurais, que podem então ser aplicadas em outras primitivas. Por essa razão, primitivas pixel não vão ser renderizadas muito, mas você pode renderizar elas para visualizar a texturas em um plano." " (define mynewshape (build-pixels 100 100))\n (with-primitive mynewshape\n     (pdata-map!\n         (lambda (c)\n             (rndvec))\n         \"c\")\n     (pixels-upload)) ; call pixels upload to see the results\n")) ("pixels-upload" ("" "void" "Traz os dados da textura, você precisa chamar isto quando você finalizou escrever ao pixelprim, e enquanto ele está \"grabbed\"." " (define mynewshape (build-pixels 100 100))\n (with-primitive mynewshape\n     (pdata-map!\n         (lambda (c)\n             (rndvec))\n         \"c\")\n     (pixels-upload)) ; call pixels upload to see the results\n")) ("pixels->texture" ("número-id-pixelprim" "número-id-textura" "Retorna uma textura que você pode usar exatamente igual uma que foi carregada normalmente." " (define mypixels (build-pixels 100 100))\n (with-primitive mypixels\n     (pdata-map!\n         (lambda (c)\n             (rndvec))\n         \"c\")\n     (pixels-upload))\n\n (with-state\n     (texture (pixels->texture mypixels))\n     (build-torus 1 2 10 10))\n")) ("build-blobby" ("número-influencias vecsubdvision vecfronteira" "número-id-primitiva" "Primitivas blobby no fluxus são uma representação de superfície implicita de alto nível que é definida usando influências no espaço em 3 dimensões. Estas influências são então somadas, e um valor particular é \"malheado\" (usando o algorítmo dos cubos marchando) para formar uma superfície macia. Estas influências podem ser animadas, e a superfície macia mexe e deforma para adaptar, dando a primitiva seu nome blobby. build-blobby retorna uma nova primitiva blobby. número-influências é o número de \"blobs\", Subdivisão permite a você controlar a resolução da superfície em cada dimensão, enquanto vecfronteira ajusta a área fronteriça da primitiva em espaço de objeto local. A malha não vai ser calculada fora desta área limite. Influências de cores e posições precisam ser ajustadas usando pdata-set." " (clear)\n (define b (build-blobby 5 (vector 30 30 30) (vector 1 1 1)))\n \n (with-primitive b\n     (shinyness 100)\n     (specular (vector 1 1 1))\n     (hint-vertcols)\n     (pdata-set \"p\" 0 (vector 0.75 0.25 0.5))\n     (pdata-set \"c\" 0 (vector 0.01 0 0))\n     (pdata-set \"s\" 0 0.01)\n     (pdata-set \"p\" 1 (vector 0.25 0.75 0.5))\n     (pdata-set \"c\" 1 (vector 0 0.01 0))\n     (pdata-set \"s\" 1 0.01)\n     (pdata-set \"p\" 2 (vector 0.75 0.75 0.5))\n     (pdata-set \"c\" 2 (vector 0 0 0.01))\n     (pdata-set \"s\" 2 0.01)\n     (pdata-set \"p\" 3 (vector 0.25 0.25 0.5))\n     (pdata-set \"c\" 3 (vector 0.01 0.01 0))\n     (pdata-set \"s\" 3 0.01)\n     (pdata-set \"p\" 4 (vector 0.5 0.5 0.5))\n     (pdata-set \"c\" 4 (vector 0.01 0.01 0.01))\n     (pdata-set \"s\" 4 0.025))\n")) ("blobby->poly" ("número-id-blobbyprimitiva" "número-id-primitivapoly" "Converte a malha de uma primitiva blobby em uma primitiva poligonal de lista de triângulos." " (clear)\n (define b (build-blobby 5 (vector 30 30 30) (vector 1 1 1)))\n \n (with-primitive b\n     (shinyness 100)\n     (specular (vector 1 1 1))\n     (hint-vertcols)\n     (pdata-set \"p\" 0 (vector 0.75 0.25 0.5))\n     (pdata-set \"c\" 0 (vector 0.01 0 0))\n     (pdata-set \"s\" 0 0.01)\n     (pdata-set \"p\" 1 (vector 0.25 0.75 0.5))\n     (pdata-set \"c\" 1 (vector 0 0.01 0))\n     (pdata-set \"s\" 1 0.01)\n     (pdata-set \"p\" 2 (vector 0.75 0.75 0.5))\n     (pdata-set \"c\" 2 (vector 0 0 0.01))\n     (pdata-set \"s\" 2 0.01)\n     (pdata-set \"p\" 3 (vector 0.25 0.25 0.5))\n     (pdata-set \"c\" 3 (vector 0.01 0.01 0))\n     (pdata-set \"s\" 3 0.01)\n     (pdata-set \"p\" 4 (vector 0.5 0.5 0.5))\n     (pdata-set \"c\" 4 (vector 0.01 0.01 0.01))\n     (pdata-set \"s\" 4 0.025))\n \n (define p (with-state\n     (translate (vector 1 0 0))\n     (blobby->poly b)))\n")) ("draw-instance" ("número-id-primitiva" "void" "Copia um modo retido da primitiva e desenha ela no estado corrente como um no modo imediato." " (define mynewshape (build-cube))\n (colour (vector 1 0 0))\n (draw-instance mynewshape) ; draws a copy of mynewshape\n")) ("draw-cube" ("" "void" "Desenha um cubo no estado imediato corrente." " (define (render)\n     (draw-cube))\n (every-frame (render))\n")) ("draw-plane" ("" "void" "Desenha um plano no estado corrente em modo imediato" " (define (render)\n     (draw-plane))\n (every-frame (render))\n")) ("draw-sphere" ("" "void" "Desenha uma esfera no estado corrente em modo imediato." " (define (render)\n     (draw-sphere))\n (every-frame (render))\n")) ("draw-cylinder" ("" "void" "Desenha um cilindro no estado corrente em modo imediato." " (define (render)\n     (draw-cylinder))\n (every-frame (render))\n")) ("draw-torus" ("" "void" "Desenha um torus no estado imediato corrente." " (define (render)\n     (draw-torus))\n (every-frame (render))\n")) ("destroy" ("número-id-primitive" "void" "Deleta uma primitiva construída do renderizador." " (define mynewshape (build-sphere 10 10))\n (destroy mynewshape)\n")) ("poly-set-index" ("lista-indexada" "void" "Troca a primitiva por modo indexado,e usa a lista como valores de index para essa primitiva." " (clear)\n ; lets build our own cube primitive...\n (define p (build-polygons 8 'quad-list))\n \n (with-primitive p\n     ; setup the vertex data\n     (pdata-set \"p\" 0 (vector -1 -1 -1))\n     (pdata-set \"p\" 1 (vector  1 -1 -1))\n     (pdata-set \"p\" 2 (vector  1 -1  1))\n     (pdata-set \"p\" 3 (vector -1 -1  1))\n     (pdata-set \"p\" 4 (vector -1  1 -1))\n     (pdata-set \"p\" 5 (vector  1  1 -1))\n     (pdata-set \"p\" 6 (vector  1  1  1))\n     (pdata-set \"p\" 7 (vector -1  1  1))\n     (pdata-set \"c\" 0 (vector  0  0  0))\n     (pdata-set \"c\" 1 (vector  0  0  1))\n     (pdata-set \"c\" 2 (vector  0  1  0))\n     (pdata-set \"c\" 3 (vector  0  1  1))\n     (pdata-set \"c\" 4 (vector  1  0  0))\n     (pdata-set \"c\" 5 (vector  1  0  1))\n     (pdata-set \"c\" 6 (vector  1  1  0))\n     (pdata-set \"c\" 7 (vector  1  1  1))\n     \n     (hint-wire)\n     (hint-unlit)\n     (hint-vertcols)\n     \n     ; connect the verts together into faces\n     (poly-set-index (list 7 6 5 4  5 6 2 1 \n             4 5 1 0  1 2 3 0\n             3 7 4 0  6 7 3 2)))\n")) ("poly-convert-to-indexed" ("" "void" "Converte o atual poligono primitivo que está \"grabbed\" de arrays de vértices crus para arrays indexadas. Isto remove vértices duplicados do polígono, fazendo a array de pdata menor, o que aumenta a velocidade do processo." " (define mynewshape (build-sphere 10 10))\n (grab mynewshape)\n (poly-convert-to-indexed)\n (ungrab)\n")) ("build-copy" ("número-primitiva-fonte" "número-id-primitiva" "Retorna uma cópia da primitiva" " (define mynewshape (build-sphere 10 10))\n (define myothernewshape (build-copy mynewshape))\n")) ("make-pfunc" ("string-nome" "número-pfuncid" "Faz uma nova primitiva funcional. Pfuncs variam de propósito geral até operações complexas e especializadas que você pode rodar em primitivas. Todas as pfuncs dividem a mesma interface para controlar e ajustar - pfunc-set! Todos os tipos e argumentos pfunc são como os seguintes: arithmetic Para aplicar aritmética geral para qualquer array pdata. operator string : um dos add sub mul div src string : nome pdata array other string : nome pdata array (opcional) constant float : valor constante (opcional) dst string : nome pdata array genskinweights Gera pesos de skinning - adiciona float pdata chamada \"s1\" -> \"sn\" aonde n é o número de nós no esqueleto - 1 skeleton-root primid-number : a raiz da posebind do esqueleto para skinning sharpness float : um controle de quão afiado o vinco vai ser quando \"skineado\". skinweights->vertcols Uma utilidade para visualizar pesos de skin para debugar. sem argumentos. skinning Skin uma primitiva - deforma ela para seguir os movimentos de um esqueleto. Primitivas que a gente quer usar isto deve conter extra pdata - cópias das posições iniciais das posições dos vértices chamadas \"pref\" e o mesmo para normais, se as normais estão sendo skineadas , chamada \"nref\". skeleton-root primid-number : a primitiva raiz do esqueleto animado bindpose-root primid-number : a raiz primitiva da pose bind do esqueleto skin-normals number : se devemos usar skin nas normais como nas posições" " (define mypfunc (make-pfunc 'arithmetic))\n")) ("pfunc-set!" ("número-id-pfunc lista-argumento" "void" "Ajusta argumentos na função primitiva. Veja a documentação de make-pfunc para todos os argumentos." " (define mypfunc (make-pfunc 'arithmetic))\n (pfunc-set! mypfunc (list 'operator \"add\"\n                           'src \"p\"\n                           'const 0.4\n                           'dst \"p\"))\n")) ("pfunc-run" ("número-id" "void" "Roda uma função primitiva na primitiva atualmente pega." " (define mypfunc (make-pfunc 'arithmetic))\n")) ("geo/line-intersect" ("número-id" "void" "Roda uma função primitiva na primitiva atualmente pega." " (clear)\n (define s (with-state\n         (build-torus 1 2 10 10)))\n \n (define l (with-state\n         (hint-none)\n         (hint-unlit)\n         (hint-wire)\n         (build-line 2)))\n \n (define (check a b)\n     (with-primitive s\n         (for-each\n             (lambda (intersection)                    \n                 (with-state ; draw a sphere at the intersection point\n                     (translate (cdr (assoc \"p\" intersection)))\n                     (colour (vector 0 1 0))\n                     (scale (vector 0.3 0.3 0.3))\n                     (draw-sphere)))\n         (geo/line-intersect a b))))\n \n (every-frame\n     (with-primitive l\n         (pdata-set \"p\" 0 (vector 0 -5 0))\n         (pdata-set \"p\" 1 (vector (* 5 (sin (time))) 5 0))\n         (check (pdata-ref \"p\" 0) (pdata-ref \"p\" 1))))\n"))))) ("funcoes-uteis" ("Funções práticas para deixar a sua vida mais fácil." "" (("time" ("" "numero do tempo(transcorrido, passado) Descriﾃｧﾃ｣o: Retorna o numero de segundos (+ fracao) desde meia noite do dia 1 de janeiro de 1970. Essa e a forma mais simples de animacao para seus scripts Exemplo: (define (animate) (rotate (vector (sin (time)) 0 0)) (draw-cube)) (every-frame (animate)) EndFunctionDoc Scheme_Object *time(int argc, Scheme_Object **argv) { return scheme_make_double(Engine::Get()->Renderer()->GetTime()); } StartFunctionDoc-en delta Returns: time-number Description: Time in seconds since the last frame. Used to make animation frame rate independant. Example: (define (animate) (rotate (vector (* (delta) 10) 0 0)) (draw-cube)) (every-frame (animate)) EndFunctionDoc StartFunctionDoc-pt delta Retorna: numero do tempo(transcorrido, passado)" "Tempo em segundos desde o ultimo frame. Usado pra fazer animacoes com taxa de frames independendente(constante)." " (define (animate)\n     (rotate (vector (* (delta) 10) 0 0))\n     (draw-cube))\n (every-frame (animate))    \n")) ("flxrnd" ("" "número randômico" "Retorna um número randômico entre 0 e 1." " (define (animate)\n     (colour (vector (flxrnd) (flxrnd) (flxrnd)))\n     (draw-cube))\n (every-frame (animate))\n")) ("flxseed" ("número da semente" "void" "Alimenta o gerador de número randômico de forma que nós consigamos a mesma sequência." " (define (animate)\n     (colour (vector (flxrnd) (flxrnd) (flxrnd)))\n     (draw-cube))\n (flxseed 10) \n (every-frame (animate)) ; a mesma sequência de cores será gerada\n")) ("set-searchpaths" ("lista de diretórios" "void" "Arranja um lista de diretórios de busca para procurar por arquivos relacionado ao fluxus, como texturas, shaders etc. Os diretórios ser√o procurados em ordem a cada vez." " (set-searchpaths (append (get-searchpaths) (list \"/path/to/my/textures/\" \"/path/to/my/other/textures/\")))\n")) ("get-searchpaths" ("lista de diretórios" "void" "Arranja um lista de diretórios de busca para procurar por arquivos relacionado ao fluxus, como texturas, shaders etc. Os diretórios serão procurados em ordem a cada vez." " (display (get-searchpaths))(newline)\n")) ("fullpath" ("string do nome do arquivo" "fullpath-string" "Busca os diretórios de procura para o arquivo especificado e retorna a primeira localização que encontra." " (fullpath \"myfile\")\n")) ("framedump" ("nome-do-arquivo" "void" "Salva o buffer OpenGL da frente no disco. Lê a extensão do arquivo pra decidir qual qual formato será usado pra salvar, \"tif\", \"jpg\" ou \"ppm\" são suportados. Esta é a forma de frame dumping de baixo nivel, use start-framedump e end-framedump ao invés." " (framedump \"picture.jpg\")\n")) ("tiled-framedump" ("nome-do-arquivo" "void" "Para renderizar imagens que são maiores que a tela, para imprimir ou outras coisas similares. Este comando usar um método de renderização divididos para renderizar bits de imagens e juntá-los na imagem a ser salva. Lê as extenções de nomes de arquivo para decidir o formato a ser salvo, \"tif\", \"jpg\" ou \"ppm\" são suportados." " (tiled-framedump \"picture.jpg\" 3000 2000)\n"))))) ("openal" ("Openal é uma biblioteca de audio multi-plataforma feita para ser usada junto com aplicativos 3D. EndSectionDoc void FloatsFromScheme(Scheme_Object *src, float *dst, unsigned int size) { MZ_GC_DECL_REG(1); MZ_GC_VAR_IN_REG(0, src); MZ_GC_REG(); assert(size<=(unsigned int)SCHEME_VEC_SIZE(src)); for (unsigned int n=0; n<size; n++) { dst[n]=scheme_real_to_double(SCHEME_VEC_ELS(src)[n]); } MZ_GC_UNREG(); } StartFunctionDoc-en oa-start Returns: void Description: Starts up the openal audio system Example: (oa-start) (define mysample (oa-load-sample (fullpath \"sample.wav\"))) (oa-play mysample (vector 0 0 0) 1 0.2) EndFunctionDoc StartFunctionDoc-pt oa-start Retorna: void Descrição: Inicia o sistema de áudio openal" " (oa-start)\n (define mysample (oa-load-sample (fullpath \"sample.wav\")))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n EndFunctionDoc\nScheme_Object *start(int argc, Scheme_Object **argv)\n{\n\tif (Audio==NULL) Audio = new FluxAudio;\n\treturn scheme_void;\n}\n\n StartFunctionDoc-en\n oa-load-sample \n Returns: sampleid-number\n Description:\n Loads a sample and returns the id number, so it can be played.\n Example: (oa-start)\n (define mysample (oa-load-sample \"sample.wav\"))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n EndFunctionDoc\n StartFunctionDoc-pt\n oa-load-sample\n Retorna: número-sampleid\n Descrição:\n Carrega uma amostra e retorna o número id, de forma que possa ser\n tocada.\n Exemplo: (oa-start)\n (define mysample (oa-load-sample \"sample.wav\"))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n EndFunctionDoc\nScheme_Object *load_sample(int argc, Scheme_Object **argv)\n{\n\tchar *filename=NULL;\n\tMZ_GC_DECL_REG(2);\n\tMZ_GC_VAR_IN_REG(0,argv); \n\tMZ_GC_VAR_IN_REG(1,filename); \n\tMZ_GC_REG();\n\n\tif (!SCHEME_CHAR_STRINGP(argv[0]))scheme_wrong_type(\"oa-load-sample\", \"string\", 0, argc, argv);\n\tint id=0;\n\n\tif (Audio!=NULL)\n\t{\n\t\tfilename=scheme_utf8_encode_to_buffer(SCHEME_CHAR_STR_VAL(argv[0]),SCHEME_CHAR_STRLEN_VAL(argv[0]),NULL,0);\t\tid=Audio->Load(filename);\n\t}\n\t\n\tMZ_GC_UNREG();\n\treturn scheme_make_integer_value(id);\n}\n\n StartFunctionDoc-en\n oa-update\n Returns: void\n Description:\n Keeps the openal code running, is called by the every-frame code.\n Example: (oa-update)\n EndFunctionDoc\n StartFunctionDoc-pt\n oa-update\n Retorna: void\n Descrição:\n Mantém o código openal rodando, é chamado pelo código every-frame.\n Exemplo: (oa-update)\n EndFunctionDoc\nScheme_Object *update(int argc, Scheme_Object **argv)\n{\n\tif (Audio!=NULL)\n\t{\n\t\tAudio->Update();\n\t}\n\treturn scheme_void;\n}\n\n StartFunctionDoc-en\n oa-play sample-id position pitch gain\n Returns: void\n Description:\n Plays a sample. \n Example: (oa-start)\n (define mysample (oa-load-sample (fullpath \"sample.wav\")))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n EndFunctionDoc\n StartFunctionDoc-pt\n oa-play sampleid posição pitch gain\n Retorna: void\n Descrição:\n Toca uma amostra.\n Exemplo: (oa-start)\n (define mysample (oa-load-sample (fullpath \"sample.wav\")))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n EndFunctionDoc\nScheme_Object *play(int argc, Scheme_Object **argv)\n{\n\tMZ_GC_DECL_REG(4);\n\tMZ_GC_VAR_IN_REG(0,argv); \n\tMZ_GC_REG();\n\tif (!SCHEME_NUMBERP(argv[0]))scheme_wrong_type(\"oa-play\", \"number\", 0, argc, argv);\n\tif (!SCHEME_VECTORP(argv[1]))scheme_wrong_type(\"oa-play\", \"vector\", 1, argc, argv);\n\tif (!SCHEME_NUMBERP(argv[2]))scheme_wrong_type(\"oa-play\", \"number\", 2, argc, argv);\n\tif (!SCHEME_NUMBERP(argv[3]))scheme_wrong_type(\"oa-play\", \"number\", 3, argc, argv);\n\n\tif (Audio!=NULL)\n\t{\n\t\tunsigned int id=(unsigned int)scheme_real_to_double(argv[0]);\n\t\tdVector pos;\n\t\tFloatsFromScheme(argv[1],pos.arr(),3);\n\t\tAudio->Play(id,pos,scheme_real_to_double(argv[2]),scheme_real_to_double(argv[3]));\n\t}\n\t\n\tMZ_GC_UNREG();\n\treturn scheme_void;\n}\n\n StartFunctionDoc-en\n oa-set-head-pos pos dir\n Returns: void\n Description:\n Sets the head position, or listener position - which changes the panning and\n perhaps filtering of the sounds to relate to world space position.\n Example: (oa-start)\n (define mysample (oa-load-sample (fullpath \"sample.wav\")))\n (oa-set-head-pos (vector -1 0 0) (vector 0 0 1))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n EndFunctionDoc\n StartFunctionDoc-pt\n oa-set-head-pos pos dir\n Retorna: void\n Descrição:\n Ajusta a posição da cabeça, ou posição do ouvinte - que muda o\n panning e talvez a filtragem dos soms em relação a posição espacial\n no mundo.\n Exemplo: (oa-start)\n (define mysample (oa-load-sample (fullpath \"sample.wav\")))\n (oa-set-head-pos (vector -1 0 0) (vector 0 0 1))\n (oa-play mysample (vector 0 0 0) 1 0.2)\n EndFunctionDoc\nScheme_Object *set_head_pos(int argc, Scheme_Object **argv)\n{\n\tMZ_GC_DECL_REG(2);\n\tMZ_GC_VAR_IN_REG(0,argv); \n\tMZ_GC_REG();\n\tif (!SCHEME_VECTORP(argv[0]))scheme_wrong_type(\"oa-set-head-pos\", \"vector\", 0, argc, argv);\n\tif (!SCHEME_VECTORP(argv[1]))scheme_wrong_type(\"oa-set-head-pos\", \"vector\", 1, argc, argv);\n\n\tif (Audio!=NULL)\n\t{\n\t\tdVector pos;\n\t\tFloatsFromScheme(argv[0],pos.arr(),3);\n\t\tdVector dir;\n\t\tFloatsFromScheme(argv[1],dir.arr(),3);\n\t\n\t\tAudio->SetHeadPos(pos,dir);\n\t}\n\t\n\tMZ_GC_UNREG();\n\treturn scheme_void;\n}\n\n StartFunctionDoc-en\n oa-set-poly polyphony-count\n Returns: void\n Description:\n Sets the number of samples that can be played at once. Defaults to 256.\n Example: (oa-set-poly 256)\n EndFunctionDoc\n StartFunctionDoc-pt\n oa-set-poly contagem-polifônica\n Retorna: void\n Descrição:\n Ajusta o número de amostras que podem ser tocadas de uma\n vez. Padrão é 256.\n Exemplo: (oa-set-poly 256)\n EndFunctionDoc\nScheme_Object *set_poly(int argc, Scheme_Object **argv)\n{\n\tMZ_GC_DECL_REG(1);\n\tMZ_GC_VAR_IN_REG(0,argv); \n\tMZ_GC_REG();\n\tif (!SCHEME_NUMBERP(argv[0]))scheme_wrong_type(\"al-poly\", \"number\", 0, argc, argv);\n\n\tif (Audio!=NULL)\n\t{\n\t\tAudio->SetPoly((unsigned int)scheme_real_to_double(argv[0]));\n\t}\n\t\n\tMZ_GC_UNREG();\n\treturn scheme_void;\n}\n\n StartFunctionDoc-en\n oa-set-cull-dist distance\n Returns: void\n Description:\n Sets distance at which sounds will be stopped playing\n Example: (oa-set-cull-dist 1000)\n EndFunctionDoc\n StartFunctionDoc-pt\n oa-set-cull-dist distancia\n Retorna: void\n Descrição:\n Ajusta a distancia à qual o som vai deixar de tocar.\n Exemplo: (oa-set-cull-dist 1000)\n EndFunctionDoc\nScheme_Object *set_cull_dist(int argc, Scheme_Object **argv)\n{\n\tMZ_GC_DECL_REG(1);\n\tMZ_GC_VAR_IN_REG(0,argv); \n\tMZ_GC_REG();\n\tif (!SCHEME_NUMBERP(argv[0]))scheme_wrong_type(\"oa-set-cull-dist\", \"number\", 0, argc, argv);\n\n\tif (Audio!=NULL)\n\t{\n\t\tAudio->SetCullDist(scheme_real_to_double(argv[0]));\n\t}\n\t\n\tMZ_GC_UNREG();\n\treturn scheme_void;\n}\n\n StartFunctionDoc-en\n oa-set-acoustics attenuation-scale max-distance ref-distance rolloff\n Returns: void\n Description:\n Sets some global acoustic parameters\n Example: (oa-set-acoustics 1 1 1 1)\n EndFunctionDoc\n StartFunctionDoc-pt\n oa-set-acoustics escala-atenuação distancia-max distancia-ref rolloff\n Retorna: void\n Descrição:\n Ajusta alguns parametros globais de acústica.\n Exemplo: (oa-set-acoustics 1 1 1 1)\n EndFunctionDoc\nScheme_Object *set_acoustics(int argc, Scheme_Object **argv)\n{\n\tMZ_GC_DECL_REG(4);\n\tMZ_GC_VAR_IN_REG(0,argv); \n\tMZ_GC_REG();\n\tif (!SCHEME_NUMBERP(argv[0]))scheme_wrong_type(\"oa-set-acoustics\", \"number\", 0, argc, argv);\n\tif (!SCHEME_NUMBERP(argv[1]))scheme_wrong_type(\"oa-set-acoustics\", \"number\", 1, argc, argv);\n\tif (!SCHEME_NUMBERP(argv[2]))scheme_wrong_type(\"oa-set-acoustics\", \"number\", 2, argc, argv);\n\tif (!SCHEME_NUMBERP(argv[3]))scheme_wrong_type(\"oa-set-acoustics\", \"number\", 3, argc, argv);\n\n\tif (Audio!=NULL)\n\t{\n\t\tFluxAudio::AcousticDesc desc;\n\t\tdesc.AttenScale=scheme_real_to_double(argv[0]);\n\t\tdesc.MaxDistance=scheme_real_to_double(argv[1]);\n\t\tdesc.RefDistance=scheme_real_to_double(argv[2]);\n\t\tdesc.Rolloff=scheme_real_to_double(argv[3]);\n\n\t\tAudio->SetAcoustics(desc);\n\t}\n\t\n\tMZ_GC_UNREG();\n\treturn scheme_void;\n}\n\n/\n\nScheme_Object *scheme_reload(Scheme_Env*env)\n{\n\t add all the modules from this extension\n\tScheme_Env*menv=scheme_primitive_module(scheme_intern_symbol(\"fluxus-openal\"), env);\n\n\tscheme_add_global(\"oa-start\", scheme_make_prim_w_arity(start, \"oa-start\", 0, 0), menv);\n\tscheme_add_global(\"oa-load-sample\", scheme_make_prim_w_arity(load_sample, \"oa-load-sample\", 1, 1), menv);\n\tscheme_add_global(\"oa-update\", scheme_make_prim_w_arity(update, \"oa-update\", 0, 0), menv);\n\tscheme_add_global(\"oa-play\", scheme_make_prim_w_arity(play, \"oa-play\", 4, 4), menv);\n\tscheme_add_global(\"oa-set-head-pos\", scheme_make_prim_w_arity(set_head_pos, \"oa-set-head-pos\", 2, 2), menv);\n\tscheme_add_global(\"oa-set-poly\", scheme_make_prim_w_arity(set_poly, \"oa-set-poly\", 1, 1), menv);\n\tscheme_add_global(\"oa-set-cull-dist\", scheme_make_prim_w_arity(set_cull_dist, \"oa-set-cull-dist\", 1, 1), menv);\n\tscheme_add_global(\"oa-set-acoustics\", scheme_make_prim_w_arity(set_acoustics, \"oa-set-acoustics\", 4, 4), menv);\n\n\tscheme_finish_primitive_module(menv);\t\n\t\n\treturn scheme_void;\n}\n\nScheme_Object *scheme_initialize(Scheme_Env*env)\n{\n\treturn scheme_reload(env);\n}\n\nScheme_Object *scheme_module_name()\n{\n\treturn scheme_intern_symbol(\"fluxus-openal\");\n" ())) ("scheme-utils" ("Comandos do fluxus de alto nível escritos em fluxus" "" (("detach-parent" ("" "void" "Remove o pai da primitiva atual, e ajusta as transformações para que a primitiva não mova. Use (parent 1) para evitar este ajuste." " ; builds and animates a random heirarchical structure,\n ; click on the objects to detach them from their parents\n (define (build-heir depth)\n     (with-state\n         (let ((p (with-state\n                         (translate (vector 2 0 0))\n                         (scale 0.9)\n                         (build-cube))))\n             (when (> depth 0)\n                 (parent p)\n                 (for ((i (in-range 0 5)))\n                     (when (zero? (random 3))\n                         (rotate (vector 0 0 (* 45 (crndf))))\n                         (build-heir (- depth 1))))))))\n\n (define (animate-heir children depth)\n     (for-each\n         (lambda (child)\n             (with-primitive child\n                 (rotate (vector 0 0 (sin (+ depth (time)))))\n                 (animate-heir (get-children) (+ depth 1))))\n         children))\n\n (define (animate)\n     (animate-heir (get-children) 0)\n     (when (mouse-button 1)\n         (let ((s (select (mouse-x) (mouse-y) 2)))\n             (when (not (zero? s))\n                 (with-primitive s\n                     (detach-parent))))))\n\n (clear)\n (build-heir 5)\n (every-frame (animate))\n")) ("with-state" ("expressão ..." "resultado da última expressão" "Encapsula mudanças locais, e remove a necessidade de push e pop." " ; state hierachy, by nesting with-state:\n (with-state\n    (hint-vertcols)\n    (colour (vector 0 0 1))\n    (with-state\n        (translate (vector 1 0 0))\n        (build-sphere 10 10))\n     (build-torus 1 2 30 30))\n\n ; making primitives:\n (define my-torus (with-state\n    (hint-vertcols)\n    (colour (vector 0 0 1))\n    (build-torus 1 2 30 30)))\n")) ("with-primitive" ("primitiva expressão ..." "resultado da última expressão" "Encapsula mudanças de estado das primitivas, e remove a necessidade de grab e ungrab." " (define my-torus (with-state\n    (colour (vector 0 0 1))\n    (build-torus 1 2 30 30)))\n\n ; change the torus colour:\n (with-primitive my-torus\n    (colour (vector 0 1 0)))\n")) ("with-pixels-renderer" ("primitiva-pixel expressão ..." "resultado da última expressão" "Permite que você renderize em uma primitiva pixel." "")) ("with-ffgl" ("pluginid-ffgl expressão ..." "resultado da última expressão" "Permite que você trabalhe no plugin FFGL específicado." " (clear)\n (define plugin (ffgl-load \"FFGLTile.dylib\" 256 256))\n\n (with-ffgl plugin\n   (for ([i (ffgl-get-info)])\n        (printf \"~a~n\" i)))\n")) ("pdata-map!" ("procedimento nome-pdata-leitura/escrita nome-pdata-leitura ..." "void" "Uma estrutura de controle de alto nível para simplificar a passagem sobre uma array de pdata para deformação de primitivas. Deve ser mais fácil e menos sujeito a erros do que fazer o loop manualmente. Escreve na primeira array pdata." " (clear)\n (define my-torus (build-torus 1 2 30 30))\n\n (with-primitive my-torus\n   (pdata-map!\n      (lambda (position)\n          (vadd position (vector (flxrnd) 0 0))) ; jitter the vertex in x\n      \"p\")) ; read/write the position pdata array\n\n (with-primitive my-torus\n   (pdata-map!\n      (lambda (position normal)\n          (vadd position normal)) ; add the normal to the position (expand the object)\n      \"p\" \"n\")) ; read/write the position pdata array, read the normals array\n")) ("pdata-index-map!" ("procedimento nome-pdata-leitura/escrita nome-pdata-leitura ..." "void" "Uma estrutura de controle de alto nível para simplificar a passagem sobre uma array de pdata para deformação de primitivas. Mesmo que pdata-map! exceto que pdata-index-map! fornece o índice do elemento pdata atual como o primeiro argumento ao \"procedimento\"." " (clear)\n (define my-torus (build-torus 1 2 30 30))\n\n (with-primitive my-torus\n   (pdata-index-map!\n      (lambda (index position)\n          (vadd position (vector (gh index) 0 0))) ; jitter the vertex in x\n      \"p\")) ; read/write the position pdata array\n")) ("pdata-fold" ("procedimento valor-inicial nome-pdata-leitura ..." "resultado do procedimento de dobragem sobre a array pdata" "Uma estrutura de controle de alto nível para fazer cálculos em arrays pdata. Roda o procedimento sobre cada elemento pdata acumulando o resultado. Deve ser mais fácil e menos sujeito a erros que percorrer manualmente." " (define my-torus (build-torus 1 2 30 30))\n\n ; find the centre of the primitive by averaging\n ; the points position's together\n (let ((centre\n        (with-primitive my-torus\n                        (vdiv (pdata-fold\n                               vadd\n                               (vector 0 0 0)\n                               \"p\") (pdata-size)))))\n\n   (display centre)(newline))\n")) ("pdata-index-fold" ("procedimento valor-inicial nome-pdata-leitura ..." "resultado do procedimento de dobragem sobre a array pdata" "Igual a pdata-fold exceto que passa o índice do elemento pdata atual como o primeiro parâmetro de \"procedimento\"." " (define my-torus (build-torus 1 2 30 30))\n\n ; can't think of a good example for this yet...\n (let ((something\n        (with-primitive my-torus\n                        (vdiv (pdata-index-fold\n                               (lambda (index position ret)\n                                   (vadd ret (vmul position index)))\n                               (vector 0 0 0)\n                               \"p\") (pdata-size)))))\n\n   (display something)(newline))\n"))))) ("high-level-scratchpad-docs" ("O scratchpad é o editor fluxus e a janela gl." "" (("tophelp" ("" "" "" " Fluxus docs\n -----------\n \"act of a flowing; a continuous moving on or passing by, as of a\n flowing stream; a continuous succession of changes\"\n\n \"ato de fluir; um movimento contínuo ou um passar, como a corrente\n do rio; uma sucessão contínua de mudanças\"\n\n Fluxus é uma máquina de renderização em tempo real para\n livecoding em Scheme.\n Você é encorajado a viajar por estes textos enquanto performar\n códigos ao vivo...\n\n O scratchpad de Fluxus têm dois modos de operação, o console\n (você está usando ele agora) que permite que você entre comandos\n e veja o resultado imediatamente. O outro modo é o editor que se\n parece mais com um editor de texto normal -  você tem 9 áreas de\n trabalho( que permite que você edite mais de um script de uma\n vez) vá para eles usando ctrl-1 até ctrl-9 e venha de volta para\n o console com ctrl-0.\n\n Mais tópicos de ajuda:\n (help \"keys\") para comandos do teclado que controlam o fluxus.\n (help \"console\") para mais ajuda sobre o console\n (help \"editor\") para mais ajuda no editor de livecoding\n (help \"camera\") para ajuda nos controles da câmera.\n (help \"linguagem\") informação sobre os comandos no fluxus.\n (help \"misc\") para informações miscelâneas sobre o fluxus.\n (help \"toplap\") para o manifesto toplap.\n (help \"autores\") quem fez isso?\n")) ("keys" ("" "" "" " Teclas do Fluxus\n ----------------\n\n ctrl-f : modo Tela cheia.\n ctrl-w : modo Janela.\n ctrl-h : esconder/mostrar o editor.\n ctrl-l : Carregar um novo script (navegue com os cursores e enter)\n ctrl-s : Salve o script atual.\n ctrl-d : Salvar como - o script atual (abre um caixa com nome)\n ctrl-p : Auto format the whitespace in your scheme script to be more pretty\n ctrl-b : Mostra onde o cursor está.\n ctrl-1 to 9 : Vai para a área de trabalho selecionada.\n ctrl-0 : Vai para o REPL. F3 : Reinicia a câmera.\n F6 : Reinicia completamente o interpretador, depois executa o texto selecionado,\n      ou tudo se não tem nada selecionado.\n F5 : Executao texto selecionado, ou tudo se não tem nada selecionado.\n F9 : Aciona os efeitos no scratchpad.\n F10 : Diminui a opacidade do texto.\n F11 : Aumenta a opacidade do texto.\n F12 : Pausa as teclas durante playback.\n")) ("console" ("" "" "" " Console do Fluxus (ou REPL) ---------------------------\n\n Se você pressionar ctrl e 0, ao invés de abrir outra área de\n trabalho para scripts você vai ser apresentado a um interpretador\n de Leitura EvaluaçãoImpressão e Loop, ou repl por\n diminutivo. Isto realmente é um interpretador interativo similar\n a uma linha de comando, onde você pode entrar código scheme para\n evaluação imediata. Estecódigo é evaluado no mesmo interpretador\n que os outros scripts, então você pode usar o repl para debug ou\n inspecionar variáveis globais e funções que elas definem. Esta janela é também onde todo os erros são impressos, junto com a\n janela de terminal que você iniciou o fluxus.\n")) ("editor" ("" "" "" " EditorFluxus\n -------------\n\n Quando usar o scratchpad do fluxus, a idéia é que você só precise\n da única tela para construir os scripts, ou tocar ao vivo, F5 é a\n chave que roda o script quando vc estiver pronto. Selecionando\n texto (usando shift) e pressionando F5 vai executar somente o\n texto selecionado. Isto é uma mão na roda para re-evaluar funções\n sem rodar o script inteiro toda vez.\n\n Áreas de trabalho\n -----------------\n\n O editor de script permite que voce edite até 9 scripts\n simultaneamente usando diferentes áreas de trabalho. Para trocas\n de área, use ctrl+tecla de número. Somente um script pode rodar\n de uma vez no entanto, apertando F5 vai executar o script da área\n de trabalho ativa atualmente.\n\n Auto foco\n ---------\n\n O editor inclui uma propriedade de auto escalagem/centralização que\n é ligada por padrão. Para desligar - adicione a linha:\n (set! fluxus-scratchpad-do-autofocus 0)\n para o seu arquivo .fluxus.scm - ou crie um novo arquivo chamado\n assim no seu diretório home, contendo essa linha.\n")) ("camera" ("" "void" "" " Fluxus camera control\n ---------------------\n\n A câmera é controlada ao mover o mouse e pressionar os botões ao\n mesmo tempo.\n\n Botão esquerdo do mouse: Rotaciona\n Botão do meio do mouse: Movimenta\n Botão direito do mouse: Afasta/Aproxima(zoom)\n")) ("misc" ("" "" "" " Script init do fluxus\n ---------------------\n Fluxus procura por um script no seu diretório casa ($HOME)chamado\n .fluxus.scm o qual vai ser executado se encontrado. Isto é útil\n para colocar comandos de inicialização (como conectar ao jack ou\n ajustar a linguagem para o texto de ajuda e etc)\n\n Aceleração da taxa de quadros\n -----------------------------\n Por padrão fluxus mantém a taxa de quadros em volta de 40 fps. para\n desligar (e rodar em 100% de cpu), use desiredfps com algum número\n arbitrariamente grande:\n (desiredfps 1000000000)\n Para mostrar a fps use (show-fps 1)\n\n Opções de linha de comando\n --------------------------\n O jeito mais fácil de carregar um script no fluxus é específicar o\n mesmo na linha de comando, eg:\n $ fluxus -x myscript.scm\n Vai lançar o fluxus, carregar, esconder e executar o script.\n\n Fluxus também possui um gravador de teclas apertadas e cliques do\n mouse para gravar sessões de códificação ao vivo (livecoding):\n $ fluxus -r nome-do-arquivo : gravar em arquivo as teclas apertadas\n $ fluxus -p nome-do-arquivo : tocar a partir do arquivo\n $ fluxus -p nome-do-arquivo -d tempo : segundos por quadro\n substituidos para tocar (pra usar com frame-dump)\n\n")) ("authors" ("" "" "" "\n Autores\n -------\n Glauber Alex Dias Prado\n Artem Baguinski\n Dan Bethell\n Nik Gaffney\n Dave Griffiths\n Claude Heiland-Allen\n Alex Norman\n Gabor Papp\n Fabien Pelisson\n Jeff Rose\n James Tittle\n Scott Watson\n EvanRaskob\n\n \"Computadores são inúteis. Elessó podem te dar respostas\".\n     Pablo Picasso (1881 - 1973).\n\n")) ("linguagem" ("" "" "" " Docs da Linguagem\n -----------------\n\n Fluxus é composto de uma série de funções que extendem Scheme pra\n uso em computação gráfica em tempo real.\n\n Scheme em si está fora do escopo desta documentação, mas fluxus é\n uma boa forma de aprender ele. Eurecomendo \"The Little Schemer\"\n por Daniel P. Friedman e Matthias Felleisen.\n\n As funções estão agrupadas em seções para fazer coisas um pouco\n mais fáceis de encontrar.\n\n (help \"sections\")\n    ... lista de seções ...\n (help \"maths\")\n    ... descrição e lista das funções matemáticas ...\n (help \"vmul\")\n    ... detalhes sobre a função com exemplos ...\n\n\n")) ("toplap" ("" "" "" " MANEFESTOTOPLAP\n Nós queremos:\n  * Nos dê acesso a mente do performante, a todo o instrumento humano.\n  * Obscurantismo é perigoso. Nos mostre suas telas.\n  * O Programa é pra ser transcendentalizado - Linguagem Artificial é\n o caminho.\n  * Programas são instrumentos que se alteram eles mesmo.\n  * Código deve ser visto tanto quanto ouvido, algoritmos e sua\n estrutura mostrados como seus resultados visuais.\n  * Codificação ao vivo(livecoding) não é sobre ferramentas.\n  * Algoritmos são pensamentos. Serras-elétrica são ferramentas.\n  * É por isso que algoritmos são mais difíceis de notar que\n  moto-serras.\n\n Nós reconhecemos continuos de interação e profundidade, mas\n preferimos:\n  * Introspecção nos algoritmos.\n  * A habilidosa extemporização de algoritmos como uma amostra\n  expressiva/impressiva da destreza mental.\n  * Sem estoque (minidisc, DVD, computador seguro na net)\n\n Nos sabemos que:\n  * Não é necessário para a audiência entender código para\n  apreciá-lo, da mesma forma em que não é necessário saber tocar uma\n  guitarra para gostar de assistir a uma perfomance de guitarra.\n  * Códificação ao vivo pode ser acompanhado de uma impressionante\n  mostra de destreza manual e a glorificação da interface de\n  datilografia.\n  * Perfomances envolvem continuos de interação, cobrindo talvez o\n  escopo do controle a respeito dos parametros espaciais do trabalho\n  artistico, ou conteudo gestual, particularmente direção de detalhe\n  expressivo. Enquantoa tradicional taxa de tempo táctil variante\n  de expressividade na música tradicional não são aproximadas no\n  código, porque repetir o passado? Sem dúvida a escrita de código e\n  expressão do pensamento daí derivado vai desenvolver suas próprias\n  nuances e particularidades.\n\n Perfomances e eventos próximamente alcançando os critérios desse\n manifesto podem aplicar pela aprovação e selo TOPLAP.\n"))))) ("testing-functions" ("Um conjunto de estruturas de alto nível para manipular objetos e estado no fluxus de uma forma mais limpa e segura." " EndFunctionDoc\n\n#lang scheme/base\n(require \"scratchpad.ss\")\n(require \"help.ss\")\n(require \"camera.ss\")\n(require mzlib/string)\n\n(provide\n  self-test\n  run-scripts)\n\n functions to extract the examples from the helpmap\n indeed its a bit messed, im going to take a look at it, but i cant\n make any guarantees that it is gonna be any better :).\n\n(define (get-function-list section)\n    (caddr (car section)))\n\n(define (get-example func)\n    (cadddr (cadr func)))\n\n(define (get-name func)\n    (car func))\n\n(define (test-functions section log)\n    (for-each\n        (lambda (i)\n            (unit-test (get-name i) (get-example i) log))\n        (get-function-list section)))\n\n(define (test-sections helpmap log)\n    (for-each\n        (lambda (i)\n            (when (not (or\n                (string=? \"high-level-scratchpad-docs\" (car i))\n                (string=? \"frisbee\" (car i))\n                (string=? \"artkp\" (car i))\n                (string=? \"video\" (car i))\n                (string=? \"ffgl\" (car i))\n                (string=? \"fluxa\" (car i))\n                (string=? \"renderer\" (car i))\n                (string=? \"planetarium\" (car i))\n                (string=? \"testing-functions\" (car i)) ; would be silly now, wouldn't it...\n                    ))\n                (test-functions (cdr i) log)))\n        helpmap))\n\n(define errors 0)\n(define error-list '())\n(define do-log #f)\n\n(define (unit-test name code log)\n  (clear)\n  (printf \"testing: ~a~n\" name)\n\n  (cond\n    ((string=? code \"\")\n      (set! errors (+ errors 1))\n      (set! error-list (cons name error-list)))\n    (else\n      (eval-string\n             code\n             (lambda (s)\n               (when do-log\n                     (fprintf log \"--------------------~n\")\n                     (fprintf log \"~a~n\" name)\n                     (fprintf log \"~a~n\" code)\n                     (fprintf log \"~a~n\" s))\n               (set! errors (+ errors 1))\n               (set! error-list (cons name error-list))))))\n    (sleep 0.1)\n    )\n\n(define (go)\n  (let ((log (open-output-file \"log.txt\" #:exists 'replace)))\n      (test-sections (get-helpmap) log)\n    (close-output-port log)\n    (printf \"testing found ~a errors: ~a ~n\" errors error-list)))\n\n StartFunctionDoc-en\n self-test do-logging\n Returns: void\n Description:\n Runs all of the function reference scripts in a separate\n thread so you can watch it in action. Just checks for syntactic errors in the\n scheme, changes in bound C++ function signatures and crashes.\n Graphical code is difficult to test for correctness further (that's my excuse). If\n do-logging is true it outputs a log text file to the current directory for debugging.\n Example: (self-test #t)\n EndFunctionDoc\n StartFunctionDoc-pt\n self-test faz-logar\n Retorna: void\n Descrição:\n Roda todas as funções de referencia nos fluxus em um thread\n separado de forma que você possa ver acontecendo. Apenas checa por\n erros sintáticos em scheme, mudanças nas assinaturas das funçoes\n C++ ligadas e crashes.\n Código gráfico é difícil de testar por correção além (essa é nossa\n desculpa). Se faz-logar for verdadeiro um arquivo texto de log é\n escrito no diretório atual para debugging.\n Exemplo: (self-test #t)\n EndFunctionDoc\n(define (self-test log)\n  (set! do-log log)\n  (thread go))\n\n StartFunctionDoc-en\n run-scripts path-to-examples seconds-per-script\n Returns: void\n Description:\n Runs all of the example scripts in a separate\n thread so you can watch it in action.\n Example: (run-scripts path-to-scripts seconds-per-script)\n EndFunctionDoc\n StartFunctionDoc-pt\n run-scripts caminho-para-exemplos segundos-por-script\n Retorna: void\n Descrição:\n Roda todos os scripts de exemplo em um thread separado para você\n poder assistir.\n Exemplo: (run-scripts path-to-scripts seconds-per-script)\n EndFunctionDoc\n(define example \"\")\n(define run-time 5)\n(define examples-path \"\")\n\n(define (run-example)\n    (load (string-append examples-path example)))\n\n(define (run-all)\n    (for-each\n        (lambda (filename)\n            (let* ((filename (path->string filename))\n                    (len (string-length filename)))\n\n                (when (and (> len 4) (string=? \".scm\" (substring filename (- len 4) len)))\n                    (printf \"~a~n\" filename)\n                    (set! example filename)\n          (clear)\n          (reset-camera)\n                    (let ((thr (thread run-example)))\n                        (sleep run-time)\n                        (kill-thread thr)\n                        (clear))\n                    )))\n        (directory-list examples-path)))\n\n(define (run-scripts path time)\n   (set! examples-path path)\n   (set! run-time time)\n   (thread run-all))\n" ())))))